/*
 * Decompiled with CFR 0.152.
 */
package org.farming.model;

import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.Env;
import org.farming.model.X_FAP_PlantingCycle;

public class MFAPPlantingCycle
extends X_FAP_PlantingCycle {
    private static final long serialVersionUID = -5831361443495335312L;
    private static CCache<Integer, MFAPPlantingCycle> plantingCycleCacheIds = new CCache("FAP_PlantingCycle", 30);
    private static CCache<String, MFAPPlantingCycle> plantingCycleCacheValues = new CCache("FAP_PlantingCycle", 30);

    public MFAPPlantingCycle(Properties ctx, int plantingCycleId, String trxName) {
        super(ctx, plantingCycleId, trxName);
    }

    public MFAPPlantingCycle(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public static MFAPPlantingCycle getById(Properties ctx, int typeId, String trxName) {
        if (typeId <= 0) {
            return null;
        }
        MFAPPlantingCycle type = (MFAPPlantingCycle)plantingCycleCacheIds.get((Object)typeId);
        if (type != null && type.get_ID() > 0) {
            return type;
        }
        type = (MFAPPlantingCycle)new Query(ctx, "FAP_PlantingCycle", "FAP_PlantingCycle_ID=?", trxName).setClient_ID().setParameters(new Object[]{typeId}).first();
        if (type != null && type.get_ID() > 0) {
            int clientId = Env.getAD_Client_ID((Properties)ctx);
            String key = clientId + "#" + type.getValue();
            plantingCycleCacheValues.put((Object)key, (Object)type);
            plantingCycleCacheIds.put((Object)type.get_ID(), (Object)type);
        }
        return type;
    }

    public static MFAPPlantingCycle getByValue(Properties ctx, String typeValue, String trxName) {
        int clientId;
        String key;
        MFAPPlantingCycle type;
        if (typeValue == null) {
            return null;
        }
        if (plantingCycleCacheValues.size() == 0) {
            MFAPPlantingCycle.getAll(ctx, true, trxName);
        }
        if ((type = (MFAPPlantingCycle)plantingCycleCacheValues.get((Object)(key = (clientId = Env.getAD_Client_ID((Properties)ctx)) + "#" + typeValue))) != null && type.get_ID() > 0) {
            return type;
        }
        type = (MFAPPlantingCycle)new Query(ctx, "FAP_PlantingCycle", "Value=?", trxName).setClient_ID().setParameters(new Object[]{typeValue}).first();
        if (type != null && type.get_ID() > 0) {
            plantingCycleCacheValues.put((Object)key, (Object)type);
            plantingCycleCacheIds.put((Object)type.get_ID(), (Object)type);
        }
        return type;
    }

    public static List<MFAPPlantingCycle> getAll(Properties ctx, boolean resetCache, String trxName) {
        if (resetCache || plantingCycleCacheIds.size() > 0) {
            List typeList = new Query(Env.getCtx(), "FAP_PlantingCycle", null, trxName).setClient_ID().setOrderBy("Name").list();
            typeList.stream().forEach(setting -> {
                int clientId = Env.getAD_Client_ID((Properties)ctx);
                String key = clientId + "#" + setting.getValue();
                plantingCycleCacheIds.put((Object)setting.getFAP_PlantingCycle_ID(), setting);
                plantingCycleCacheValues.put((Object)key, setting);
            });
            return typeList;
        }
        List<MFAPPlantingCycle> typeList = plantingCycleCacheIds.entrySet().stream().map(type -> (MFAPPlantingCycle)type.getValue()).collect(Collectors.toList());
        return typeList;
    }
}

