/*
 * Decompiled with CFR 0.152.
 */
package org.farming.model;

import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.Env;
import org.farming.model.X_FAP_ObservationType;

public class MFAPObservationType
extends X_FAP_ObservationType {
    private static final long serialVersionUID = -5831361443495335312L;
    private static CCache<Integer, MFAPObservationType> observationTypeCacheIds = new CCache("FAP_ObservationType", 30);
    private static CCache<String, MFAPObservationType> observationTypeCacheValues = new CCache("FAP_ObservationType", 30);

    public MFAPObservationType(Properties ctx, int observationTypeId, String trxName) {
        super(ctx, observationTypeId, trxName);
    }

    public MFAPObservationType(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public static MFAPObservationType getById(Properties ctx, int observationTypeId, String trxName) {
        if (observationTypeId <= 0) {
            return null;
        }
        MFAPObservationType observationType = (MFAPObservationType)observationTypeCacheIds.get((Object)observationTypeId);
        if (observationType != null && observationType.get_ID() > 0) {
            return observationType;
        }
        observationType = (MFAPObservationType)new Query(ctx, "FAP_ObservationType", "FAP_ObservationType_ID=?", trxName).setClient_ID().setParameters(new Object[]{observationTypeId}).first();
        if (observationType != null && observationType.get_ID() > 0) {
            int clientId = Env.getAD_Client_ID((Properties)ctx);
            String key = clientId + "#" + observationType.getValue();
            observationTypeCacheValues.put((Object)key, (Object)observationType);
            observationTypeCacheIds.put((Object)observationType.get_ID(), (Object)observationType);
        }
        return observationType;
    }

    public static MFAPObservationType getByValue(Properties ctx, String observationTypeValue, String trxName) {
        int clientId;
        String key;
        MFAPObservationType observationType;
        if (observationTypeValue == null) {
            return null;
        }
        if (observationTypeCacheValues.size() == 0) {
            MFAPObservationType.getAll(ctx, true, trxName);
        }
        if ((observationType = (MFAPObservationType)observationTypeCacheValues.get((Object)(key = (clientId = Env.getAD_Client_ID((Properties)ctx)) + "#" + observationTypeValue))) != null && observationType.get_ID() > 0) {
            return observationType;
        }
        observationType = (MFAPObservationType)new Query(ctx, "FAP_ObservationType", "Value=?", trxName).setClient_ID().setParameters(new Object[]{observationTypeValue}).first();
        if (observationType != null && observationType.get_ID() > 0) {
            observationTypeCacheValues.put((Object)key, (Object)observationType);
            observationTypeCacheIds.put((Object)observationType.get_ID(), (Object)observationType);
        }
        return observationType;
    }

    public static List<MFAPObservationType> getAll(Properties ctx, boolean resetCache, String trxName) {
        if (resetCache || observationTypeCacheIds.size() > 0) {
            List typeList = new Query(Env.getCtx(), "FAP_ObservationType", null, trxName).setClient_ID().setOrderBy("Name").list();
            typeList.stream().forEach(setting -> {
                int clientId = Env.getAD_Client_ID((Properties)ctx);
                String key = clientId + "#" + setting.getValue();
                observationTypeCacheIds.put((Object)setting.getFAP_ObservationType_ID(), setting);
                observationTypeCacheValues.put((Object)key, setting);
            });
            return typeList;
        }
        List<MFAPObservationType> typeList = observationTypeCacheIds.entrySet().stream().map(type -> (MFAPObservationType)type.getValue()).collect(Collectors.toList());
        return typeList;
    }
}

