/*
 * Decompiled with CFR 0.152.
 */
package org.farming.model;

import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.Env;
import org.farming.model.X_FAP_FarmingStage;

public class MFAPFarmingStage
extends X_FAP_FarmingStage {
    private static final long serialVersionUID = -5831361443495335312L;
    private static CCache<Integer, MFAPFarmingStage> farmingStageCacheIds = new CCache("FAP_FarmingStage", 30);
    private static CCache<String, MFAPFarmingStage> farmingStageCacheValues = new CCache("FAP_FarmingStage", 30);

    public MFAPFarmingStage(Properties ctx, int farmingStageId, String trxName) {
        super(ctx, farmingStageId, trxName);
    }

    public MFAPFarmingStage(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public static MFAPFarmingStage getById(Properties ctx, int farmingStageId, String trxName) {
        if (farmingStageId <= 0) {
            return null;
        }
        MFAPFarmingStage farmingStage = (MFAPFarmingStage)farmingStageCacheIds.get((Object)farmingStageId);
        if (farmingStage != null && farmingStage.get_ID() > 0) {
            return farmingStage;
        }
        farmingStage = (MFAPFarmingStage)new Query(ctx, "FAP_FarmingStage", "FAP_FarmingStage_ID=?", trxName).setClient_ID().setParameters(new Object[]{farmingStageId}).first();
        if (farmingStage != null && farmingStage.get_ID() > 0) {
            int clientId = Env.getAD_Client_ID((Properties)ctx);
            String key = clientId + "#" + farmingStage.getValue();
            farmingStageCacheValues.put((Object)key, (Object)farmingStage);
            farmingStageCacheIds.put((Object)farmingStage.get_ID(), (Object)farmingStage);
        }
        return farmingStage;
    }

    public static MFAPFarmingStage getByValue(Properties ctx, String farmingStageValue, String trxName) {
        int clientId;
        String key;
        MFAPFarmingStage farmingStage;
        if (farmingStageValue == null) {
            return null;
        }
        if (farmingStageCacheValues.size() == 0) {
            MFAPFarmingStage.getAll(ctx, true, trxName);
        }
        if ((farmingStage = (MFAPFarmingStage)farmingStageCacheValues.get((Object)(key = (clientId = Env.getAD_Client_ID((Properties)ctx)) + "#" + farmingStageValue))) != null && farmingStage.get_ID() > 0) {
            return farmingStage;
        }
        farmingStage = (MFAPFarmingStage)new Query(ctx, "FAP_FarmingStage", "Value=?", trxName).setClient_ID().setParameters(new Object[]{farmingStageValue}).first();
        if (farmingStage != null && farmingStage.get_ID() > 0) {
            farmingStageCacheValues.put((Object)key, (Object)farmingStage);
            farmingStageCacheIds.put((Object)farmingStage.get_ID(), (Object)farmingStage);
        }
        return farmingStage;
    }

    public static List<MFAPFarmingStage> getAll(Properties ctx, boolean resetCache, String trxName) {
        if (resetCache || farmingStageCacheIds.size() > 0) {
            List typeList = new Query(Env.getCtx(), "FAP_FarmingStage", null, trxName).setClient_ID().setOrderBy("Name").list();
            typeList.stream().forEach(setting -> {
                int clientId = Env.getAD_Client_ID((Properties)ctx);
                String key = clientId + "#" + setting.getValue();
                farmingStageCacheIds.put((Object)setting.getFAP_FarmingStage_ID(), setting);
                farmingStageCacheValues.put((Object)key, setting);
            });
            return typeList;
        }
        List<MFAPFarmingStage> typeList = farmingStageCacheIds.entrySet().stream().map(type -> (MFAPFarmingStage)type.getValue()).collect(Collectors.toList());
        return typeList;
    }
}

