/*
 * Decompiled with CFR 0.152.
 */
package org.farming.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.farming.model.MFAPFarming;
import org.farming.model.X_FAP_FarmingAllocation;
import org.spin.model.MFMAgreement;

public class MFAPFarmingAllocation
extends X_FAP_FarmingAllocation {
    private static final long serialVersionUID = -5831361443495335312L;

    public MFAPFarmingAllocation(Properties ctx, int allocationId, String trxName) {
        super(ctx, allocationId, trxName);
    }

    public MFAPFarmingAllocation(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    protected boolean afterSave(boolean newRecord, boolean success) {
        this.recalculateParent();
        return super.afterSave(newRecord, success);
    }

    protected boolean afterDelete(boolean success) {
        this.recalculateParent();
        return super.afterDelete(success);
    }

    private void recalculateParent() {
        AtomicReference<BigDecimal> farmingArea = new AtomicReference<BigDecimal>(Env.ZERO);
        MFAPFarmingAllocation.getFarmingListOfAgreement(this.getCtx(), this.getFM_Agreement_ID(), this.get_TrxName()).forEach(farming -> farmingArea.updateAndGet(area -> area.add(Optional.ofNullable(farming.getArea()).orElse(Env.ZERO))));
        MFMAgreement agreement = (MFMAgreement)this.getFM_Agreement();
        agreement.set_ValueOfColumn("FarmingArea", (Object)farmingArea.get());
        agreement.saveEx();
    }

    public static List<MFAPFarming> getFarmingListOfAgreement(Properties context, int agreementId, String transactionName) {
        return new Query(context, "FAP_Farming", "EXISTS(SELECT 1 FROM FAP_FarmingAllocation fa WHERE fa.FAP_Farming_ID = FAP_Farming.FAP_Farming_ID AND fa.FM_Agreement_ID = ?)", transactionName).setParameters(new Object[]{agreementId}).list();
    }

    public static List<MFMAgreement> getAgreementListOfFarming(Properties context, int farmingId, String transactionName) {
        return new Query(context, "FM_Agreement", "EXISTS(SELECT 1 FROM FAP_FarmingAllocation fa WHERE fa.FM_Agreement_ID = FM_Agreement.FM_Agreement_ID AND fa.FAP_Farming_ID = ?)", transactionName).setParameters(new Object[]{farmingId}).list();
    }
}

