/*
 * Decompiled with CFR 0.152.
 */
package org.farming.model;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MDocType;
import org.compiere.model.MOrder;
import org.compiere.model.MPeriod;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.process.DocAction;
import org.compiere.process.DocOptions;
import org.compiere.process.DocumentEngine;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.eevolution.model.MDDFreight;
import org.farming.model.MFAPFarmingAllocation;
import org.farming.model.X_FAP_Farming;

public class MFAPFarming
extends X_FAP_Farming
implements DocAction,
DocOptions {
    private static final long serialVersionUID = 20200313L;
    private String m_processMsg = null;
    private boolean m_justPrepared = false;

    public MFAPFarming(Properties ctx, int FAP_Farming_ID, String trxName) {
        super(ctx, FAP_Farming_ID, trxName);
    }

    public MFAPFarming(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public String getDocumentInfo() {
        MDocType dt = MDocType.get((Properties)this.getCtx(), (int)this.getC_DocType_ID());
        return dt.getName() + " " + this.getDocumentNo();
    }

    public File createPDF() {
        try {
            File temp = File.createTempFile(this.get_TableName() + this.get_ID() + "_", ".pdf");
            return this.createPDF(temp);
        }
        catch (Exception e) {
            this.log.severe("Could not create PDF - " + e.getMessage());
            return null;
        }
    }

    public File createPDF(File file) {
        return null;
    }

    public boolean processIt(String processAction) {
        this.m_processMsg = null;
        DocumentEngine engine = new DocumentEngine((DocAction)this, this.getDocStatus());
        return engine.processIt(processAction, this.getDocAction());
    }

    public boolean unlockIt() {
        this.log.info("unlockIt - " + this.toString());
        return true;
    }

    public boolean invalidateIt() {
        this.log.info("invalidateIt - " + this.toString());
        this.setDocAction("PR");
        return true;
    }

    public String prepareIt() {
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        MDocType dt = MDocType.get((Properties)this.getCtx(), (int)this.getC_DocType_ID());
        if (!MPeriod.isOpen((Properties)this.getCtx(), (Timestamp)this.getDateDoc(), (String)dt.getDocBaseType(), (int)this.getAD_Org_ID())) {
            this.m_processMsg = "@PeriodClosed@";
            return "IN";
        }
        this.validateDocument();
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 8);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.m_justPrepared = true;
        if (!"CO".equals(this.getDocAction())) {
            this.setDocAction("CO");
        }
        return "IP";
    }

    private void validateDocument() {
        if (this.getArea() == null || this.getArea().equals(Env.ZERO)) {
            throw new AdempiereException("@Area@ = @0@");
        }
        if (this.getFAP_FarmDivision_ID() > 0) {
            if (this.getArea().compareTo(this.getFAP_FarmDivision().getArea()) > 0) {
                throw new AdempiereException("@Area@ > @Area@ @of@ @FAP_FarmDivision_ID@");
            }
        } else if (this.getArea().compareTo(this.getFAP_Farm().getArea()) > 0) {
            throw new AdempiereException("@Area@ > @Area@ @of@ @FAP_Farm_ID@");
        }
    }

    public boolean approveIt() {
        this.log.info("approveIt - " + this.toString());
        this.setIsApproved(true);
        return true;
    }

    public boolean rejectIt() {
        this.log.info("rejectIt - " + this.toString());
        this.setIsApproved(false);
        return true;
    }

    public String completeIt() {
        String status;
        if (!this.m_justPrepared && !"IP".equals(status = this.prepareIt())) {
            return status;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 7);
        if (this.m_processMsg != null) {
            return "IN";
        }
        if (!this.isApproved()) {
            this.approveIt();
        }
        this.log.info(this.toString());
        String valid = ModelValidationEngine.get().fireDocValidate((PO)this, 9);
        if (valid != null) {
            this.m_processMsg = valid;
            return "IN";
        }
        this.setDefiniteDocumentNo();
        this.setProcessed(true);
        this.setDocAction("CL");
        return "CO";
    }

    private void setDefiniteDocumentNo() {
        MDocType dt = MDocType.get((Properties)this.getCtx(), (int)this.getC_DocType_ID());
        if (dt.isOverwriteDateOnComplete()) {
            this.setDateDoc(new Timestamp(System.currentTimeMillis()));
        }
        if (dt.isOverwriteSeqOnComplete()) {
            String value = null;
            int index = this.p_info.getColumnIndex("C_DocType_ID");
            if (index == -1) {
                index = this.p_info.getColumnIndex("C_DocTypeTarget_ID");
            }
            if (index != -1) {
                value = DB.getDocumentNo((int)this.get_ValueAsInt(index), (String)this.get_TrxName(), (boolean)true);
            }
            if (value != null) {
                this.setDocumentNo(value);
            }
        }
    }

    protected boolean beforeSave(boolean newRecord) {
        super.beforeSave(newRecord);
        if (newRecord || this.is_ValueChanged("Area")) {
            this.setFM_Account_ID(0);
            this.setFM_Agreement_ID(0);
        }
        return true;
    }

    public int customizeValidActions(String docStatus, Object processing, String orderType, String isSOTrx, int AD_Table_ID, String[] docAction, String[] options, int index) {
        if (AD_Table_ID == Table_ID) {
            if (docStatus.equals("DR") || docStatus.equals("IP") || docStatus.equals("IN")) {
                options[index++] = "PR";
            } else if (docStatus.equals("CO")) {
                options[index++] = "VO";
                options[index++] = "RE";
                options[index++] = "CL";
            } else if (docStatus.equals("CL")) {
                options[index++] = "--";
            }
        }
        return index;
    }

    public boolean voidIt() {
        this.log.info("voidIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 2);
        if (this.m_processMsg != null) {
            return false;
        }
        this.validateFarmerCreditReference();
        this.addDescription(Msg.getMsg((Properties)this.getCtx(), (String)"Voided"));
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 10);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        return true;
    }

    public void addDescription(String description) {
        String desc = this.getDescription();
        if (desc == null) {
            this.setDescription(description);
        } else {
            this.setDescription(desc + " | " + description);
        }
    }

    public boolean closeIt() {
        this.log.info("closeIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 3);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 11);
        return this.m_processMsg == null;
    }

    public boolean reverseCorrectIt() {
        this.log.info("reverseCorrectIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 5);
        if (this.m_processMsg != null) {
            return false;
        }
        this.voidIt();
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 13);
        if (this.m_processMsg != null) {
            return false;
        }
        return false;
    }

    public boolean reverseAccrualIt() {
        this.log.info("reverseAccrualIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 6);
        if (this.m_processMsg != null) {
            return false;
        }
        this.voidIt();
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 14);
        if (this.m_processMsg != null) {
            return false;
        }
        return false;
    }

    public boolean reActivateIt() {
        this.log.info("reActivateIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 4);
        if (this.m_processMsg != null) {
            return false;
        }
        this.validateFarmerCreditReference();
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 12);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setDocAction("CO");
        this.setProcessed(false);
        return true;
    }

    private void validateFarmerCreditReference() {
        StringBuffer errorMessage = new StringBuffer();
        MFAPFarmingAllocation.getAgreementListOfFarming(this.getCtx(), this.getFAP_Farming_ID(), this.get_TrxName()).stream().filter(farmerCredit -> !farmerCredit.getDocStatus().equals("VO") && !farmerCredit.getDocStatus().equals("RE")).forEach(farmerCredit -> {
            if (errorMessage.length() > 0) {
                errorMessage.append(", ");
            }
            errorMessage.append(farmerCredit.getDocumentNo());
        });
        if (errorMessage.length() > 0) {
            throw new AdempiereException("@SQLErrorReferenced@ @FM_Agreement_ID@ " + errorMessage);
        }
    }

    public String getSummary() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getDocumentNo());
        if (this.getDescription() != null && this.getDescription().length() > 0) {
            sb.append(" - ").append(this.getDescription());
        }
        return sb.toString();
    }

    public String getProcessMsg() {
        return this.m_processMsg;
    }

    public int getDoc_User_ID() {
        return 0;
    }

    public BigDecimal getApprovalAmt() {
        return null;
    }

    public int getC_Currency_ID() {
        return 0;
    }

    public static MFAPFarming getById(Properties context, int farmingId, String transactionName) {
        return (MFAPFarming)new Query(context, "FAP_Farming", "FAP_Farming_ID = ?", transactionName).setParameters(new Object[]{farmingId}).first();
    }

    public void updateFreightQuantity() {
        AtomicReference<BigDecimal> transportedQuantity = new AtomicReference<BigDecimal>(Env.ZERO);
        MFAPFarming.getFreightListOfFarming(this.getCtx(), this.getFAP_Farming_ID(), this.get_TrxName()).stream().filter(freightOrder -> freightOrder.getDocStatus().equals("CO") || freightOrder.getDocStatus().equals("CL")).forEach(freightOrder -> freightOrder.getLines().forEach(freightLine -> transportedQuantity.updateAndGet(freightWeight -> freightWeight.add(Optional.ofNullable(freightLine.getWeight()).orElse(Env.ZERO)))));
        this.setFarmingTransportedQuantity(transportedQuantity.get());
        this.saveEx();
    }

    public void updateQuantityOrdered() {
        AtomicReference<BigDecimal> quantityOrdered = new AtomicReference<BigDecimal>(Env.ZERO);
        MFAPFarming.getOrdersListOfFarming(this.getCtx(), this.getFAP_Farming_ID(), false, this.get_TrxName()).stream().filter(order -> order.getDocStatus().equals("CO") || order.getDocStatus().equals("CL")).forEach(order -> Arrays.asList(order.getLines()).stream().filter(orderLine -> orderLine.get_ValueAsInt("FAP_Farming_ID") == this.getFAP_Farming_ID()).filter(orderLine -> orderLine.getM_Product_ID() == this.getCategory_ID()).forEach(orderLine -> quantityOrdered.updateAndGet(quantity -> quantity.add(Optional.ofNullable(orderLine.getQtyOrdered()).orElse(Env.ZERO)))));
        this.setFarmingTransportedQuantity(quantityOrdered.get());
        this.saveEx();
    }

    public static List<MDDFreight> getFreightListOfFarming(Properties context, int farmingId, String transactionName) {
        return new Query(context, "DD_Freight", "(FAP_Farming_ID = ? OR EXISTS(SELECT 1 FROM DD_FreightLine fl WHERE fl.DD_Freight_ID = DD_Freight.DD_Freight_ID AND fl.FAP_Farming_ID = ?))", transactionName).setParameters(new Object[]{farmingId, farmingId}).list();
    }

    public static List<MOrder> getOrdersListOfFarming(Properties context, int farmingId, boolean isSalesTransaction, String transactionName) {
        return new Query(context, "C_Order", "IsSOTrx = ? AND EXISTS(SELECT 1 FROM C_OrderLine ol WHERE ol.C_Order_ID = C_Order.C_Order_ID AND ol.FAP_Farming_ID = ?)", transactionName).setParameters(new Object[]{isSalesTransaction, farmingId}).list();
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MFAPFarming[").append(this.getSummary()).append("]");
        return sb.toString();
    }
}

