/*
 * Decompiled with CFR 0.152.
 */
package org.farming.model;

import java.sql.ResultSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MAttribute;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.Env;
import org.farming.model.X_FAP_FarmerAttributes;

public class MFAPFarmerAttributes
extends X_FAP_FarmerAttributes {
    private static CCache<String, Map<String, Object>> s_cache = new CCache("FAP_FarmerAttributes", 40, 0);
    private static final long serialVersionUID = 1L;

    public MFAPFarmerAttributes(Properties ctx, int FAP_FarmerAttributes_ID, String trxName) {
        super(ctx, FAP_FarmerAttributes_ID, trxName);
    }

    public MFAPFarmerAttributes(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public Object getValue() {
        return Optional.ofNullable(this.getValueString()).orElse((String)((Object)this.getValueNumber()));
    }

    protected boolean beforeSave(boolean newRecord) {
        if (this.getM_Attribute_ID() > 0) {
            MAttribute attribute = new MAttribute(this.getCtx(), this.getM_Attribute_ID(), this.get_TrxName());
            String attributeValue = !attribute.get_ValueAsString("Value").isEmpty() ? attribute.get_ValueAsString("Value") : attribute.getName();
            this.setAttributeValue(attributeValue);
        }
        if (this.getAttributeValue() == null) {
            throw new AdempiereException("@IsMandatory@ : @AttributeValue@");
        }
        return true;
    }

    public static Map<String, Object> getAttributesforBussinessPartnerAndProduct(int bPartnerId, int productId) {
        String key = Integer.toString(bPartnerId).concat("_").concat(Integer.toString(productId));
        Map result = Optional.ofNullable((Map)s_cache.get((Object)key)).orElseGet(() -> {
            String whereClause = "C_BPartner_ID".concat("=? AND ").concat("M_Product_ID").concat("=? ");
            List farmerAttributes = new Query(Env.getCtx(), "FAP_FarmerAttributes", whereClause, null).setParameters(new Object[]{bPartnerId, productId}).setOnlyActiveRecords(true).list();
            return farmerAttributes.stream().collect(Collectors.toMap(X_FAP_FarmerAttributes::getAttributeValue, MFAPFarmerAttributes::getValue));
        });
        s_cache.put((Object)key, (Object)result);
        return result;
    }
}

