/*
 * Decompiled with CFR 0.152.
 */
package org.farming.model;

import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.Env;
import org.farming.model.MFAPFarm;
import org.farming.model.X_FAP_FarmDivision;

public class MFAPFarmDivision
extends X_FAP_FarmDivision {
    private static final long serialVersionUID = -5831361443495335312L;
    private static CCache<Integer, MFAPFarmDivision> farmDivisionCacheIds = new CCache("FAP_FarmDivision", 30);

    public MFAPFarmDivision(Properties ctx, int farmDivisionId, String trxName) {
        super(ctx, farmDivisionId, trxName);
    }

    public MFAPFarmDivision(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public static MFAPFarmDivision getById(Properties ctx, int farmDivisionId, String trxName) {
        if (farmDivisionId <= 0) {
            return null;
        }
        MFAPFarmDivision farmDivision = (MFAPFarmDivision)farmDivisionCacheIds.get((Object)farmDivisionId);
        if (farmDivision != null && farmDivision.get_ID() > 0) {
            return farmDivision;
        }
        farmDivision = (MFAPFarmDivision)new Query(ctx, "FAP_FarmDivision", "FAP_FarmDivision_ID=?", trxName).setClient_ID().setParameters(new Object[]{farmDivisionId}).first();
        if (farmDivision != null && farmDivision.get_ID() > 0) {
            farmDivisionCacheIds.put((Object)farmDivision.get_ID(), (Object)farmDivision);
        }
        return farmDivision;
    }

    public static List<MFAPFarmDivision> getAll(Properties ctx, boolean resetCache, String trxName) {
        if (resetCache || farmDivisionCacheIds.size() > 0) {
            List farmDivisionList = new Query(Env.getCtx(), "FAP_FarmDivision", null, trxName).setClient_ID().setOrderBy("Name").list();
            farmDivisionList.stream().forEach(setting -> farmDivisionCacheIds.put((Object)setting.getFAP_FarmDivision_ID(), setting));
            return farmDivisionList;
        }
        List<MFAPFarmDivision> farmDivisionList = farmDivisionCacheIds.entrySet().stream().map(type -> (MFAPFarmDivision)type.getValue()).collect(Collectors.toList());
        return farmDivisionList;
    }

    protected boolean beforeSave(boolean newRecord) {
        super.beforeSave(newRecord);
        if (this.getArea() == null || this.getArea().equals(Env.ZERO)) {
            throw new AdempiereException("@Area@ = @0@");
        }
        return true;
    }

    protected boolean afterSave(boolean newRecord, boolean success) {
        super.afterSave(newRecord, success);
        MFAPFarm farm = new MFAPFarm(this.getCtx(), this.getFAP_Farm_ID(), this.get_TrxName());
        farm.validate();
        farm.saveEx();
        return true;
    }

    public List<MFAPFarmDivision> getFromFarmer(Properties ctx, int farmId, String trxName) {
        return new Query(ctx, "FAP_FarmDivision", "FAP_Farm_ID = ?", trxName).setParameters(new Object[]{farmId}).setOnlyActiveRecords(true).list();
    }
}

