/*
 * Decompiled with CFR 0.152.
 */
package org.farming.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.Env;
import org.farming.model.MFAPFarmDivision;
import org.farming.model.X_FAP_Farm;

public class MFAPFarm
extends X_FAP_Farm {
    private static final long serialVersionUID = -5831361443495335312L;
    private static CCache<Integer, MFAPFarm> farmCacheIds = new CCache("FAP_Farm", 30);
    private List<MFAPFarmDivision> farmDivisionList = null;

    public MFAPFarm(Properties ctx, int farmId, String trxName) {
        super(ctx, farmId, trxName);
    }

    public MFAPFarm(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public static MFAPFarm getById(Properties ctx, int farmId, String trxName) {
        if (farmId <= 0) {
            return null;
        }
        MFAPFarm farm = (MFAPFarm)farmCacheIds.get((Object)farmId);
        if (farm != null && farm.get_ID() > 0) {
            return farm;
        }
        farm = (MFAPFarm)new Query(ctx, "FAP_Farm", "FAP_Farm_ID=?", trxName).setClient_ID().setParameters(new Object[]{farmId}).first();
        if (farm != null && farm.get_ID() > 0) {
            farmCacheIds.put((Object)farm.get_ID(), (Object)farm);
        }
        return farm;
    }

    public static List<MFAPFarm> getAll(Properties ctx, boolean resetCache, String trxName) {
        if (resetCache || farmCacheIds.size() > 0) {
            List farmList = new Query(Env.getCtx(), "FAP_Farm", null, trxName).setClient_ID().setOrderBy("Name").list();
            farmList.stream().forEach(setting -> farmCacheIds.put((Object)setting.getFAP_Farm_ID(), setting));
            return farmList;
        }
        List<MFAPFarm> farmList = farmCacheIds.entrySet().stream().map(type -> (MFAPFarm)type.getValue()).collect(Collectors.toList());
        return farmList;
    }

    protected boolean beforeSave(boolean newRecord) {
        super.beforeSave(newRecord);
        this.validate();
        return true;
    }

    public void validate() {
        AtomicReference<BigDecimal> totalArea = new AtomicReference<BigDecimal>(Env.ZERO);
        if (this.isFarmDivisionControl()) {
            this.getFarmDivisions(true).forEach(farmDivision -> totalArea.updateAndGet(area -> area.add(Optional.ofNullable(farmDivision.getArea()).orElse(Env.ZERO))));
        } else {
            totalArea.set(Optional.ofNullable(this.getArea()).orElse(Env.ZERO));
        }
        this.setIsValid(totalArea.get().signum() > 0 && totalArea.get().compareTo(Optional.ofNullable(this.getArea()).orElse(Env.ZERO)) <= 0);
    }

    public List<MFAPFarmDivision> getFarmDivisions(boolean requery) {
        if (this.farmDivisionList == null || this.farmDivisionList.size() <= 0 || requery) {
            this.farmDivisionList = new Query(this.getCtx(), "FAP_FarmDivision", "FAP_Farm_ID = ?", this.get_TrxName()).setParameters(new Object[]{this.getFAP_Farm_ID()}).setOnlyActiveRecords(true).list();
        }
        return this.farmDivisionList;
    }

    public List<MFAPFarm> getFromFarmer(Properties ctx, int farmerId, String trxName) {
        return new Query(ctx, "FAP_Farm", "C_BPartner_ID = ?", trxName).setParameters(new Object[]{farmerId}).setOnlyActiveRecords(true).list();
    }
}

