/*
 * Decompiled with CFR 0.152.
 */
package org.farming.engine.financing;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.MRefList;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.farming.model.MFAPRawMaterialConditioning;
import org.farming.util.FarmingTechnicalAssistanceUtil;
import org.spin.model.MFMAccount;
import org.spin.model.MFMBatch;
import org.spin.model.MFMFunctionalApplicability;
import org.spin.model.MFMFunctionalSetting;
import org.spin.model.MFMTransaction;
import org.spin.model.MFMTransactionType;
import org.spin.util.AbstractFunctionalSetting;

public class RawMaterialConditioning
extends AbstractFunctionalSetting {
    private static final String FARMING_FINANCING_RECORD_WEIGHT = "FFR";

    public RawMaterialConditioning(MFMFunctionalSetting setting) {
        super(setting);
    }

    public String run() {
        MFAPRawMaterialConditioning rawMaterialConditioning = (MFAPRawMaterialConditioning)this.getParameter("PO");
        if (rawMaterialConditioning == null) {
            return null;
        }
        if (rawMaterialConditioning.get_ValueAsInt("FM_Account_ID") <= 0) {
            return null;
        }
        if (rawMaterialConditioning.get_Value("ConditionedWeight") == null) {
            return null;
        }
        return this.generateBatch(rawMaterialConditioning);
    }

    private boolean reversePreviousBatch(MFAPRawMaterialConditioning rawMaterialConditioning, PO recordWeight, int financialAccountId, String transactionName) {
        ArrayList<Object> parameters = new ArrayList<Object>();
        parameters.add(financialAccountId);
        parameters.add("CO");
        parameters.add(rawMaterialConditioning.getFAP_RawMaterialConditioning_ID());
        MFMBatch previousBatch = (MFMBatch)new Query(rawMaterialConditioning.getCtx(), "FM_Batch", "FM_Account_ID=? AND DocStatus=? AND EXISTS(SELECT 1 \t\t\t\t\tFROM FM_Transaction t \t\t\t\t\tWHERE t.FM_Batch_ID = FM_Batch.FM_Batch_ID \t\t\t\t\tAND t.FAP_RawMaterialConditioning_ID = ?)", transactionName).setParameters(parameters).setOrderBy("DateDoc DESC").first();
        if (previousBatch != null) {
            previousBatch.set_ValueOfColumn("IsFarmerOverdraftCreditLimit", (Object)recordWeight.get_ValueAsBoolean("IsFarmerOverdraftCreditLimit"));
            previousBatch.saveEx();
            previousBatch.processIt("RA");
            previousBatch.saveEx();
            return true;
        }
        return false;
    }

    private String generateBatch(MFAPRawMaterialConditioning rawMaterialConditioning) {
        String transactionName = (String)this.getParameter("TRX_NAME");
        int financialAccountId = rawMaterialConditioning.getFM_Account_ID();
        int agreementId = rawMaterialConditioning.getFM_Agreement_ID();
        PO recordWeight = MTable.get((Properties)this.getCtx(), (String)"DD_RecordWeight").getPO(rawMaterialConditioning.getDD_RecordWeight_ID(), transactionName);
        MFMFunctionalApplicability applicability = this.getFunctionalApplicability();
        if (!Util.isEmpty((String)applicability.getEventModelValidator()) && (applicability.getEventModelValidator().equals("DAAC") || applicability.getEventModelValidator().equals("DAVO") || applicability.getEventModelValidator().equals("DARC") || applicability.getEventModelValidator().equals("DARA"))) {
            this.reversePreviousBatch(rawMaterialConditioning, recordWeight, financialAccountId, transactionName);
            return null;
        }
        this.reversePreviousBatch(rawMaterialConditioning, recordWeight, financialAccountId, transactionName);
        MOrder purchaseOrder = null;
        purchaseOrder = recordWeight.get_ValueAsInt("C_Order_ID") > 0 ? new MOrder(this.getCtx(), recordWeight.get_ValueAsInt("C_Order_ID"), transactionName) : FarmingTechnicalAssistanceUtil.getPurchaseOrderFromAgreement(this.getCtx(), agreementId, financialAccountId, transactionName);
        if (purchaseOrder == null || purchaseOrder.getC_Order_ID() <= 0) {
            return null;
        }
        if (!purchaseOrder.getDocStatus().equals("CO")) {
            throw new AdempiereException("@C_Order_ID@ @NoCompleted@");
        }
        AtomicReference<MOrderLine> orderLine = new AtomicReference<MOrderLine>();
        if (recordWeight.get_ValueAsInt("C_OrderLine_ID") > 0) {
            orderLine.set(new MOrderLine(this.getCtx(), recordWeight.get_ValueAsInt("C_OrderLine_ID"), transactionName));
        } else {
            Optional<MOrderLine> maybeOrderLine = Arrays.asList(purchaseOrder.getLines()).stream().filter(orderLineToFind -> {
                if (orderLineToFind.getM_Product_ID() <= 0) {
                    return false;
                }
                MProduct product = MProduct.get((Properties)this.getCtx(), (int)orderLineToFind.getM_Product_ID());
                return product.get_ValueAsBoolean("IsCategory");
            }).findFirst();
            if (maybeOrderLine.isPresent()) {
                orderLine.set(maybeOrderLine.get());
            } else {
                throw new AdempiereException("@C_OrderLine_ID@ @IsCategory@ @NotFound@");
            }
        }
        BigDecimal conditionedWeight = Optional.ofNullable(rawMaterialConditioning.getConditionedWeight()).orElse(Env.ZERO);
        BigDecimal businessPrice = Optional.ofNullable(((MOrderLine)orderLine.get()).getPriceActual()).orElse(Env.ZERO);
        if (conditionedWeight.signum() == 0 || businessPrice.signum() == 0) {
            return null;
        }
        MFMAccount account = new MFMAccount(this.getCtx(), financialAccountId, transactionName);
        this.setParameter("MFMAccount", account);
        MFMBatch batch = this.createBatch((Timestamp)recordWeight.get_Value("DateDoc"));
        if (batch != null) {
            MFMTransactionType transactionTypeForPayment = MFMTransactionType.getTransactionTypeFromType((Properties)this.getCtx(), (String)FARMING_FINANCING_RECORD_WEIGHT);
            if (transactionTypeForPayment == null) {
                throw new AdempiereException("@FM_TransactionType_ID@ @NotFound@ " + MRefList.getListName((Properties)this.getCtx(), (int)54020, (String)FARMING_FINANCING_RECORD_WEIGHT));
            }
            MFMTransaction transaction = batch.addTransaction(transactionTypeForPayment.getFM_TransactionType_ID(), purchaseOrder.getC_Currency_ID(), purchaseOrder.getC_ConversionType_ID(), conditionedWeight.multiply(businessPrice).negate());
            if (transaction != null) {
                transaction.set_ValueOfColumn("DD_RecordWeight_ID", (Object)rawMaterialConditioning.getDD_RecordWeight_ID());
                transaction.set_ValueOfColumn("FAP_RawMaterialConditioning_ID", (Object)rawMaterialConditioning.getFAP_RawMaterialConditioning_ID());
                if (!Util.isEmpty((String)recordWeight.get_ValueAsString("Description"))) {
                    transaction.set_ValueOfColumn("Description", (Object)rawMaterialConditioning.getDescription());
                    transaction.saveEx();
                }
                transaction.saveEx(transactionName);
            }
            batch.set_ValueOfColumn("IsFarmerOverdraftCreditLimit", (Object)recordWeight.get_ValueAsBoolean("IsFarmerOverdraftCreditLimit"));
            batch.set_TrxName(transactionName);
            batch.processIt("CO");
            batch.saveEx(transactionName);
        }
        return null;
    }
}

