/*
 * Decompiled with CFR 0.152.
 */
package org.farming.engine.financing;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MPayment;
import org.compiere.model.MRefList;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.spin.model.MFMAccount;
import org.spin.model.MFMBatch;
import org.spin.model.MFMFunctionalSetting;
import org.spin.model.MFMTransaction;
import org.spin.model.MFMTransactionType;
import org.spin.util.AbstractFunctionalSetting;

public class Payment
extends AbstractFunctionalSetting {
    private static final String FARMING_FINANCING_PAYMENT = "FFP";

    public Payment(MFMFunctionalSetting setting) {
        super(setting);
    }

    public String run() {
        MPayment payment = (MPayment)this.getParameter("PO");
        if (payment == null) {
            return null;
        }
        if (payment.get_ValueAsInt("FM_Account_ID") <= 0) {
            return null;
        }
        return this.generateBatch(payment);
    }

    private boolean reversePreviousBatch(MPayment payment, int financialAccountId, String transactionName) {
        ArrayList<Object> parameters = new ArrayList<Object>();
        parameters.add(financialAccountId);
        parameters.add("CO");
        parameters.add(payment.getReversal_ID());
        MFMBatch previousBatch = (MFMBatch)new Query(payment.getCtx(), "FM_Batch", "FM_Account_ID=? AND DocStatus=? AND EXISTS(SELECT 1 \t\t\t\t\tFROM FM_Transaction t \t\t\t\t\tWHERE t.FM_Batch_ID = FM_Batch.FM_Batch_ID \t\t\t\t\tAND t.C_Payment_ID = ?)", transactionName).setParameters(parameters).setOrderBy("DateDoc DESC").first();
        if (previousBatch != null) {
            previousBatch.set_ValueOfColumn("IsFarmerOverdraftCreditLimit", (Object)payment.get_ValueAsBoolean("IsFarmerOverdraftCreditLimit"));
            previousBatch.saveEx();
            previousBatch.processIt("RA");
            previousBatch.saveEx();
            return true;
        }
        return false;
    }

    private String generateBatch(MPayment payment) {
        String transactionName = (String)this.getParameter("TRX_NAME");
        int financialAccountId = payment.get_ValueAsInt("FM_Account_ID");
        if (payment.getReversal_ID() != 0) {
            this.reversePreviousBatch(payment, financialAccountId, transactionName);
            return null;
        }
        MFMAccount account = new MFMAccount(payment.getCtx(), financialAccountId, transactionName);
        this.setParameter("MFMAccount", account);
        MFMBatch batch = this.createBatch(payment.getDateTrx());
        if (batch != null) {
            MFMTransactionType transactionTypeForPayment;
            BigDecimal multiplier = Env.ONE;
            if (payment.isReceipt()) {
                multiplier = multiplier.negate();
            }
            if ((transactionTypeForPayment = MFMTransactionType.getTransactionTypeFromType((Properties)this.getCtx(), (String)FARMING_FINANCING_PAYMENT)) == null) {
                throw new AdempiereException("@FM_TransactionType_ID@ @NotFound@ " + MRefList.getListName((Properties)this.getCtx(), (int)54020, (String)FARMING_FINANCING_PAYMENT));
            }
            MFMTransaction transaction = batch.addTransaction(transactionTypeForPayment.getFM_TransactionType_ID(), payment.getC_Currency_ID(), payment.getC_ConversionType_ID(), payment.getPayAmt().multiply(multiplier));
            if (transaction != null) {
                transaction.set_ValueOfColumn("C_Payment_ID", (Object)payment.getC_Payment_ID());
                if (!Util.isEmpty((String)payment.getDescription())) {
                    transaction.set_ValueOfColumn("Description", (Object)payment.getDescription());
                    transaction.saveEx();
                }
                transaction.saveEx();
            }
            batch.set_ValueOfColumn("IsFarmerOverdraftCreditLimit", (Object)payment.get_ValueAsBoolean("IsFarmerOverdraftCreditLimit"));
            batch.set_ValueOfColumn("IsFarmerAssistanceProgram", (Object)true);
            batch.processIt("CO");
            batch.saveEx();
        }
        return null;
    }
}

