/*
 * Decompiled with CFR 0.152.
 */
package org.farming.engine.financing;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MRefList;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.spin.model.MFMAccount;
import org.spin.model.MFMBatch;
import org.spin.model.MFMFunctionalApplicability;
import org.spin.model.MFMFunctionalSetting;
import org.spin.model.MFMTransaction;
import org.spin.model.MFMTransactionType;
import org.spin.util.AbstractFunctionalSetting;

public class Order
extends AbstractFunctionalSetting {
    public static final String FARMING_FINANCING_ORDER = "FFO";
    public static final String FARMING_FINANCING_TAX = "FFT";

    public Order(MFMFunctionalSetting setting) {
        super(setting);
    }

    public String run() {
        MOrder order = (MOrder)this.getParameter("PO");
        if (order == null) {
            return null;
        }
        if (order.get_ValueAsInt("FM_Account_ID") <= 0 || !order.isSOTrx()) {
            return null;
        }
        return this.generateBatch(order);
    }

    private boolean reversePreviousBatch(MOrder order, int financialAccountId, String transactionName) {
        ArrayList<Object> parameters = new ArrayList<Object>();
        parameters.add(financialAccountId);
        parameters.add("CO");
        parameters.add(order.getC_Order_ID());
        MFMBatch previousBatch = (MFMBatch)new Query(order.getCtx(), "FM_Batch", "FM_Account_ID=? AND DocStatus=? AND EXISTS(SELECT 1 \t\t\t\t\tFROM FM_Transaction t \t\t\t\t\tWHERE t.FM_Batch_ID = FM_Batch.FM_Batch_ID \t\t\t\t\tAND t.C_Order_ID = ?)", transactionName).setParameters(parameters).setOrderBy("DateDoc DESC").first();
        if (previousBatch != null) {
            previousBatch.set_ValueOfColumn("IsFarmerOverdraftCreditLimit", (Object)order.get_ValueAsBoolean("IsFarmerOverdraftCreditLimit"));
            previousBatch.saveEx();
            previousBatch.processIt("RA");
            previousBatch.saveEx();
            return true;
        }
        return false;
    }

    private String generateBatch(MOrder order) {
        String transactionName = (String)this.getParameter("TRX_NAME");
        int financialAccountId = order.get_ValueAsInt("FM_Account_ID");
        MFMFunctionalApplicability applicability = this.getFunctionalApplicability();
        if (!Util.isEmpty((String)applicability.getEventModelValidator()) && (applicability.getEventModelValidator().equals("DAAC") || applicability.getEventModelValidator().equals("DAVO") || applicability.getEventModelValidator().equals("DARC") || applicability.getEventModelValidator().equals("DARA"))) {
            this.reversePreviousBatch(order, financialAccountId, transactionName);
            return null;
        }
        MFMAccount account = new MFMAccount(order.getCtx(), financialAccountId, transactionName);
        this.setParameter("MFMAccount", account);
        MFMBatch batch = this.createBatch(order.getDateOrdered());
        if (batch != null) {
            MFMTransaction transaction;
            BigDecimal multiplier = Env.ONE;
            if (!order.isSOTrx()) {
                multiplier = multiplier.negate();
            }
            if (order.isReturnOrder()) {
                multiplier = multiplier.negate();
            }
            MFMTransactionType transactionTypeForOrder = MFMTransactionType.getTransactionTypeFromType((Properties)this.getCtx(), (String)FARMING_FINANCING_ORDER);
            MFMTransactionType transactionTypeForTax = MFMTransactionType.getTransactionTypeFromType((Properties)this.getCtx(), (String)FARMING_FINANCING_TAX);
            if (transactionTypeForOrder == null) {
                throw new AdempiereException("@FM_TransactionType_ID@ @NotFound@ " + MRefList.getListName((Properties)this.getCtx(), (int)54020, (String)FARMING_FINANCING_ORDER));
            }
            if (transactionTypeForTax == null) {
                throw new AdempiereException("@FM_TransactionType_ID@ @NotFound@ " + MRefList.getListName((Properties)this.getCtx(), (int)54020, (String)FARMING_FINANCING_TAX));
            }
            for (MOrderLine mOrderLine : order.getLines()) {
                if (Optional.ofNullable(mOrderLine.getLineNetAmt()).orElse(Env.ZERO).compareTo(Env.ZERO) == 0 || (transaction = batch.addTransaction(transactionTypeForOrder.getFM_TransactionType_ID(), order.getC_Currency_ID(), order.getC_ConversionType_ID(), mOrderLine.getLineNetAmt().multiply(multiplier))) == null) continue;
                transaction.set_ValueOfColumn("C_Order_ID", (Object)mOrderLine.getC_Order_ID());
                transaction.set_ValueOfColumn("C_OrderLine_ID", (Object)mOrderLine.getC_OrderLine_ID());
                if (!Util.isEmpty((String)mOrderLine.getDescription())) {
                    transaction.set_ValueOfColumn("Description", (Object)mOrderLine.getDescription());
                    transaction.saveEx();
                }
                transaction.saveEx();
            }
            for (MOrderLine mOrderLine : order.getTaxes(true)) {
                if (Optional.ofNullable(mOrderLine.getTaxAmt()).orElse(Env.ZERO).signum() == 0 || (transaction = batch.addTransaction(transactionTypeForTax.getFM_TransactionType_ID(), order.getC_Currency_ID(), order.getC_ConversionType_ID(), mOrderLine.getTaxAmt().multiply(multiplier))) == null) continue;
                transaction.set_ValueOfColumn("C_Order_ID", (Object)mOrderLine.getC_Order_ID());
                transaction.saveEx();
            }
            if (!Util.isEmpty((String)order.getDescription())) {
                batch.setDescription(order.getDescription());
                batch.saveEx();
            }
            batch.set_ValueOfColumn("IsFarmerOverdraftCreditLimit", (Object)order.get_ValueAsBoolean("IsFarmerOverdraftCreditLimit"));
            batch.set_ValueOfColumn("IsFarmerAssistanceProgram", (Object)true);
            batch.processIt("CO");
            batch.saveEx();
        }
        return null;
    }
}

