/*
 * Decompiled with CFR 0.152.
 */
package org.farming.engine.financing;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MCharge;
import org.compiere.model.MDocType;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.MRefList;
import org.compiere.model.MTax;
import org.compiere.model.MTaxCategory;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.spin.model.MFMAccount;
import org.spin.model.MFMAgreement;
import org.spin.model.MFMBatch;
import org.spin.model.MFMFunctionalSetting;
import org.spin.model.MFMProduct;
import org.spin.model.MFMRate;
import org.spin.model.MFMTransaction;
import org.spin.model.MFMTransactionType;
import org.spin.util.AbstractFunctionalSetting;

public class Invoice
extends AbstractFunctionalSetting {
    private static final String FARMING_FINANCING_INVOICING = "FFI";
    private static final String FARMING_FINANCING_TAX = "FFT";
    private static final String FARMING_FINANCING_INTEREST = "FFN";
    private static final String FARMING_FINANCING_INTEREST_TAX = "FFX";

    public Invoice(MFMFunctionalSetting setting) {
        super(setting);
    }

    public String run() {
        MInvoice invoice = (MInvoice)this.getParameter("PO");
        if (invoice == null) {
            return null;
        }
        if (invoice.getFM_Account_ID() <= 0) {
            return null;
        }
        return this.generateBatch(invoice);
    }

    private boolean reversePreviousBatch(MInvoice invoice, int financialAccountId, String transactionName) {
        ArrayList<Object> parameters = new ArrayList<Object>();
        parameters.add(financialAccountId);
        parameters.add("CO");
        parameters.add(invoice.getReversal_ID());
        MFMBatch previousBatch = (MFMBatch)new Query(invoice.getCtx(), "FM_Batch", "FM_Account_ID=? AND DocStatus=? AND EXISTS(SELECT 1 \t\t\t\t\tFROM FM_Transaction t \t\t\t\t\tWHERE t.FM_Batch_ID = FM_Batch.FM_Batch_ID \t\t\t\t\tAND t.C_Invoice_ID = ?)", transactionName).setParameters(parameters).setOrderBy("DateDoc DESC").first();
        if (previousBatch != null) {
            previousBatch.set_ValueOfColumn("IsFarmerOverdraftCreditLimit", (Object)invoice.get_ValueAsBoolean("IsFarmerOverdraftCreditLimit"));
            previousBatch.saveEx();
            previousBatch.processIt("RA");
            previousBatch.saveEx();
            return true;
        }
        return false;
    }

    private String generateBatch(MInvoice invoice) {
        String transactionName = (String)this.getParameter("TRX_NAME");
        int financialAccountId = invoice.getFM_Account_ID();
        int agreementId = invoice.get_ValueAsInt("FM_Agreement_ID");
        if (invoice.getReversal_ID() != 0) {
            this.reversePreviousBatch(invoice, financialAccountId, transactionName);
            return null;
        }
        MFMAccount account = new MFMAccount(invoice.getCtx(), financialAccountId, transactionName);
        MFMAgreement agreement = MFMAgreement.getById((Properties)this.getCtx(), (int)agreementId, (String)transactionName);
        this.setParameter("MFMAccount", account);
        MFMBatch batch = this.createBatch(invoice.getDateInvoiced());
        if (batch != null) {
            MDocType documentType = MDocType.get((Properties)this.getCtx(), (int)invoice.getC_DocType_ID());
            BigDecimal multiplier = Env.ONE;
            if (!invoice.isSOTrx()) {
                multiplier = multiplier.negate();
            }
            if (documentType.getDocBaseType().endsWith("C")) {
                multiplier = multiplier.negate();
            }
            MFMTransactionType transactionTypeForOrder = MFMTransactionType.getTransactionTypeFromType((Properties)this.getCtx(), (String)"FFO");
            MFMTransactionType transactionTypeForInvoice = MFMTransactionType.getTransactionTypeFromType((Properties)this.getCtx(), (String)FARMING_FINANCING_INVOICING);
            MFMTransactionType transactionTypeForTax = MFMTransactionType.getTransactionTypeFromType((Properties)this.getCtx(), (String)FARMING_FINANCING_TAX);
            MFMTransactionType transactionTypeForInterest = MFMTransactionType.getTransactionTypeFromType((Properties)this.getCtx(), (String)FARMING_FINANCING_INTEREST);
            MFMTransactionType transactionTypeForInterestTax = MFMTransactionType.getTransactionTypeFromType((Properties)this.getCtx(), (String)FARMING_FINANCING_INTEREST_TAX);
            if (transactionTypeForOrder == null) {
                throw new AdempiereException("@FM_TransactionType_ID@ @NotFound@ " + MRefList.getListName((Properties)this.getCtx(), (int)54020, (String)"FFO"));
            }
            if (transactionTypeForInvoice == null) {
                throw new AdempiereException("@FM_TransactionType_ID@ @NotFound@ " + MRefList.getListName((Properties)this.getCtx(), (int)54020, (String)FARMING_FINANCING_INVOICING));
            }
            if (transactionTypeForTax == null) {
                throw new AdempiereException("@FM_TransactionType_ID@ @NotFound@ " + MRefList.getListName((Properties)this.getCtx(), (int)54020, (String)FARMING_FINANCING_TAX));
            }
            for (MInvoiceLine mInvoiceLine : invoice.getLines()) {
                BigDecimal baseAmount;
                MFMTransaction transaction;
                if (Optional.ofNullable(mInvoiceLine.getLineNetAmt()).orElse(Env.ZERO).compareTo(Env.ZERO) == 0) continue;
                MOrderLine orderLine = null;
                if (mInvoiceLine.getC_OrderLine_ID() > 0) {
                    orderLine = (MOrderLine)mInvoiceLine.getC_OrderLine();
                }
                if (orderLine != null && invoice.isSOTrx()) {
                    MTax taxDefinition;
                    BigDecimal reversalBaseAmount = mInvoiceLine.getQtyInvoiced().multiply(orderLine.getPriceActual()).multiply(multiplier.negate());
                    MFMTransaction reversalTransaction = batch.addTransaction(transactionTypeForInvoice.getFM_TransactionType_ID(), invoice.getC_Currency_ID(), invoice.getC_ConversionType_ID(), reversalBaseAmount);
                    if (reversalTransaction != null) {
                        reversalTransaction.set_ValueOfColumn("C_Invoice_ID", (Object)mInvoiceLine.getC_Invoice_ID());
                        reversalTransaction.setC_InvoiceLine_ID(mInvoiceLine.getC_InvoiceLine_ID());
                        reversalTransaction.set_ValueOfColumn("C_Order_ID", (Object)orderLine.getC_Order_ID());
                        reversalTransaction.set_ValueOfColumn("C_OrderLine_ID", (Object)orderLine.getC_OrderLine_ID());
                        reversalTransaction.set_ValueOfColumn("Description", (Object)Msg.parseTranslation((Properties)this.getCtx(), (String)("@ReversedBy@ @C_Invoice_ID@ " + invoice.getDocumentNo())));
                        reversalTransaction.set_ValueOfColumn("IsFarmerTransactionReversal", (Object)true);
                        reversalTransaction.saveEx();
                    }
                    if (Optional.ofNullable((taxDefinition = MTax.get((Properties)this.getCtx(), (int)orderLine.getC_Tax_ID())).getRate()).orElse(Env.ZERO).compareTo(Env.ZERO) > 0 && !taxDefinition.isTaxExempt()) {
                        BigDecimal taxAmount = reversalBaseAmount.multiply(taxDefinition.getRate()).divide(Env.ONEHUNDRED);
                        MFMTransaction reversalTransactionTax = batch.addTransaction(transactionTypeForTax.getFM_TransactionType_ID(), invoice.getC_Currency_ID(), invoice.getC_ConversionType_ID(), taxAmount);
                        if (reversalTransactionTax != null) {
                            reversalTransaction.set_ValueOfColumn("C_Invoice_ID", (Object)mInvoiceLine.getC_Invoice_ID());
                            reversalTransaction.setC_InvoiceLine_ID(mInvoiceLine.getC_InvoiceLine_ID());
                            reversalTransaction.set_ValueOfColumn("C_Order_ID", (Object)orderLine.getC_Order_ID());
                            reversalTransaction.set_ValueOfColumn("C_OrderLine_ID", (Object)orderLine.getC_OrderLine_ID());
                            reversalTransaction.set_ValueOfColumn("Description", (Object)Msg.parseTranslation((Properties)this.getCtx(), (String)("@ReversedBy@ @C_Invoice_ID@ " + invoice.getDocumentNo())));
                            reversalTransaction.set_ValueOfColumn("IsFarmerTransactionReversal", (Object)true);
                            reversalTransactionTax.saveEx();
                        }
                    }
                }
                if ((transaction = batch.addTransaction(transactionTypeForInvoice.getFM_TransactionType_ID(), invoice.getC_Currency_ID(), invoice.getC_ConversionType_ID(), mInvoiceLine.getLineNetAmt().multiply(multiplier))) != null) {
                    transaction.set_ValueOfColumn("C_Invoice_ID", (Object)mInvoiceLine.getC_Invoice_ID());
                    transaction.setC_InvoiceLine_ID(mInvoiceLine.getC_InvoiceLine_ID());
                    if (orderLine != null) {
                        transaction.set_ValueOfColumn("C_Order_ID", (Object)orderLine.getC_Order_ID());
                        transaction.set_ValueOfColumn("C_OrderLine_ID", (Object)orderLine.getC_OrderLine_ID());
                    }
                    if (!Util.isEmpty((String)mInvoiceLine.getDescription())) {
                        transaction.set_ValueOfColumn("Description", (Object)mInvoiceLine.getDescription());
                        transaction.saveEx();
                    }
                    transaction.saveEx();
                }
                boolean applyInterestFromLine = false;
                if (mInvoiceLine.getM_Product_ID() > 0) {
                    applyInterestFromLine = MProduct.get((Properties)this.getCtx(), (int)mInvoiceLine.getM_Product_ID()).get_ValueAsBoolean("IsFarmerInvoiceInterest");
                } else if (mInvoiceLine.getC_Charge_ID() > 0) {
                    applyInterestFromLine = MCharge.get((Properties)this.getCtx(), (int)mInvoiceLine.getC_Charge_ID()).get_ValueAsBoolean("IsFarmerInvoiceInterest");
                }
                if (!applyInterestFromLine && !documentType.get_ValueAsBoolean("IsFarmerInvoiceInterest")) continue;
                MFMProduct financialProduct = MFMProduct.getById((Properties)this.getCtx(), (int)agreement.getFM_Product_ID(), (String)transactionName);
                int rateId = financialProduct.get_ValueAsInt("FarmerInvoiceInterest_ID");
                if (rateId == 0) {
                    return null;
                }
                BigDecimal interestRate = Env.ZERO;
                BigDecimal taxRate = Env.ZERO;
                MCharge charge = null;
                if (rateId != 0) {
                    MFMRate rate = MFMRate.getById((Properties)this.getCtx(), (int)rateId);
                    interestRate = rate.getValidRate(invoice.getDateInvoiced());
                    charge = MCharge.get((Properties)this.getCtx(), (int)rate.getC_Charge_ID());
                }
                if (charge != null) {
                    MTaxCategory taxCategory = (MTaxCategory)charge.getC_TaxCategory();
                    MTax tax = taxCategory.getDefaultTax();
                    interestRate = interestRate.divide(Env.ONEHUNDRED);
                    taxRate = tax.getRate().divide(Env.ONEHUNDRED);
                    interestRate = interestRate.add(interestRate.multiply(taxRate));
                }
                if (interestRate.compareTo(Env.ZERO) == 0 || (baseAmount = Optional.ofNullable(mInvoiceLine.getLineNetAmt().multiply(multiplier)).orElse(Env.ZERO)).compareTo(Env.ZERO) == 0) continue;
                BigDecimal amount = baseAmount.multiply(interestRate);
                BigDecimal taxAmount = amount.multiply(taxRate);
                transaction = batch.addTransaction(transactionTypeForInterest.getFM_TransactionType_ID(), invoice.getC_Currency_ID(), invoice.getC_ConversionType_ID(), amount);
                if (transaction != null) {
                    transaction.set_ValueOfColumn("C_Invoice_ID", (Object)mInvoiceLine.getC_Invoice_ID());
                    transaction.setC_InvoiceLine_ID(mInvoiceLine.getC_InvoiceLine_ID());
                    if (orderLine != null) {
                        transaction.set_ValueOfColumn("C_Order_ID", (Object)orderLine.getC_Order_ID());
                        transaction.set_ValueOfColumn("C_OrderLine_ID", (Object)orderLine.getC_OrderLine_ID());
                    }
                    if (!Util.isEmpty((String)mInvoiceLine.getDescription())) {
                        transaction.set_ValueOfColumn("Description", (Object)mInvoiceLine.getDescription());
                        transaction.saveEx();
                    }
                    transaction.saveEx();
                }
                if (taxAmount.compareTo(Env.ZERO) <= 0 || (transaction = batch.addTransaction(transactionTypeForInterestTax.getFM_TransactionType_ID(), invoice.getC_Currency_ID(), invoice.getC_ConversionType_ID(), taxAmount)) == null) continue;
                transaction.set_ValueOfColumn("C_Invoice_ID", (Object)mInvoiceLine.getC_Invoice_ID());
                transaction.setC_InvoiceLine_ID(mInvoiceLine.getC_InvoiceLine_ID());
                if (orderLine != null) {
                    transaction.set_ValueOfColumn("C_Order_ID", (Object)orderLine.getC_Order_ID());
                    transaction.set_ValueOfColumn("C_OrderLine_ID", (Object)orderLine.getC_OrderLine_ID());
                }
                if (!Util.isEmpty((String)mInvoiceLine.getDescription())) {
                    transaction.set_ValueOfColumn("Description", (Object)mInvoiceLine.getDescription());
                    transaction.saveEx();
                }
                transaction.saveEx();
            }
            for (MInvoiceLine mInvoiceLine : invoice.getTaxes(true)) {
                MFMTransaction transaction;
                if (Optional.ofNullable(mInvoiceLine.getTaxAmt()).orElse(Env.ZERO).signum() == 0 || (transaction = batch.addTransaction(transactionTypeForTax.getFM_TransactionType_ID(), invoice.getC_Currency_ID(), invoice.getC_ConversionType_ID(), mInvoiceLine.getTaxAmt().multiply(multiplier))) == null) continue;
                transaction.set_ValueOfColumn("C_Invoice_ID", (Object)mInvoiceLine.getC_Invoice_ID());
                transaction.saveEx();
            }
            if (!Util.isEmpty((String)invoice.getDescription())) {
                batch.setDescription(invoice.getDescription());
                batch.saveEx();
            }
            batch.set_ValueOfColumn("IsFarmerOverdraftCreditLimit", (Object)invoice.get_ValueAsBoolean("IsFarmerOverdraftCreditLimit"));
            batch.set_ValueOfColumn("IsFarmerAssistanceProgram", (Object)true);
            batch.processIt("CO");
            batch.saveEx();
        }
        return null;
    }
}

