/*
 * Decompiled with CFR 0.152.
 */
package org.farming.engine.financing;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Optional;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.spin.model.MFMAgreement;
import org.spin.model.MFMBatch;
import org.spin.model.MFMFunctionalSetting;
import org.spin.model.MFMTransaction;
import org.spin.model.MFMTransactionType;
import org.spin.util.AbstractFunctionalSetting;

public class Charge
extends AbstractFunctionalSetting {
    public Charge(MFMFunctionalSetting setting) {
        super(setting);
    }

    public String run() {
        String transactionName = (String)this.getParameter("TRX_NAME");
        BigDecimal transactionAmount = this.getParameterAsBigDecimal("Amount");
        int agreementId = this.getParameterAsInt("FM_Agreement_ID");
        int transactionTypeId = this.getParameterAsInt("FM_TransactionType_ID");
        Timestamp documentDate = (Timestamp)this.getParameter("DateDoc");
        String description = (String)this.getParameter("Description");
        if (Optional.ofNullable(transactionAmount).orElse(Env.ZERO).signum() == 0) {
            throw new AdempiereException("@Amount@ @IsMandatory@");
        }
        MFMAgreement agreement = MFMAgreement.getById((Properties)this.getCtx(), (int)agreementId, (String)transactionName);
        if (agreement == null) {
            throw new AdempiereException("@FM_Agreement_ID@ @IsMandatory@");
        }
        MFMBatch batch = (MFMBatch)this.getParameter("MFMBatch");
        if (batch != null) {
            MFMTransactionType transactionTypeForPayment = MFMTransactionType.getById((Properties)this.getCtx(), (int)transactionTypeId);
            if (transactionTypeForPayment == null) {
                throw new AdempiereException("@FM_TransactionType_ID@ @NotFound@");
            }
            MFMTransaction transaction = batch.addTransaction(transactionTypeForPayment.getFM_TransactionType_ID(), transactionAmount);
            if (transaction != null) {
                if (!Util.isEmpty((String)description)) {
                    transaction.set_ValueOfColumn("Description", (Object)description);
                    transaction.saveEx();
                }
                transaction.saveEx();
            }
            if (!Util.isEmpty((String)description)) {
                batch.setDescription(description);
            }
            batch.setDateDoc(documentDate);
            batch.set_ValueOfColumn("IsFarmerAssistanceProgram", (Object)true);
            batch.saveEx();
        }
        return null;
    }
}

