/*
 * Decompiled with CFR 0.152.
 */
package org.farming.engine;

import java.math.BigDecimal;
import java.math.MathContext;
import java.sql.Timestamp;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.compiere.util.Env;
import org.farming.engine.CategoryEngine;

public class Legumes_ConditionedWeight
extends CategoryEngine {
    public static final String COLUMNNAME_Ground = "Ground";
    public static final String COLUMNNAME_Broken_Grains = "Broken_Grains";
    public static final String COLUMNNAME_Scrap = "Scrap";

    @Override
    public BigDecimal calculate(Properties context, int bPartnerId, int productId, Timestamp date, BigDecimal netWeight, Map<String, Object> parameters, String transactionName) {
        BigDecimal ground = Optional.ofNullable((BigDecimal)parameters.get(COLUMNNAME_Ground)).orElse(Env.ZERO);
        BigDecimal brokenGrains = Optional.ofNullable((BigDecimal)parameters.get(COLUMNNAME_Broken_Grains)).orElse(Env.ZERO);
        BigDecimal scrap = Optional.ofNullable((BigDecimal)parameters.get(COLUMNNAME_Scrap)).orElse(Env.ZERO);
        BigDecimal totalScrap = Optional.ofNullable(ground.add(brokenGrains).add(scrap)).orElse(Env.ZERO);
        BigDecimal subTotal = Optional.ofNullable(netWeight).orElse(Env.ZERO).multiply(totalScrap).divide(Env.ONEHUNDRED, MathContext.DECIMAL128);
        return Optional.ofNullable(netWeight).orElse(Env.ZERO).subtract(subTotal);
    }
}

