/*
 * Decompiled with CFR 0.152.
 */
package org.farming.engine;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.util.CLogger;
import org.compiere.util.Util;
import org.farming.engine.CategoryEngine;
import org.farming.model.MFAPWeightCalculation;

public class CategoryEngineFactory {
    private static final CategoryEngineFactory instance = new CategoryEngineFactory();
    private static final CLogger logger = CLogger.getCLogger(CategoryEngineFactory.class);
    private static final Map<Integer, CategoryEngine> categoryCalculationEngines = new HashMap<Integer, CategoryEngine>();

    public static CategoryEngineFactory getInstance() {
        return instance;
    }

    private CategoryEngineFactory() {
    }

    public CategoryEngine getEngine(MFAPWeightCalculation calculation) {
        if (calculation == null) {
            return null;
        }
        CategoryEngine engine = categoryCalculationEngines.get(calculation.getFAP_WeightCalculation_ID());
        if (engine == null) {
            return this.loadEngine(calculation);
        }
        return engine;
    }

    private Class<?> getHandlerClass(MFAPWeightCalculation calculation) {
        String className = calculation.getClassname();
        if (Util.isEmpty((String)className)) {
            return null;
        }
        try {
            Class<?> clazz = Class.forName(className);
            if (CategoryEngine.class.isAssignableFrom(clazz)) {
                return clazz;
            }
            for (Class<?> superClazz = clazz.getSuperclass(); superClazz != null; superClazz = superClazz.getSuperclass()) {
                if (superClazz != CategoryEngine.class) continue;
                logger.log(Level.SEVERE, "Error loading class, Use: " + className);
                return clazz;
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Loading class Error" + e.getMessage());
        }
        logger.log(Level.SEVERE, "Not found Class: " + className);
        return null;
    }

    private CategoryEngine loadEngine(MFAPWeightCalculation calculation) {
        CategoryEngine engine = null;
        try {
            Class<?> clazz = this.getHandlerClass(calculation);
            if (clazz == null) {
                logger.log(Level.SEVERE, "Class not found, Using Standard Class");
                engine = null;
                throw new AdempiereException("@Classname@ @NotFound@");
            }
            Constructor<?> constructor = clazz.getDeclaredConstructor(new Class[0]);
            engine = (CategoryEngine)constructor.newInstance(new Object[0]);
            categoryCalculationEngines.put(calculation.getFAP_WeightCalculation_ID(), engine);
        }
        catch (Exception e) {
            throw new AdempiereException((Throwable)e);
        }
        return engine;
    }
}

