/*
 * Decompiled with CFR 0.152.
 */
package org.spin.mt.process;

import java.util.Arrays;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MColumn;
import org.compiere.model.MMenu;
import org.compiere.model.MProcess;
import org.compiere.model.MProcessAccess;
import org.compiere.model.MProcessPara;
import org.compiere.model.MReportView;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.print.MPrintFormat;
import org.compiere.print.MPrintFormatItem;
import org.compiere.util.DB;
import org.eevolution.service.dsl.ProcessBuilder;
import org.spin.mt.process.CopyTableAbstract;

public class CopyTable
extends CopyTableAbstract {
    private StringBuffer copyInfo = new StringBuffer();

    @Override
    protected void prepare() {
        super.prepare();
        if (this.getRecord_ID() <= 0) {
            throw new AdempiereException("@Record_ID@ @NotFound@");
        }
    }

    protected String doIt() throws Exception {
        MTable sourceTable = new MTable(this.getCtx(), this.getRecord_ID(), this.get_TrxName());
        this.copyTable(sourceTable);
        return this.copyInfo.toString();
    }

    private void copyTable(MTable sourceTable) {
        MTable targetTable = new MTable(this.getCtx(), 0, this.get_TrxName());
        PO.copyValues((PO)sourceTable, (PO)sourceTable);
        targetTable.setTableName(sourceTable.getTableName() + this.getSuffix());
        targetTable.setName(sourceTable.getName() + this.getSuffix());
        targetTable.setEntityType(this.getEntityType());
        targetTable.setAccessLevel(sourceTable.getAccessLevel());
        targetTable.setIsView(sourceTable.isView());
        targetTable.setIsDeleteable(sourceTable.isDeleteable());
        targetTable.saveEx();
        ProcessBuilder.create((Properties)this.getCtx()).process(Integer.valueOf(50011)).withParameter("AD_Table_ID", (Object)sourceTable.getAD_Table_ID()).withRecordId(Integer.valueOf(MTable.Table_ID), Integer.valueOf(targetTable.getAD_Table_ID())).withoutTransactionClose().execute(this.get_TrxName());
        this.copyTranslation((PO)sourceTable, (PO)targetTable);
        this.copyReportViews(sourceTable, targetTable);
        this.copyPrintFormats(sourceTable, targetTable);
    }

    private void copyProcessesFromView(MReportView sourceReportView, MReportView targetReportView) {
        new Query(this.getCtx(), "AD_Process", "AD_ReportView_ID = ?", this.get_TrxName()).setParameters(new Object[]{sourceReportView.getAD_ReportView_ID()}).setOnlyActiveRecords(true).list().forEach(sourceProcess -> {
            MProcess targetProcess = new MProcess(this.getCtx(), 0, this.get_TrxName());
            PO.copyValues((PO)sourceProcess, (PO)targetProcess);
            targetProcess.setAD_ReportView_ID(targetReportView.getAD_ReportView_ID());
            targetProcess.setValue(sourceProcess.getValue() + this.getSuffix());
            targetProcess.setName(sourceProcess.getName() + this.getSuffix());
            targetProcess.setEntityType(this.getEntityType());
            targetProcess.saveEx();
            sourceProcess.getParametersAsList().forEach(sourceParameter -> {
                MProcessPara targetParameter = new MProcessPara(targetProcess);
                PO.copyValues((PO)sourceParameter, (PO)targetParameter);
                targetParameter.setEntityType(this.getEntityType());
                targetParameter.setAD_Process_ID(targetProcess.getAD_Process_ID());
                targetParameter.saveEx(this.get_TrxName());
            });
            this.copyProcessAccesses((MProcess)sourceProcess, targetProcess);
            this.copyTranslation((PO)sourceProcess, (PO)targetProcess);
            this.copyMenuFromProcess((MProcess)sourceProcess, targetProcess);
        });
    }

    private void copyProcessAccesses(MProcess sourceProcess, MProcess targetProcess) {
        new Query(this.getCtx(), "AD_Process_Access", "AD_Process_ID = ? AND NOT EXISTS(SELECT 1 FROM AD_Process_Access ra WHERE ra.AD_Role_ID = AD_Process_Access.AD_Role_ID AND ra.AD_Process_ID = ?)", this.get_TrxName()).setParameters(new Object[]{sourceProcess.getAD_Process_ID(), targetProcess.getAD_Process_ID()}).list().stream().forEach(currentProcessAccess -> {
            MProcessAccess newProcessaccess = new MProcessAccess(targetProcess, currentProcessAccess.getAD_Role_ID());
            newProcessaccess.setIsActive(currentProcessAccess.isActive());
            newProcessaccess.setIsReadWrite(currentProcessAccess.isReadWrite());
            newProcessaccess.saveEx(this.get_TrxName());
            this.addLog("@AD_Role_ID@ @Added@: " + newProcessaccess.getAD_Role().getName());
        });
    }

    private void copyProcessesFromTable(MPrintFormat sourcePrintFormat, MPrintFormat targetPrintFormat) {
        new Query(this.getCtx(), "AD_Process", "AD_PrintFormat_ID = ?", this.get_TrxName()).setParameters(new Object[]{sourcePrintFormat.getAD_PrintFormat_ID()}).setOnlyActiveRecords(true).list().forEach(sourceProcess -> {
            MProcess targetProcess = new MProcess(this.getCtx(), 0, this.get_TrxName());
            PO.copyValues((PO)sourceProcess, (PO)targetProcess);
            if (sourceProcess.getAD_ReportView_ID() > 0 && targetPrintFormat.getAD_ReportView_ID() > 0) {
                targetProcess.setAD_ReportView_ID(targetPrintFormat.getAD_ReportView_ID());
            } else {
                targetProcess.setAD_ReportView_ID(-1);
            }
            targetProcess.setAD_PrintFormat_ID(targetPrintFormat.getAD_PrintFormat_ID());
            targetProcess.setValue(sourceProcess.getValue() + this.getSuffix());
            targetProcess.setName(sourceProcess.getName() + this.getSuffix());
            targetProcess.setEntityType(this.getEntityType());
            targetProcess.saveEx();
            sourceProcess.getParametersAsList().forEach(sourceParameter -> {
                MProcessPara targetParameter = new MProcessPara(targetProcess);
                PO.copyValues((PO)sourceParameter, (PO)targetParameter);
                targetParameter.setEntityType(this.getEntityType());
                targetParameter.setAD_Process_ID(targetProcess.getAD_Process_ID());
                targetParameter.saveEx(this.get_TrxName());
            });
            this.copyProcessAccesses((MProcess)sourceProcess, targetProcess);
            this.copyTranslation((PO)sourceProcess, (PO)targetProcess);
            this.copyMenuFromProcess((MProcess)sourceProcess, targetProcess);
        });
    }

    private void copyMenuFromProcess(MProcess sourceProcess, MProcess targetProcess) {
        new Query(this.getCtx(), "AD_Menu", "AD_Process_ID = ?", this.get_TrxName()).setParameters(new Object[]{sourceProcess.getAD_Process_ID()}).setOnlyActiveRecords(true).list().forEach(sourceMenu -> {
            MMenu targetMenu = new MMenu(this.getCtx(), 0, this.get_TrxName());
            PO.copyValues((PO)sourceMenu, (PO)targetMenu);
            targetMenu.setAD_Process_ID(targetProcess.getAD_Process_ID());
            targetMenu.setEntityType(this.getEntityType());
            targetMenu.setName(sourceMenu.getName() + this.getSuffix());
            targetMenu.saveEx();
            new Query(this.getCtx(), "AD_TreeNodeMM", "Node_ID = ?", this.get_TrxName()).setParameters(new Object[]{sourceMenu.getAD_Menu_ID()}).list().forEach(sourceNode -> new Query(this.getCtx(), "AD_TreeNodeMM", "Node_ID = ?", this.get_TrxName()).setParameters(new Object[]{targetMenu.getAD_Menu_ID()}).list().forEach(targetNode -> {
                if (sourceNode.getParent_ID() > 0) {
                    targetNode.setParent_ID(sourceNode.getParent_ID());
                }
                targetNode.setSeqNo(sourceNode.getSeqNo());
                targetNode.saveEx();
            }));
            this.copyTranslation((PO)sourceMenu, (PO)targetMenu);
        });
    }

    private void copyTranslation(PO source, PO target) {
        String tableName = source.get_TableName() + "_Trl";
        MTable.get((Properties)this.getCtx(), (int)source.get_Table_ID()).getColumnsAsList().stream().filter(column -> column.isTranslated()).findAny().ifPresent(column -> new Query(this.getCtx(), tableName, source.get_KeyColumns()[0] + " = ?", this.get_TrxName()).setParameters(new Object[]{source.get_ID()}).list().forEach(sourceTranslation -> new Query(this.getCtx(), tableName, target.get_KeyColumns()[0] + " = ? AND AD_Language = ?", this.get_TrxName()).setParameters(new Object[]{target.get_ID(), sourceTranslation.get_ValueAsString("AD_Language")}).list().forEach(targetTranslation -> {
            MTable.get((Properties)this.getCtx(), (int)source.get_Table_ID()).getColumnsAsList().stream().filter(translatedColumn -> translatedColumn.isTranslated()).forEach(translatedColumn -> targetTranslation.set_ValueOfColumn(translatedColumn.getColumnName(), sourceTranslation.get_Value(translatedColumn.getColumnName())));
            targetTranslation.saveEx();
        })));
    }

    private void copyReportViews(MTable sourceTable, MTable targetTable) {
        new Query(this.getCtx(), "AD_ReportView", "AD_Table_ID = ?", this.get_TrxName()).setParameters(new Object[]{sourceTable.getAD_Table_ID()}).setOnlyActiveRecords(true).list().forEach(sourceReportView -> {
            MReportView targetReportView = new MReportView(this.getCtx(), 0, this.get_TrxName());
            PO.copyValues((PO)sourceReportView, (PO)targetReportView);
            targetReportView.setAD_Table_ID(targetTable.getAD_Table_ID());
            targetReportView.setName(sourceReportView.getName() + this.getSuffix());
            targetReportView.setEntityType(this.getEntityType());
            targetReportView.saveEx();
            this.copyTranslation((PO)sourceReportView, (PO)targetReportView);
            this.copyProcessesFromView((MReportView)sourceReportView, targetReportView);
        });
    }

    private void copyPrintFormats(MTable sourceTable, MTable targetTable) {
        new Query(this.getCtx(), "AD_PrintFormat", "AD_Table_ID = ?", this.get_TrxName()).setParameters(new Object[]{sourceTable.getAD_Table_ID()}).setOnlyActiveRecords(true).list().forEach(sourcePrintFormat -> {
            MPrintFormat targetPrintFormat = new MPrintFormat(this.getCtx(), 0, this.get_TrxName());
            PO.copyValues((PO)sourcePrintFormat, (PO)targetPrintFormat);
            targetPrintFormat.setAD_Table_ID(targetTable.getAD_Table_ID());
            if (sourcePrintFormat.getAD_ReportView_ID() > 0) {
                MReportView sourceReportView = MReportView.get((Properties)this.getCtx(), (int)sourcePrintFormat.getAD_ReportView_ID());
                int targetReportViewId = new Query(this.getCtx(), "AD_ReportView", "AD_Table_ID = ? AND Name = ?", this.get_TrxName()).setParameters(new Object[]{targetTable.getAD_Table_ID(), sourceReportView.getName() + this.getSuffix()}).firstId();
                targetPrintFormat.setAD_ReportView_ID(targetReportViewId);
            }
            targetPrintFormat.setName(sourcePrintFormat.getName() + this.getSuffix());
            targetPrintFormat.saveEx(this.get_TrxName());
            AtomicInteger sequence = new AtomicInteger();
            Arrays.asList(sourcePrintFormat.getItems()).forEach(sourcePrintFormatItem -> {
                if (sourcePrintFormatItem.getAD_Column_ID() > 0) {
                    String sourceColumnName = MColumn.getColumnName((Properties)this.getCtx(), (int)sourcePrintFormatItem.getAD_Column_ID());
                    MTable.get((Properties)this.getCtx(), (int)targetTable.getAD_Table_ID()).getColumnsAsList().stream().filter(column -> column.getColumnName().equals(sourceColumnName)).findFirst().ifPresent(targetColumn -> {
                        MPrintFormatItem targetPrintFormatItem = MPrintFormatItem.createFromColumn((MPrintFormat)targetPrintFormat, (int)targetColumn.getAD_Column_ID(), (int)sequence.addAndGet(10));
                        PO.copyValues((PO)sourcePrintFormatItem, (PO)targetPrintFormatItem);
                        targetPrintFormatItem.setAD_PrintFormat_ID(targetPrintFormat.getAD_PrintFormat_ID());
                        targetPrintFormatItem.setAD_Column_ID(targetColumn.getAD_Column_ID());
                        targetPrintFormatItem.saveEx(this.get_TrxName());
                        this.copyTranslation((PO)sourcePrintFormatItem, (PO)targetPrintFormatItem);
                    });
                } else {
                    MPrintFormatItem targetPrintFormatItem = new MPrintFormatItem(this.getCtx(), 0, this.get_TrxName());
                    PO.copyValues((PO)sourcePrintFormatItem, (PO)targetPrintFormatItem);
                    targetPrintFormatItem.setAD_PrintFormat_ID(targetPrintFormat.getAD_PrintFormat_ID());
                    targetPrintFormatItem.saveEx(this.get_TrxName());
                    this.copyTranslation((PO)sourcePrintFormatItem, (PO)targetPrintFormatItem);
                }
            });
            DB.executeUpdateEx((String)"UPDATE AD_PrintFormat SET AD_Client_ID = ?, AD_Org_ID = ? WHERE AD_PrintFormat_ID = ?", (Object[])new Object[]{sourcePrintFormat.getAD_Client_ID(), sourcePrintFormat.getAD_Org_ID(), targetPrintFormat.getAD_PrintFormat_ID()}, (String)this.get_TrxName());
            DB.executeUpdateEx((String)"UPDATE AD_PrintFormatItem SET AD_Client_ID = ?, AD_Org_ID = ? WHERE AD_PrintFormat_ID = ?", (Object[])new Object[]{sourcePrintFormat.getAD_Client_ID(), sourcePrintFormat.getAD_Org_ID(), targetPrintFormat.getAD_PrintFormat_ID()}, (String)this.get_TrxName());
            this.copyProcessesFromTable((MPrintFormat)sourcePrintFormat, targetPrintFormat);
        });
    }
}

