/*
 * Decompiled with CFR 0.152.
 */
package org.spin.rw.model;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MClientInfo;
import org.compiere.model.MDocType;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MPeriod;
import org.compiere.model.MProduct;
import org.compiere.model.MUOMConversion;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.process.DocAction;
import org.compiere.process.DocOptions;
import org.compiere.process.DocumentEngine;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.eevolution.model.MDDFreight;
import org.eevolution.model.MWMInOutBound;
import org.eevolution.model.MWMInOutBoundLine;
import org.spin.rw.model.X_DD_RecordWeight;

public class MDDRecordWeight
extends X_DD_RecordWeight
implements DocAction,
DocOptions {
    private static final long serialVersionUID = 20190705L;
    private String m_processMsg = null;
    private boolean m_justPrepared = false;

    public MDDRecordWeight(Properties ctx, int DD_RecordWeight_ID, String trxName) {
        super(ctx, DD_RecordWeight_ID, trxName);
    }

    public MDDRecordWeight(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public String getDocumentInfo() {
        MDocType dt = MDocType.get((Properties)this.getCtx(), (int)this.getC_DocType_ID());
        return dt.getName() + " " + this.getDocumentNo();
    }

    public File createPDF() {
        try {
            File temp = File.createTempFile(this.get_TableName() + this.get_ID() + "_", ".pdf");
            return this.createPDF(temp);
        }
        catch (Exception e) {
            this.log.severe("Could not create PDF - " + e.getMessage());
            return null;
        }
    }

    public File createPDF(File file) {
        return null;
    }

    public boolean processIt(String processAction) {
        this.m_processMsg = null;
        DocumentEngine engine = new DocumentEngine((DocAction)this, this.getDocStatus());
        return engine.processIt(processAction, this.getDocAction());
    }

    public boolean unlockIt() {
        this.log.info("unlockIt - " + this.toString());
        return true;
    }

    public boolean invalidateIt() {
        this.log.info("invalidateIt - " + this.toString());
        this.setDocAction("PR");
        return true;
    }

    public String prepareIt() {
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        MDocType dt = MDocType.get((Properties)this.getCtx(), (int)this.getC_DocType_ID());
        if (!MPeriod.isOpen((Properties)this.getCtx(), (Timestamp)this.getDateDoc(), (String)dt.getDocBaseType(), (int)this.getAD_Org_ID())) {
            this.m_processMsg = "@PeriodClosed@";
            return "IN";
        }
        if (!this.isSOTrx() && this.getWeightStatus().equals("G")) {
            throw new AdempiereException("@FillMandatory@ @GrossWeight@");
        }
        if (this.isSOTrx() && this.getWeightStatus().equals("T")) {
            throw new AdempiereException("@FillMandatory@ @TareWeight@");
        }
        this.getWeightFromDocuments();
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 8);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.m_justPrepared = true;
        if (!"CO".equals(this.getDocAction())) {
            this.setDocAction("CO");
        }
        return "IP";
    }

    private void getWeightFromDocuments() {
        MDDFreight freightOrder;
        BigDecimal minimumWeight = Env.ZERO;
        BigDecimal maximumWeight = Env.ZERO;
        if (this.getC_OrderLine_ID() != 0) {
            MOrderLine orderLine = new MOrderLine(this.getCtx(), this.getC_OrderLine_ID(), this.get_TrxName());
            if (orderLine.getM_Product_ID() != 0) {
                MProduct product = MProduct.get((Properties)this.getCtx(), (int)orderLine.getM_Product_ID());
                if (product.get_Value("MinimumWeight") != null) {
                    minimumWeight = (BigDecimal)product.get_Value("MinimumWeight");
                    minimumWeight = minimumWeight.multiply(orderLine.getQtyOrdered());
                }
                if (product.get_Value("MaximumWeight") != null) {
                    maximumWeight = (BigDecimal)product.get_Value("MaximumWeight");
                    maximumWeight = maximumWeight.multiply(orderLine.getQtyOrdered());
                }
            }
        } else if (this.getC_Order_ID() != 0) {
            MOrder order = new MOrder(this.getCtx(), this.getC_Order_ID(), this.get_TrxName());
            for (MOrderLine orderLine : order.getLines()) {
                if (orderLine.getM_Product_ID() == 0) continue;
                MProduct product = MProduct.get((Properties)this.getCtx(), (int)orderLine.getM_Product_ID());
                if (product.get_Value("MinimumWeight") != null) {
                    minimumWeight = minimumWeight.add((BigDecimal)product.get_Value("MinimumWeight"));
                }
                if (product.get_Value("MaximumWeight") == null) continue;
                maximumWeight = maximumWeight.add((BigDecimal)product.get_Value("MaximumWeight"));
            }
        } else if (this.getDD_Freight_ID() != 0 && (freightOrder = new MDDFreight(this.getCtx(), this.getDD_Freight_ID(), this.get_TrxName())).getWM_InOutBound_ID() != 0) {
            MWMInOutBound outbound = new MWMInOutBound(this.getCtx(), freightOrder.getWM_InOutBound_ID(), this.get_TrxName());
            for (MWMInOutBoundLine outBoundLine : outbound.getLines(true, "Line")) {
                if (outBoundLine.getM_Product_ID() == 0) continue;
                MProduct product = MProduct.get((Properties)this.getCtx(), (int)outBoundLine.getM_Product_ID());
                if (product.get_Value("MinimumWeight") != null) {
                    minimumWeight = minimumWeight.add((BigDecimal)product.get_Value("MinimumWeight"));
                }
                if (product.get_Value("MaximumWeight") == null) continue;
                maximumWeight = maximumWeight.add((BigDecimal)product.get_Value("MaximumWeight"));
            }
        }
        this.setMinimumWeight(minimumWeight);
        this.setMaximumWeight(maximumWeight);
        this.saveEx();
    }

    public boolean approveIt() {
        this.log.info("approveIt - " + this.toString());
        this.setIsApproved(true);
        return true;
    }

    public boolean rejectIt() {
        this.log.info("rejectIt - " + this.toString());
        this.setIsApproved(false);
        return true;
    }

    public String completeIt() {
        String status;
        if (!this.m_justPrepared && !"IP".equals(status = this.prepareIt())) {
            return status;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 7);
        if (this.m_processMsg != null) {
            return "IN";
        }
        if (!this.getWeightStatus().equals("C")) {
            throw new AdempiereException("@IncompleteRecordWeight@");
        }
        if (!this.isApproved()) {
            this.approveIt();
        }
        this.log.info(this.toString());
        String valid = ModelValidationEngine.get().fireDocValidate((PO)this, 9);
        if (valid != null) {
            this.m_processMsg = valid;
            return "IN";
        }
        this.setDefiniteDocumentNo();
        this.setProcessed(true);
        this.setDocAction("CL");
        return "CO";
    }

    protected boolean beforeSave(boolean newRecord) {
        if (this.getC_UOM_ID() == 0) {
            int uomWeightId = MClientInfo.get((Properties)this.getCtx()).getC_UOM_Weight_ID();
            if (uomWeightId == 0) {
                throw new AdempiereException("@FillMandatory@ @C_UOM_ID@");
            }
            this.setC_UOM_ID(uomWeightId);
        }
        if (this.is_ValueChanged("DD_Freight_ID")) {
            this.setFreightValues();
        }
        if (!this.is_ValueChanged("WeightRegistered")) {
            return true;
        }
        BigDecimal weightRegistered = this.getWeightRegistered();
        BigDecimal grossWeight = this.getGrossWeight();
        BigDecimal tareWeight = this.getTareWeight();
        if (weightRegistered == null) {
            weightRegistered = Env.ZERO;
        }
        if (grossWeight == null) {
            grossWeight = Env.ZERO;
        }
        if (tareWeight == null) {
            tareWeight = Env.ZERO;
        }
        if (weightRegistered.equals(Env.ZERO)) {
            if (!this.isSOTrx()) {
                this.setWeightStatus("G");
            } else {
                this.setWeightStatus("T");
            }
            return true;
        }
        Timestamp today = new Timestamp(System.currentTimeMillis());
        if (!this.isSOTrx()) {
            if (grossWeight.equals(Env.ZERO)) {
                this.setGrossWeight(weightRegistered);
                this.setInDate(today);
                grossWeight = weightRegistered;
            } else {
                this.setTareWeight(weightRegistered);
                this.setOutDate(today);
                tareWeight = weightRegistered;
            }
            if (grossWeight.equals(Env.ZERO) && tareWeight.equals(Env.ZERO)) {
                this.setWeightStatus("G");
            } else if (grossWeight.equals(Env.ZERO)) {
                this.setWeightStatus("G");
            } else if (tareWeight.equals(Env.ZERO)) {
                this.setWeightStatus("T");
            } else {
                this.setWeightStatus("C");
            }
        } else {
            if (tareWeight.equals(Env.ZERO)) {
                this.setTareWeight(weightRegistered);
                this.setInDate(today);
                tareWeight = weightRegistered;
            } else {
                this.setGrossWeight(weightRegistered);
                this.setOutDate(today);
                grossWeight = weightRegistered;
            }
            if (grossWeight.equals(Env.ZERO) && tareWeight.equals(Env.ZERO)) {
                this.setWeightStatus("T");
            } else if (tareWeight.equals(Env.ZERO)) {
                this.setWeightStatus("T");
            } else if (grossWeight.equals(Env.ZERO)) {
                this.setWeightStatus("G");
            } else {
                this.setWeightStatus("C");
            }
        }
        this.setNetWeight(grossWeight.subtract(tareWeight));
        return true;
    }

    private void setFreightValues() {
        if (this.getDD_Freight_ID() > 0) {
            MDDFreight freight = (MDDFreight)this.getDD_Freight();
            if (freight.getDD_Driver_ID() > 0) {
                this.setDD_Driver_ID(freight.getDD_Driver_ID());
            }
            if (freight.getDD_Vehicle_ID() > 0) {
                this.setDD_Vehicle_ID(freight.getDD_Vehicle_ID());
            }
            if (freight.getM_Shipper_ID() > 0) {
                this.setM_Shipper_ID(freight.getM_Shipper_ID());
            }
        }
    }

    private void setDefiniteDocumentNo() {
        MDocType dt = MDocType.get((Properties)this.getCtx(), (int)this.getC_DocType_ID());
        if (dt.isOverwriteDateOnComplete()) {
            this.setDateDoc(new Timestamp(System.currentTimeMillis()));
        }
        if (dt.isOverwriteSeqOnComplete()) {
            String value = null;
            int index = this.p_info.getColumnIndex("C_DocType_ID");
            if (index == -1) {
                index = this.p_info.getColumnIndex("C_DocTypeTarget_ID");
            }
            if (index != -1) {
                value = DB.getDocumentNo((int)this.get_ValueAsInt(index), (String)this.get_TrxName(), (boolean)true);
            }
            if (value != null) {
                this.setDocumentNo(value);
            }
        }
    }

    public int customizeValidActions(String docStatus, Object processing, String orderType, String isSOTrx, int AD_Table_ID, String[] docAction, String[] options, int index) {
        if (AD_Table_ID == Table_ID) {
            if (docStatus.equals("DR") || docStatus.equals("IP") || docStatus.equals("IN")) {
                options[index++] = "PR";
            } else if (docStatus.equals("CO")) {
                options[index++] = "VO";
                options[index++] = "RE";
                options[index++] = "CL";
            } else if (docStatus.equals("CL")) {
                options[index++] = "--";
            }
        }
        return index;
    }

    public boolean voidIt() {
        this.log.info("voidIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 2);
        if (this.m_processMsg != null) {
            return false;
        }
        this.addDescription(Msg.getMsg((Properties)this.getCtx(), (String)"Voided"));
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 10);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        return true;
    }

    public void addDescription(String description) {
        String desc = this.getDescription();
        if (desc == null) {
            this.setDescription(description);
        } else {
            this.setDescription(desc + " | " + description);
        }
    }

    public boolean closeIt() {
        this.log.info("closeIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 3);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 11);
        return this.m_processMsg == null;
    }

    public boolean reverseCorrectIt() {
        this.log.info("reverseCorrectIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 5);
        if (this.m_processMsg != null) {
            return false;
        }
        this.voidIt();
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 13);
        if (this.m_processMsg != null) {
            return false;
        }
        return false;
    }

    public boolean reverseAccrualIt() {
        this.log.info("reverseAccrualIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 6);
        if (this.m_processMsg != null) {
            return false;
        }
        this.voidIt();
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 14);
        if (this.m_processMsg != null) {
            return false;
        }
        return false;
    }

    public BigDecimal getConvertedWeight(int productId) {
        MProduct product = MProduct.get((Properties)this.getCtx(), (int)productId);
        BigDecimal rate = MUOMConversion.getProductRateFrom((Properties)Env.getCtx(), (int)productId, (int)this.getC_UOM_ID());
        if (rate == null || rate.equals(Env.ZERO)) {
            throw new AdempiereException("@NoUOMConversion@ @M_Product_ID@: " + product.getValue() + " - " + product.get_Translation("Name"));
        }
        return this.getNetWeight().multiply(rate);
    }

    public boolean reActivateIt() {
        this.log.info("reActivateIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 4);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 12);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setDocAction("CO");
        this.setProcessed(false);
        return true;
    }

    public String getSummary() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getDocumentNo());
        if (this.getDescription() != null && this.getDescription().length() > 0) {
            sb.append(" - ").append(this.getDescription());
        }
        return sb.toString();
    }

    public String getProcessMsg() {
        return this.m_processMsg;
    }

    public int getDoc_User_ID() {
        return 0;
    }

    public BigDecimal getApprovalAmt() {
        return null;
    }

    public int getC_Currency_ID() {
        return 0;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MDDRecordWeight[").append(this.getSummary()).append("]");
        return sb.toString();
    }
}

