/*
 * Decompiled with CFR 0.152.
 */
package org.spin.store.mlv.support;

import java.io.File;
import java.io.FileOutputStream;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.adempiere.exceptions.AdempiereException;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.entity.mime.ContentBody;
import org.apache.hc.client5.http.entity.mime.FileBody;
import org.apache.hc.client5.http.entity.mime.MultipartEntityBuilder;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.compiere.util.CLogger;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;
import org.compiere.util.Util;
import org.json.JSONArray;
import org.json.JSONObject;
import org.spin.model.MADAttachmentReference;
import org.spin.queue.store.event.ECommerceEvent;
import org.spin.queue.store.event.ECommerceEventListener;
import org.spin.queue.store.support.IECommerce;
import org.spin.queue.store.support.IECommerceEntity;
import org.spin.queue.store.util.FindCondition;
import org.spin.queue.store.util.FindCriteria;
import org.spin.queue.store.util.IECommerceImporter;
import org.spin.store.ml.util.IMercadoLibre;
import org.spin.store.ml.util.IMercadoLibreImage;
import org.spin.store.ml.util.IMercadoLibreImageVariations;
import org.spin.store.ml.util.IMercadoLibreService;
import org.spin.store.mlv.support.ProductImageVariation;
import org.spin.util.AttachmentUtil;

public class ProductImage
implements IECommerceEntity,
IMercadoLibreImage,
IMercadoLibreService,
IECommerceImporter {
    Map<String, Object> map = new HashMap<String, Object>();
    private MADAttachmentReference attachmentReference;
    private static CLogger logger = CLogger.getCLogger(ProductImage.class);
    private IMercadoLibre api;
    private ECommerceEventListener listener;

    public static ProductImage newInstance() {
        return new ProductImage();
    }

    public ProductImage withAttachmentReference(MADAttachmentReference attachmentReference) {
        this.attachmentReference = attachmentReference;
        return this;
    }

    private ProductImage() {
    }

    public boolean isValid() {
        return this.attachmentReference != null;
    }

    public IECommerceEntity withWebStoreId(int webStoreId) {
        return this;
    }

    public String getIdentifier() {
        return this.getId();
    }

    public Object getValue(String key) {
        return this.map.get(key);
    }

    public void setValue(String key, Object value) {
        this.map.put(key, value);
    }

    public Map<String, Object> getAllValues() {
        return this.map;
    }

    public IECommerceEntity withApi(IECommerce api) {
        if (api != null && IMercadoLibre.class.isAssignableFrom(api.getClass())) {
            this.api = (IMercadoLibre)api;
        }
        return this;
    }

    public IECommerceEntity create() {
        try {
            if (Util.isEmpty((String)this.attachmentReference.get_ValueAsString("ECA37_MercadoLibreCode"))) {
                return this;
            }
            if (!AttachmentUtil.getInstance().isValidForClient(Env.getAD_Client_ID((Properties)Env.getCtx()))) {
                throw new AdempiereException("@Invalid@ @FileHandler_ID@");
            }
            byte[] fileAsBytes = AttachmentUtil.getInstance().withClientId(Env.getAD_Client_ID((Properties)Env.getCtx())).withAttachmentReferenceId(this.attachmentReference.getAD_AttachmentReference_ID()).getAttachment();
            if (fileAsBytes == null || fileAsBytes.length == 0) {
                throw new AdempiereException("@File@ @NotFound@");
            }
            if (this.attachmentReference.getValidFileName().lastIndexOf(".") < 0) {
                throw new AdempiereException("@Invalida@ @FileName@");
            }
            String extension = this.attachmentReference.getValidFileName().substring(this.attachmentReference.getValidFileName().lastIndexOf("."));
            File tempFile = File.createTempFile(this.attachmentReference.getValidFileName(), extension);
            try (FileOutputStream stream = new FileOutputStream(tempFile.getAbsolutePath());){
                stream.write(fileAsBytes);
            }
            CloseableHttpClient httpclient = HttpClients.createDefault();
            HttpPost httppost = new HttpPost(this.api.getHost() + "/pictures/items/upload");
            httppost.setHeader("Authorization", (Object)("Bearer " + this.api.getToken()));
            FileBody image = new FileBody(tempFile);
            HttpEntity reqEntity = MultipartEntityBuilder.create().addPart("file", (ContentBody)image).build();
            httppost.setEntity(reqEntity);
            CloseableHttpResponse response = httpclient.execute((ClassicHttpRequest)httppost);
            if (response.getCode() == 201) {
                HttpEntity resEntity = response.getEntity();
                if (resEntity != null) {
                    String output = EntityUtils.toString((HttpEntity)resEntity);
                    Optional.ofNullable(output).ifPresent(value -> {
                        JSONObject result = new JSONObject(value);
                        this.fill(result);
                        this.attachmentReference.set_ValueOfColumn("ECA37_MercadoLibreCode", (Object)this.getId());
                        this.attachmentReference.saveEx();
                    });
                }
                EntityUtils.consume((HttpEntity)resEntity);
            } else if (response.getCode() == 401) {
                this.api.requestNewToken();
                logger.severe("Failed : HTTP error code : " + response.getCode());
            } else {
                logger.severe("Failed : HTTP error code : " + response.getCode());
            }
        }
        catch (Exception e) {
            logger.severe(e.getLocalizedMessage());
        }
        return this;
    }

    public IECommerceEntity update() {
        if (!Util.isEmpty((String)this.attachmentReference.get_ValueAsString("ECA37_MercadoLibreCode"))) {
            return this;
        }
        return this.create();
    }

    public IECommerceEntity delete() {
        throw new AdempiereException("Could not delete for this entity");
    }

    public IECommerceEntity find(FindCriteria criteria) {
        try {
            Optional<FindCondition> maybeCondition;
            String id = this.getId();
            if (Util.isEmpty((String)id) && criteria != null && (maybeCondition = criteria.getConditions().stream().filter(condition -> condition.getKey().equals("id")).findFirst()).isPresent() && maybeCondition.get().getOperator() == FindCondition.OPERATORS.EQUAL) {
                id = String.valueOf(maybeCondition.get().getValue());
            }
            if (Util.isEmpty((String)id)) {
                throw new AdempiereException("Criteria is missing");
            }
            Invocation.Builder invocationBuilder = this.getTargetForGet(id).request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + this.api.getToken()));
            Response response = invocationBuilder.get();
            if (response.getStatus() == 200) {
                String output = (String)response.readEntity(String.class);
                Optional.ofNullable(output).ifPresent(value -> {
                    JSONObject result = new JSONObject(value);
                    this.fill(result);
                    if (this.listener != null) {
                        this.listener.onReceived(new ECommerceEvent((IECommerceEntity)this));
                    }
                });
            } else if (response.getStatus() == 401) {
                this.api.requestNewToken();
                logger.severe("Failed : HTTP error code : " + response.getStatus());
            } else {
                logger.severe("Failed : HTTP error code : " + response.getStatus());
            }
        }
        catch (Exception e) {
            logger.severe(e.getLocalizedMessage());
        }
        return null;
    }

    @Override
    public WebTarget getTargetForCreate() {
        AtomicReference target = new AtomicReference();
        Optional.ofNullable(this.api.getClient()).ifPresent(client -> target.set(client.target(this.api.getHost()).path("pictures").path("items").path("upload")));
        return (WebTarget)target.get();
    }

    @Override
    public WebTarget getTargetForGet(String id) {
        AtomicReference target = new AtomicReference();
        Optional.ofNullable(this.api.getClient()).ifPresent(client -> target.set(client.target(this.api.getHost()).path("categories").path(id)));
        return (WebTarget)target.get();
    }

    @Override
    public WebTarget getTargetForGet() {
        AtomicReference target = new AtomicReference();
        Optional.ofNullable(this.api.getClient()).ifPresent(client -> target.set(client.target(this.api.getHost()).path("sites").path(this.api.getSite()).path("categories")));
        return (WebTarget)target.get();
    }

    @Override
    public String getId() {
        return (String)this.getValue("id");
    }

    @Override
    public String getMaxSize() {
        return (String)this.getValue("max_size");
    }

    @Override
    public List<IMercadoLibreImageVariations> getVariations() {
        return (List)this.getValue("variations");
    }

    @Override
    public String getStatus() {
        return (String)this.getValue("status");
    }

    private ProductImage fill(JSONObject result) {
        JSONArray children;
        this.setValue("id", result.get("id"));
        if (!result.isNull("max_size")) {
            this.setValue("max_size", result.get("max_size"));
        }
        if (!result.isNull("status")) {
            this.setValue("status", result.get("status"));
        }
        if (!result.isNull("variations") && !(children = result.getJSONArray("variations")).isEmpty()) {
            ArrayList<ProductImageVariation> variations = new ArrayList<ProductImageVariation>();
            for (int index = 0; index < children.length(); ++index) {
                variations.add(ProductImageVariation.newInstance().fill(children.getJSONObject(index)));
            }
            this.setValue("variations", variations);
        }
        return this;
    }

    public IECommerceEntity withListener(ECommerceEventListener listener) {
        this.listener = listener;
        return this;
    }

    public String importBatch(Properties context, String transactionName) {
        long startTime = System.currentTimeMillis();
        AtomicInteger errors = new AtomicInteger();
        AtomicInteger readed = new AtomicInteger();
        long endTime = System.currentTimeMillis();
        SimpleDateFormat format = DisplayType.getDateFormat((int)16);
        String message = Msg.parseTranslation((Properties)Env.getCtx(), (String)("@W_Categoty_ID@: @Records@: " + readed.get() + " @Errors@: " + errors.get() + " @StartTime@: " + format.format(new Timestamp(startTime)) + " @EndTime@: " + format.format(new Timestamp(startTime)) + " @Duration@" + TimeUtil.formatElapsed((long)(startTime - endTime))));
        return message;
    }

    @Override
    public WebTarget getTargetForUpdate(String id) {
        return null;
    }
}

