/*
 * Decompiled with CFR 0.152.
 */
package org.spin.store.mlv.support;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MProduct;
import org.compiere.util.CLogger;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;
import org.compiere.util.Util;
import org.json.JSONObject;
import org.spin.queue.store.event.ECommerceEvent;
import org.spin.queue.store.event.ECommerceEventListener;
import org.spin.queue.store.support.IECommerce;
import org.spin.queue.store.support.IECommerceEntity;
import org.spin.queue.store.util.FindCondition;
import org.spin.queue.store.util.FindCriteria;
import org.spin.queue.store.util.IECommerceImporter;
import org.spin.store.ml.util.IMercadoLibre;
import org.spin.store.ml.util.IMercadoLibreProduct;
import org.spin.store.ml.util.IMercadoLibreService;

public class ProductDescription
implements IECommerceEntity,
IMercadoLibreProduct,
IMercadoLibreService,
IECommerceImporter {
    Map<String, Object> map = new HashMap<String, Object>();
    private MProduct product;
    private int webStoreId;
    private static CLogger logger = CLogger.getCLogger(ProductDescription.class);
    private IMercadoLibre api;
    private ECommerceEventListener listener;

    public static ProductDescription newInstance() {
        return new ProductDescription();
    }

    public ProductDescription withProduct(MProduct product) {
        this.product = product;
        return this;
    }

    private ProductDescription() {
    }

    public boolean isValid() {
        return this.product != null;
    }

    public IECommerceEntity withWebStoreId(int webStoreId) {
        this.webStoreId = webStoreId;
        return this;
    }

    public String getIdentifier() {
        return this.getId();
    }

    public Object getValue(String key) {
        return this.map.get(key);
    }

    public void setValue(String key, Object value) {
        this.map.put(key, value);
    }

    public Map<String, Object> getAllValues() {
        return this.map;
    }

    public IECommerceEntity withApi(IECommerce api) {
        if (api != null && IMercadoLibre.class.isAssignableFrom(api.getClass())) {
            this.api = (IMercadoLibre)api;
        }
        return this;
    }

    private Map<String, Object> getUpdateDescriptionData() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("plain_text", this.product.getHelp());
        data.put("text", this.product.getDocumentNote());
        return data;
    }

    public IECommerceEntity create() {
        return this.update();
    }

    public IECommerceEntity update() {
        if (this.webStoreId <= 0) {
            throw new AdempiereException("@W_Store_ID@ @IsMandatory@");
        }
        if (this.product == null) {
            throw new AdempiereException("@M_Product_ID@ @NotFound@");
        }
        try {
            this.updateDescriptionData();
        }
        catch (Exception e) {
            logger.severe(e.getLocalizedMessage());
            throw new AdempiereException((Throwable)e);
        }
        return this;
    }

    private void updateDescriptionData() {
        JSONObject jsonValue;
        Entity entity;
        Map<String, Object> data = this.getUpdateDescriptionData();
        if (data.size() == 0) {
            return;
        }
        Invocation.Builder invocationBuilder = this.getTargetForUpdate(this.product.get_ValueAsString("ECA37_MercadoLibreCode")).path("description").queryParam("api_version", new Object[]{2}).request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + this.api.getToken()));
        Response response = invocationBuilder.put(entity = Entity.json((Object)(jsonValue = new JSONObject(data)).toString()));
        if (response.getStatus() != 201 || response.getStatus() != 200) {
            String output = (String)response.readEntity(String.class);
            Optional.ofNullable(output).ifPresent(value -> {
                JSONObject result = new JSONObject(value);
                this.fill(result);
            });
        }
    }

    public IECommerceEntity delete() {
        return this;
    }

    public IECommerceEntity find(FindCriteria criteria) {
        try {
            Optional<FindCondition> maybeCondition;
            String id = this.getId();
            if (Util.isEmpty((String)id) && criteria != null && (maybeCondition = criteria.getConditions().stream().filter(condition -> condition.getKey().equals("id")).findFirst()).isPresent() && maybeCondition.get().getOperator() == FindCondition.OPERATORS.EQUAL) {
                id = String.valueOf(maybeCondition.get().getValue());
            }
            if (Util.isEmpty((String)id)) {
                throw new AdempiereException("Criteria is missing");
            }
            Invocation.Builder invocationBuilder = this.getTargetForGet(id).request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + this.api.getToken()));
            Response response = invocationBuilder.get();
            if (response.getStatus() != 200) {
                throw new AdempiereException(response.getStatusInfo().toString());
            }
            String output = (String)response.readEntity(String.class);
            Optional.ofNullable(output).ifPresent(value -> {
                JSONObject result = new JSONObject(value);
                this.fill(result);
                if (this.listener != null) {
                    this.listener.onReceived(new ECommerceEvent((IECommerceEntity)this));
                }
            });
        }
        catch (Exception e) {
            logger.severe(e.getLocalizedMessage());
            throw new AdempiereException((Throwable)e);
        }
        return null;
    }

    @Override
    public WebTarget getTargetForCreate() {
        AtomicReference target = new AtomicReference();
        Optional.ofNullable(this.api.getClient()).ifPresent(client -> target.set(client.target(this.api.getHost()).path("items")));
        return (WebTarget)target.get();
    }

    @Override
    public WebTarget getTargetForGet(String id) {
        AtomicReference target = new AtomicReference();
        Optional.ofNullable(this.api.getClient()).ifPresent(client -> target.set(client.target(this.api.getHost()).path("items").path(id)));
        return (WebTarget)target.get();
    }

    @Override
    public WebTarget getTargetForGet() {
        AtomicReference target = new AtomicReference();
        Optional.ofNullable(this.api.getClient()).ifPresent(client -> target.set(client.target(this.api.getHost()).path("users").path("items").path("search")));
        return (WebTarget)target.get();
    }

    public WebTarget getTargetForGetManyIds() {
        AtomicReference target = new AtomicReference();
        Optional.ofNullable(this.api.getClient()).ifPresent(client -> target.set(client.target(this.api.getHost()).path("items")));
        return (WebTarget)target.get();
    }

    public WebTarget getTargetForGetUserInformation() {
        AtomicReference target = new AtomicReference();
        Optional.ofNullable(this.api.getClient()).ifPresent(client -> target.set(client.target(this.api.getHost()).path("users").path("me")));
        return (WebTarget)target.get();
    }

    @Override
    public String getId() {
        return (String)this.getValue("id");
    }

    @Override
    public String getTitle() {
        return (String)this.getValue("title");
    }

    @Override
    public String getSubTitle() {
        return (String)this.getValue("subtitle");
    }

    @Override
    public String getPermalink() {
        return (String)this.getValue("permalink");
    }

    @Override
    public double getPrice() {
        return ((Integer)this.getValue("price")).intValue();
    }

    @Override
    public String getCategoryId() {
        return (String)this.getValue("category_id");
    }

    @Override
    public String getCurrencyId() {
        return (String)this.getValue("currency_id");
    }

    private ProductDescription fill(JSONObject result) {
        this.setValue("id", result.get("id"));
        this.setValue("plain_text", result.get("plain_text"));
        this.setValue("text", result.get("text"));
        return this;
    }

    public IECommerceEntity withListener(ECommerceEventListener listener) {
        this.listener = listener;
        return this;
    }

    public String importBatch(Properties context, String transactionName) {
        long startTime = System.currentTimeMillis();
        AtomicInteger errors = new AtomicInteger();
        AtomicInteger readed = new AtomicInteger();
        long endTime = System.currentTimeMillis();
        SimpleDateFormat format = DisplayType.getDateFormat((int)16);
        String message = Msg.parseTranslation((Properties)Env.getCtx(), (String)("@M_Product_ID@: @Records@: " + readed.get() + " @Errors@: " + errors.get() + " @StartTime@: " + format.format(new Timestamp(startTime)) + " @EndTime@: " + format.format(new Timestamp(startTime)) + " @Duration@" + TimeUtil.formatElapsed((long)(startTime - endTime))));
        return message;
    }

    @Override
    public WebTarget getTargetForUpdate(String id) {
        AtomicReference target = new AtomicReference();
        Optional.ofNullable(this.api.getClient()).ifPresent(client -> target.set(client.target(this.api.getHost()).path("items").path(id)));
        return (WebTarget)target.get();
    }
}

