/*
 * Decompiled with CFR 0.152.
 */
package org.spin.store.mlv.support;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.I_M_Product;
import org.compiere.model.MClientInfo;
import org.compiere.model.MCurrency;
import org.compiere.model.MPriceList;
import org.compiere.model.MProduct;
import org.compiere.model.MProductPricing;
import org.compiere.model.MStorage;
import org.compiere.model.MStore;
import org.compiere.model.MTable;
import org.compiere.model.MUOM;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.CLogger;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;
import org.compiere.util.Util;
import org.json.JSONArray;
import org.json.JSONObject;
import org.spin.model.MADAttachmentReference;
import org.spin.queue.store.event.ECommerceEvent;
import org.spin.queue.store.event.ECommerceEventListener;
import org.spin.queue.store.support.IECommerce;
import org.spin.queue.store.support.IECommerceEntity;
import org.spin.queue.store.util.FindCondition;
import org.spin.queue.store.util.FindCriteria;
import org.spin.queue.store.util.IECommerceImporter;
import org.spin.store.ml.util.IMercadoLibre;
import org.spin.store.ml.util.IMercadoLibreProduct;
import org.spin.store.ml.util.IMercadoLibreService;
import org.spin.store.mlv.support.ProductDescription;
import org.spin.store.mlv.support.ProductImage;
import org.spin.util.AttachmentUtil;

public class Product
implements IECommerceEntity,
IMercadoLibreProduct,
IMercadoLibreService,
IECommerceImporter {
    Map<String, Object> map = new HashMap<String, Object>();
    private MProduct product;
    private int webStoreId;
    private static CLogger logger = CLogger.getCLogger(Product.class);
    private IMercadoLibre api;
    private ECommerceEventListener listener;

    public static Product newInstance() {
        return new Product();
    }

    public Product withProduct(MProduct product) {
        this.product = product;
        return this;
    }

    private Product() {
    }

    public boolean isValid() {
        return this.product != null;
    }

    public IECommerceEntity withWebStoreId(int webStoreId) {
        this.webStoreId = webStoreId;
        return this;
    }

    public String getIdentifier() {
        return this.getId();
    }

    public Object getValue(String key) {
        return this.map.get(key);
    }

    public void setValue(String key, Object value) {
        this.map.put(key, value);
    }

    public Map<String, Object> getAllValues() {
        return this.map;
    }

    public IECommerceEntity withApi(IECommerce api) {
        if (api != null && IMercadoLibre.class.isAssignableFrom(api.getClass())) {
            this.api = (IMercadoLibre)api;
        }
        return this;
    }

    private Map<String, Object> getCreateData() {
        BigDecimal availableQuantity;
        String itemCondition;
        HashMap<String, Object> data = new HashMap<String, Object>();
        MStore store = MStore.get((Properties)Env.getCtx(), (int)this.webStoreId);
        MPriceList priceList = MPriceList.get((Properties)Env.getCtx(), (int)store.getM_PriceList_ID(), null);
        String currencyIsoCode = MCurrency.getISO_Code((Properties)Env.getCtx(), (int)priceList.getC_Currency_ID());
        String publishType = this.product.get_ValueAsString("ECA37_PublishType");
        String publishStatus = this.product.get_ValueAsString("ECA37_PublishStatus");
        BigDecimal price = this.getPrice(priceList);
        if (Util.isEmpty((String)publishStatus)) {
            throw new AdempiereException("@ECA37_PublishStatus@ @NotFound@");
        }
        if (!publishStatus.equals("active") && !publishStatus.equals("paused")) {
            return data;
        }
        if (Util.isEmpty((String)publishType)) {
            publishType = store.get_ValueAsString("ECA37_PublishType");
        }
        if (Util.isEmpty((String)publishType)) {
            publishType = "free";
        }
        if (Util.isEmpty((String)(itemCondition = this.product.get_ValueAsString("ECA37_ItemCondition")))) {
            itemCondition = "new";
        }
        if ((availableQuantity = this.getAvailableQuantity(store, publishType)).compareTo(Env.ZERO) == 0) {
            return data;
        }
        if (Optional.ofNullable(price).orElse(Env.ZERO).compareTo(Env.ZERO) <= 0) {
            return data;
        }
        data.put("title", this.product.getName());
        if (Util.isEmpty((String)this.product.getDescription())) {
            data.put("subtitle", this.product.getDescription());
        }
        data.put("category_id", this.getStoreCategoryId());
        data.put("price", price);
        data.put("currency_id", currencyIsoCode);
        data.put("available_quantity", availableQuantity);
        data.put("buying_mode", "buy_it_now");
        data.put("condition", itemCondition);
        data.put("listing_type_id", publishType);
        data.put("pictures", this.getProductPictures());
        data.put("attributes", this.getProductAttiburtes());
        return data;
    }

    private Map<String, Object> getUpdateData() {
        BigDecimal price;
        String itemCondition;
        BigDecimal availableQuantity;
        MStore store = MStore.get((Properties)Env.getCtx(), (int)this.webStoreId);
        MPriceList priceList = MPriceList.get((Properties)Env.getCtx(), (int)store.getM_PriceList_ID(), null);
        String currencyIsoCode = MCurrency.getISO_Code((Properties)Env.getCtx(), (int)priceList.getC_Currency_ID());
        String publishType = this.product.get_ValueAsString("ECA37_PublishType");
        String publishStatus = this.product.get_ValueAsString("ECA37_PublishStatus");
        if (Util.isEmpty((String)publishStatus)) {
            throw new AdempiereException("@ECA37_PublishStatus@ @NotFound@");
        }
        if (publishStatus.equals("not_published")) {
            publishStatus = "closed";
        }
        if (Util.isEmpty((String)publishType)) {
            publishType = store.get_ValueAsString("ECA37_PublishType");
        }
        if (Util.isEmpty((String)publishType)) {
            publishType = "free";
        }
        if ((availableQuantity = this.getAvailableQuantity(store, publishType)).compareTo(Env.ZERO) == 0 || !this.product.isWebStoreFeatured()) {
            publishStatus = "paused";
        }
        if (Util.isEmpty((String)(itemCondition = this.product.get_ValueAsString("ECA37_ItemCondition")))) {
            itemCondition = "new";
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        String storeCategoryId = this.getStoreCategoryId();
        if (this.isValueChanged("category_id", storeCategoryId)) {
            data.put("category_id", storeCategoryId);
        }
        if (this.isValueChanged("price", price = this.getPrice(priceList))) {
            data.put("price", price);
        }
        if (this.isValueChanged("currency_id", currencyIsoCode)) {
            data.put("currency_id", currencyIsoCode);
        }
        if (availableQuantity.compareTo(Env.ZERO) > 0 && this.isValueChanged("available_quantity", availableQuantity)) {
            data.put("available_quantity", availableQuantity);
        }
        if (this.isValueChanged("buying_mode", "buy_it_now")) {
            data.put("buying_mode", "buy_it_now");
        }
        if (this.isValueChanged("status", publishStatus)) {
            data.put("status", publishStatus);
        }
        if (this.isValueChanged("condition", itemCondition)) {
            data.put("condition", itemCondition);
        }
        if (this.isValueChanged("title", this.product.getName())) {
            data.put("title", this.product.getName());
        }
        data.put("pictures", this.getProductPictures());
        data.put("attributes", this.getProductAttiburtes());
        return data;
    }

    private boolean isValueChanged(String key, Object newValue) {
        Object currentValue = this.getValue(key);
        if (currentValue == null && newValue != null) {
            return true;
        }
        if (newValue == null && currentValue != null) {
            return true;
        }
        if (newValue == null && currentValue == null) {
            return false;
        }
        if (currentValue instanceof Integer) {
            return newValue != currentValue;
        }
        if (currentValue instanceof String) {
            return !((String)newValue).toLowerCase().equals(((String)currentValue).toLowerCase());
        }
        return !newValue.equals(currentValue);
    }

    private String getStoreCategoryId() {
        if (MTable.getTable_ID((String)"W_Category") <= 0) {
            throw new AdempiereException("@W_Category_ID@ @NotFound@");
        }
        PO category = new Query(Env.getCtx(), "W_Category", "ECA37_MercadoLibreCode IS NOT NULL AND EXISTS(SELECT 1 FROM W_CategoryAllocation ca WHERE ca.W_Category_ID = W_Category.W_Category_ID AND ca.M_Product_ID = ?)", null).setParameters(new Object[]{this.product.getM_Product_ID()}).setClient_ID().first();
        if (category == null) {
            throw new AdempiereException("@W_Category_ID@ @NotFound@");
        }
        return category.get_ValueAsString("ECA37_MercadoLibreCode");
    }

    private BigDecimal getPrice(MPriceList priceList) {
        Timestamp validFrom = TimeUtil.getDay((long)System.currentTimeMillis());
        MProductPricing productPricing = new MProductPricing(this.product.getM_Product_ID(), 0, Env.ZERO, true, null);
        productPricing.setM_PriceList_ID(priceList.getM_PriceList_ID());
        productPricing.setPriceDate(validFrom);
        return productPricing.getPriceStd().setScale(productPricing.getPrecision());
    }

    private BigDecimal getAvailableQuantity(MStore store, String publishType) {
        if (publishType.equals("free") || !this.product.isStocked()) {
            return Env.ONE;
        }
        return this.getStock(store);
    }

    private BigDecimal getStock(MStore store) {
        Optional<MStorage> maybeStorage = Arrays.asList(MStorage.getOfProduct((Properties)Env.getCtx(), (int)this.product.getM_Product_ID(), (String)this.product.get_TrxName())).stream().filter(storage -> storage.getM_Warehouse_ID() == store.getM_Warehouse_ID()).reduce(StockSummary::add);
        if (maybeStorage.isPresent()) {
            BigDecimal quantityOnHand = Optional.ofNullable(maybeStorage.get().getQtyOnHand()).orElse(Env.ZERO);
            BigDecimal quantityReserved = Optional.ofNullable(maybeStorage.get().getQtyReserved()).orElse(Env.ZERO);
            if (quantityReserved.signum() < 0) {
                return Env.ZERO;
            }
            return quantityOnHand.subtract(quantityReserved);
        }
        return Env.ZERO;
    }

    private List<Map<String, String>> getProductPictures() {
        ArrayList<Map<String, String>> data = new ArrayList<Map<String, String>>();
        String ID = "source";
        this.getProductAttachmentreferencesIds().stream().map(attachmentReferenceId -> MADAttachmentReference.getById((Properties)this.product.getCtx(), (int)attachmentReferenceId, null)).filter(attachmentReference -> !Util.isEmpty((String)attachmentReference.get_ValueAsString("ECA37_PictureSource"))).forEach(attachmentReference -> data.add(Collections.singletonMap("source", attachmentReference.get_ValueAsString("ECA37_PictureSource"))));
        if (data.size() == 0) {
            throw new AdempiereException("@AD_AttachmentReference_ID@ @NotFound@");
        }
        return data;
    }

    private List<Integer> getProductAttachmentreferencesIds() {
        if (!AttachmentUtil.getInstance().isValidForClient(Env.getAD_Client_ID((Properties)Env.getCtx()))) {
            throw new AdempiereException("@Invalid@ @FileHandler_ID@");
        }
        MClientInfo clientInfo = MClientInfo.get((Properties)this.product.getCtx());
        return new Query(this.product.getCtx(), "AD_AttachmentReference", "FileHandler_ID = ? AND EXISTS(SELECT 1 FROM AD_Attachment a WHERE a.AD_Attachment_ID = AD_AttachmentReference.AD_Attachment_ID AND a.AD_Table_ID = ? AND a.Record_ID = ?)", null).setParameters(new Object[]{clientInfo.getFileHandler_ID(), I_M_Product.Table_ID, this.product.getM_Product_ID()}).setClient_ID().getIDsAsList();
    }

    private List<Map<String, Object>> getProductAttiburtes() {
        HashMap<String, String> attribute;
        MClientInfo clientInfo;
        HashMap<String, String> attribute2;
        String ID = "id";
        String VALUE = "value_name";
        ArrayList<Map<String, Object>> data = new ArrayList<Map<String, Object>>();
        if (!Util.isEmpty((String)this.product.getUPC()) && this.product.getUPC().trim().matches("[+-]?\\d*(\\.\\d+)?")) {
            attribute2 = new HashMap();
            attribute2.put("id", "EAN");
            attribute2.put("value_name", this.product.getUPC().trim());
            data.add(attribute2);
        }
        if (!Util.isEmpty((String)this.product.getSKU())) {
            attribute2 = new HashMap<String, String>();
            attribute2.put("id", "SELLER_SKU");
            attribute2.put("value_name", this.product.getSKU());
            data.add(attribute2);
        }
        if (this.product.getM_Product_Class_ID() > 0) {
            attribute2 = new HashMap();
            attribute2.put("id", "BRAND");
            attribute2.put("value_name", this.product.getM_Product_Class().getName());
            data.add(attribute2);
        }
        if (Optional.ofNullable(this.product.getWeight()).orElse(Env.ZERO).compareTo(Env.ZERO) > 0 && (clientInfo = MClientInfo.get((Properties)Env.getCtx())).getC_UOM_Weight_ID() > 0) {
            MUOM weightUom = MUOM.get((Properties)Env.getCtx(), (int)clientInfo.getC_UOM_Weight_ID());
            String displayWeight = DisplayType.getNumberFormat((int)12).format(this.product.getWeight().setScale(weightUom.getStdPrecision())) + " " + weightUom.getX12DE355();
            attribute = new HashMap<String, String>();
            attribute.put("id", "PACKAGE_HEIGHT");
            attribute.put("value_name", displayWeight);
            data.add(attribute);
        }
        if (this.product.getShelfWidth() > 0 && (clientInfo = MClientInfo.get((Properties)Env.getCtx())).getC_UOM_Length_ID() > 0) {
            MUOM widthtUom = MUOM.get((Properties)Env.getCtx(), (int)clientInfo.getC_UOM_Length_ID());
            String displayWidth = DisplayType.getNumberFormat((int)12).format(this.product.getWeight().setScale(widthtUom.getStdPrecision())) + " " + widthtUom.getX12DE355();
            attribute = new HashMap();
            attribute.put("id", "PACKAGE_WIDTH");
            attribute.put("value_name", displayWidth);
            data.add(attribute);
        }
        return data;
    }

    public IECommerceEntity create() {
        if (this.webStoreId <= 0) {
            throw new AdempiereException("@W_Store_ID@ @IsMandatory@");
        }
        if (this.product == null) {
            throw new AdempiereException("@M_Product_ID@ @NotFound@");
        }
        if (!Util.isEmpty((String)this.product.get_ValueAsString("ECA37_MercadoLibreCode"))) {
            return this.update();
        }
        try {
            JSONObject jsonValue;
            Entity entity;
            this.publishImageData();
            Map<String, Object> createData = this.getCreateData();
            if (createData.size() == 0) {
                return this;
            }
            Invocation.Builder invocationBuilder = this.getTargetForCreate().request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + this.api.getToken()));
            Response response = invocationBuilder.post(entity = Entity.json((Object)(jsonValue = new JSONObject(createData)).toString()));
            if (response.getStatus() != 201) {
                String output = (String)response.readEntity(String.class);
                Optional.ofNullable(output).ifPresent(value -> {
                    JSONObject result = new JSONObject(value);
                    throw new AdempiereException(result.toString());
                });
                throw new Exception(response.getStatusInfo().toString());
            }
            String output = (String)response.readEntity(String.class);
            Optional.ofNullable(output).ifPresent(value -> {
                JSONObject result = new JSONObject(value);
                this.fill(result);
                this.product.set_ValueOfColumn("ECA37_MercadoLibreCode", (Object)this.getId());
                this.product.saveEx();
                this.updateDescriptionData();
                if (this.listener != null) {
                    this.listener.onReceived(new ECommerceEvent((IECommerceEntity)this));
                }
            });
        }
        catch (Exception e) {
            logger.severe(e.getLocalizedMessage());
            throw new AdempiereException((Throwable)e);
        }
        return this;
    }

    public IECommerceEntity update() {
        if (this.webStoreId <= 0) {
            throw new AdempiereException("@W_Store_ID@ @IsMandatory@");
        }
        if (this.product == null) {
            throw new AdempiereException("@M_Product_ID@ @NotFound@");
        }
        if (Util.isEmpty((String)this.product.get_ValueAsString("ECA37_MercadoLibreCode"))) {
            return this.create();
        }
        try {
            this.find(FindCriteria.newInstance().addCondition(FindCondition.newInstance().withKey("id").withOperator(FindCondition.OPERATORS.EQUAL).withValue((Object)this.product.get_ValueAsString("ECA37_MercadoLibreCode"))));
            this.updateDefaultData();
        }
        catch (Exception e) {
            logger.severe(e.getLocalizedMessage());
            throw new AdempiereException((Throwable)e);
        }
        return this;
    }

    private void updateDefaultData() {
        JSONObject jsonValue;
        Entity entity;
        Invocation.Builder invocationBuilder = this.getTargetForUpdate(this.product.get_ValueAsString("ECA37_MercadoLibreCode")).request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + this.api.getToken()));
        Response response = invocationBuilder.put(entity = Entity.json((Object)(jsonValue = new JSONObject(this.getUpdateData())).toString()));
        if (response.getStatus() != 201 || response.getStatus() != 200) {
            String output = (String)response.readEntity(String.class);
            Optional.ofNullable(output).ifPresent(value -> {
                JSONObject result = new JSONObject(value);
                this.fill(result);
                String status = (String)this.getValue("status");
                if (!Util.isEmpty((String)status) && status.equals("closed")) {
                    this.product.set_ValueOfColumn("ECA37_MercadoLibreCode", null);
                    this.product.saveEx();
                }
                this.updateDescriptionData();
                throw new AdempiereException(result.toString());
            });
            throw new AdempiereException(response.getStatusInfo().toString());
        }
    }

    private void updateDescriptionData() {
        ProductDescription.newInstance().withProduct(this.product).withApi(this.api).withWebStoreId(this.webStoreId).create();
    }

    private void publishImageData() {
        this.getProductAttachmentreferencesIds().stream().map(attachmentreferenceId -> MADAttachmentReference.getById((Properties)this.product.getCtx(), (int)attachmentreferenceId, null)).forEach(attachmentreference -> ProductImage.newInstance().withAttachmentReference((MADAttachmentReference)attachmentreference).withApi(this.api).withWebStoreId(this.webStoreId).create());
    }

    public IECommerceEntity delete() {
        return this;
    }

    public IECommerceEntity find(FindCriteria criteria) {
        try {
            Optional<FindCondition> maybeCondition;
            String id = this.getId();
            if (Util.isEmpty((String)id) && criteria != null && (maybeCondition = criteria.getConditions().stream().filter(condition -> condition.getKey().equals("id")).findFirst()).isPresent() && maybeCondition.get().getOperator() == FindCondition.OPERATORS.EQUAL) {
                id = String.valueOf(maybeCondition.get().getValue());
            }
            if (Util.isEmpty((String)id)) {
                throw new AdempiereException("Criteria is missing");
            }
            Invocation.Builder invocationBuilder = this.getTargetForGet(id).request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + this.api.getToken()));
            Response response = invocationBuilder.get();
            if (response.getStatus() != 200) {
                throw new AdempiereException(response.getStatusInfo().toString());
            }
            String output = (String)response.readEntity(String.class);
            Optional.ofNullable(output).ifPresent(value -> {
                JSONObject result = new JSONObject(value);
                this.fill(result);
                if (this.listener != null) {
                    this.listener.onReceived(new ECommerceEvent((IECommerceEntity)this));
                }
            });
        }
        catch (Exception e) {
            logger.severe(e.getLocalizedMessage());
            throw new AdempiereException((Throwable)e);
        }
        return null;
    }

    @Override
    public WebTarget getTargetForCreate() {
        AtomicReference target = new AtomicReference();
        Optional.ofNullable(this.api.getClient()).ifPresent(client -> target.set(client.target(this.api.getHost()).path("items")));
        return (WebTarget)target.get();
    }

    @Override
    public WebTarget getTargetForGet(String id) {
        AtomicReference target = new AtomicReference();
        Optional.ofNullable(this.api.getClient()).ifPresent(client -> target.set(client.target(this.api.getHost()).path("items").path(id)));
        return (WebTarget)target.get();
    }

    @Override
    public WebTarget getTargetForGet() {
        AtomicReference target = new AtomicReference();
        Optional.ofNullable(this.api.getClient()).ifPresent(client -> target.set(client.target(this.api.getHost()).path("users").path(String.valueOf(this.getUserId())).path("items").path("search")));
        return (WebTarget)target.get();
    }

    public WebTarget getTargetForGetManyIds() {
        AtomicReference target = new AtomicReference();
        Optional.ofNullable(this.api.getClient()).ifPresent(client -> target.set(client.target(this.api.getHost()).path("items")));
        return (WebTarget)target.get();
    }

    public WebTarget getTargetForGetUserInformation() {
        AtomicReference target = new AtomicReference();
        Optional.ofNullable(this.api.getClient()).ifPresent(client -> target.set(client.target(this.api.getHost()).path("users").path("me")));
        return (WebTarget)target.get();
    }

    @Override
    public String getId() {
        return (String)this.getValue("id");
    }

    @Override
    public String getTitle() {
        return (String)this.getValue("title");
    }

    @Override
    public String getSubTitle() {
        return (String)this.getValue("subtitle");
    }

    @Override
    public String getPermalink() {
        return (String)this.getValue("permalink");
    }

    @Override
    public double getPrice() {
        return ((Integer)this.getValue("price")).intValue();
    }

    @Override
    public String getCategoryId() {
        return (String)this.getValue("category_id");
    }

    @Override
    public String getCurrencyId() {
        return (String)this.getValue("currency_id");
    }

    private Product fill(JSONObject result) {
        this.setValue("id", result.get("id"));
        this.setValue("title", result.get("title"));
        this.setValidValue(result, "permalink");
        this.setValidValue(result, "price");
        this.setValidValue(result, "currency_id");
        this.setValidValue(result, "category_id");
        this.setValidValue(result, "subtitle");
        this.setValidValue(result, "seller_id");
        this.setValidValue(result, "category_id");
        this.setValidValue(result, "official_store_id");
        this.setValidValue(result, "price");
        this.setValidValue(result, "base_price");
        this.setValidValue(result, "original_price");
        this.setValidValue(result, "inventory_id");
        this.setValidValue(result, "currency_id");
        this.setValidValue(result, "initial_quantity");
        this.setValidValue(result, "available_quantity");
        this.setValidValue(result, "sold_quantity");
        this.setValidValue(result, "buying_mode");
        this.setValidValue(result, "listing_type_id");
        this.setValidValue(result, "start_time");
        this.setValidValue(result, "stop_time");
        this.setValidValue(result, "end_time");
        this.setValidValue(result, "expiration_time");
        this.setValidValue(result, "condition");
        this.setValidValue(result, "permalink");
        this.setValidValue(result, "thumbnail_id");
        this.setValidValue(result, "thumbnail");
        this.setValidValue(result, "secure_thumbnail");
        this.setValidValue(result, "video_id");
        this.setValidValue(result, "descriptions");
        this.setValidValue(result, "accepts_mercadopago");
        this.setValidValue(result, "international_delivery_mode");
        this.setValidValue(result, "seller_contact");
        this.setValidValue(result, "location");
        this.setValidValue(result, "warnings");
        this.setValidValue(result, "listing_source");
        this.setValidValue(result, "variations");
        this.setValidValue(result, "status");
        this.setValidValue(result, "sub_status");
        this.setValidValue(result, "warranty");
        this.setValidValue(result, "catalog_product_id");
        this.setValidValue(result, "seller_custom_field");
        this.setValidValue(result, "parent_item_id");
        this.setValidValue(result, "differential_pricing");
        this.setValidValue(result, "deal_ids");
        this.setValidValue(result, "automatic_relist");
        this.setValidValue(result, "date_created");
        this.setValidValue(result, "last_updated");
        this.setValidValue(result, "date_created");
        this.setValidValue(result, "date_created");
        this.setValidValue(result, "item_relations");
        this.setValidValue(result, "sale_terms");
        this.setValidValue(result, "pictures");
        this.setValidValue(result, "shipping");
        this.setValidValue(result, "seller_address");
        this.setValidValue(result, "coverage_areas");
        this.setValidValue(result, "attributes");
        this.setValidValue(result, "tags");
        this.setValidValue(result, "channels");
        return this;
    }

    private void setValidValue(JSONObject result, String key) {
        if (!result.isNull(key)) {
            if (key.equals("attributes")) {
                JSONArray attributes = result.getJSONArray(key);
                for (int index = 0; index < attributes.length(); ++index) {
                    JSONObject item = attributes.getJSONObject(index);
                    if (!"MODEL".equals(item.getString("id"))) continue;
                    this.setValue("model", item.getString("value_name"));
                }
            }
            this.setValue(key, result.get(key));
        }
    }

    public IECommerceEntity withListener(ECommerceEventListener listener) {
        this.listener = listener;
        return this;
    }

    private int getUserId() {
        AtomicInteger userId = new AtomicInteger(-1);
        try {
            Invocation.Builder invocationBuilder = this.getTargetForGetUserInformation().request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + this.api.getToken()));
            Response response = invocationBuilder.get();
            if (response.getStatus() == 200) {
                Optional.ofNullable((String)response.readEntity(String.class)).ifPresent(value -> {
                    JSONObject object = new JSONObject(value);
                    userId.set(object.getInt("id"));
                });
            } else if (response.getStatus() == 401) {
                this.api.requestNewToken();
                logger.severe("Failed : HTTP error code : " + response.getStatus());
            } else {
                logger.severe("Failed : HTTP error code : " + response.getStatus());
            }
        }
        catch (Exception e) {
            logger.severe(e.getLocalizedMessage());
        }
        return userId.get();
    }

    public String importBatch(Properties context, String transactionName) {
        long startTime = System.currentTimeMillis();
        AtomicInteger errors = new AtomicInteger();
        AtomicInteger readed = new AtomicInteger();
        try {
            Invocation.Builder invocationBuilder = this.getTargetForGet().request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + this.api.getToken()));
            Response response = invocationBuilder.get();
            if (response.getStatus() == 200) {
                Optional.ofNullable((String)response.readEntity(String.class)).ifPresent(value -> {
                    JSONObject object = new JSONObject(value);
                    Optional.ofNullable(object).ifPresent(result -> {
                        if (!result.isNull("results")) {
                            JSONArray items = result.getJSONArray("results");
                            StringBuffer ids = new StringBuffer("MLV704435446");
                            for (int index = 0; index < items.length(); ++index) {
                                if (ids.length() > 0) {
                                    ids.append(",");
                                }
                                ids.append(items.get(index));
                            }
                            Invocation.Builder builder = this.getTargetForGetManyIds().queryParam("ids", new Object[]{ids.toString()}).request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + this.api.getToken()));
                            Response responseQuery = builder.get();
                            if (response.getStatus() == 200) {
                                Optional.ofNullable((String)responseQuery.readEntity(String.class)).ifPresent(publishValue -> {
                                    JSONArray array = new JSONArray(publishValue);
                                    for (int index = 0; index < items.length(); ++index) {
                                        try {
                                            JSONObject item = array.getJSONObject(index);
                                            Product product = Product.newInstance().fill(item.getJSONObject("body"));
                                            product.withApi(this.api);
                                            product.save(context, transactionName);
                                            readed.addAndGet(1);
                                            continue;
                                        }
                                        catch (Exception e) {
                                            errors.addAndGet(1);
                                            logger.severe(e.getLocalizedMessage());
                                        }
                                    }
                                });
                            } else {
                                throw new AdempiereException(response.getStatusInfo().toString());
                            }
                        }
                    });
                });
            } else {
                errors.addAndGet(1);
                logger.severe("Failed : HTTP error code : " + response.getStatus());
            }
        }
        catch (Exception e) {
            errors.addAndGet(1);
            logger.severe(e.getLocalizedMessage());
        }
        long endTime = System.currentTimeMillis();
        SimpleDateFormat format = DisplayType.getDateFormat((int)16);
        String message = Msg.parseTranslation((Properties)Env.getCtx(), (String)("@M_Product_ID@: @Records@: " + readed.get() + " @Errors@: " + errors.get() + " @StartTime@: " + format.format(new Timestamp(startTime)) + " @EndTime@: " + format.format(new Timestamp(startTime)) + " @Duration@" + TimeUtil.formatElapsed((long)(startTime - endTime))));
        return message;
    }

    private Product save(Properties context, String transactionName) {
        if (Util.isEmpty((String)this.getId())) {
            return this;
        }
        ArrayList<Object> parameters = new ArrayList<Object>();
        StringBuffer whereClause = new StringBuffer("ECA37_MercadoLibreCode IS NULL");
        if (this.getValue("model") != null) {
            whereClause.append(" AND (Value = ? OR SKU = ?)");
            parameters.add(this.getValue("model"));
            parameters.add(this.getValue("model"));
        } else {
            whereClause.append(" AND UPPER(Name) = UPPER(?)");
            parameters.add(this.getTitle());
        }
        MProduct productToImport = (MProduct)new Query(context, "M_Product", whereClause.toString(), transactionName).setParameters(parameters).setClient_ID().first();
        if (productToImport == null) {
            return this;
        }
        productToImport.set_ValueOfColumn("ECA37_MercadoLibreCode", (Object)this.getId());
        productToImport.setName(this.getTitle());
        if (!Util.isEmpty((String)this.getSubTitle())) {
            productToImport.setDescription(this.getSubTitle());
        }
        productToImport.saveEx();
        return this;
    }

    @Override
    public WebTarget getTargetForUpdate(String id) {
        AtomicReference target = new AtomicReference();
        Optional.ofNullable(this.api.getClient()).ifPresent(client -> target.set(client.target(this.api.getHost()).path("items").path(id)));
        return (WebTarget)target.get();
    }

    private static final class StockSummary {
        private StockSummary() {
        }

        public static MStorage add(MStorage previousValue, MStorage newValue) {
            previousValue.setQtyOnHand(previousValue.getQtyOnHand().add(newValue.getQtyOnHand()));
            previousValue.setQtyReserved(previousValue.getQtyReserved().add(newValue.getQtyReserved()));
            return previousValue;
        }
    }
}

