/*
 * Decompiled with CFR 0.152.
 */
package org.spin.store.mlv.support;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MProduct;
import org.compiere.model.MProductPrice;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.glassfish.jersey.client.ClientConfig;
import org.json.JSONObject;
import org.spin.model.MADAppRegistration;
import org.spin.model.MADAttachmentReference;
import org.spin.model.MWCategory;
import org.spin.model.MWCategoryAllocation;
import org.spin.queue.store.support.IECommerceEntity;
import org.spin.queue.store.util.IECommerceImporter;
import org.spin.store.ml.util.IMercadoLibre;
import org.spin.store.mlv.support.Category;
import org.spin.store.mlv.support.Product;
import org.spin.store.mlv.support.ProductImage;

public class MercadoLibreApi
implements IMercadoLibre {
    private String host = "localhost";
    private int port = 80;
    private String token = null;
    private String siteId = null;
    public static final String DATE_FORMAT = "yyyy-MM-dd hh:mm:ss";
    private int registrationId = 0;
    private final String TOKEN = "token";
    private final String SITE_ID = "site_id";
    private final String CLIENT_SECRET = "client_secret";
    private final String CLIENT_ID = "client_id";
    private final String REDIRECT_URI = "redirect_uri";
    private final String REFRESH_TOKEN = "refresh_token";
    private final String SCOPE = "scope";
    private final String USER_ID = "user_id";
    private final String CODE = "code";

    public static String convertedDate(long millis) {
        return new SimpleDateFormat(DATE_FORMAT).format(millis);
    }

    private void validate() {
        if (this.getAppRegistrationId() <= 0) {
            throw new AdempiereException("@AD_AppRegistration_ID@ @NotFound@");
        }
        MADAppRegistration registration = MADAppRegistration.getById((Properties)Env.getCtx(), (int)this.getAppRegistrationId(), null);
        this.withHost(registration.getHost());
        this.withPort(registration.getPort());
        this.withToken(registration.getParameterValue("token"));
        this.withSiteId(registration.getParameterValue("site_id"));
        if (Util.isEmpty((String)this.getHost())) {
            throw new AdempiereException("@Host@ @NotFound@");
        }
        if (this.port <= 0) {
            throw new AdempiereException("@Port@ @NotFound@");
        }
    }

    public MercadoLibreApi connect() throws IOException {
        this.validate();
        return this;
    }

    public MercadoLibreApi close() throws IOException {
        return this;
    }

    @Override
    public final String getHost() {
        return this.host;
    }

    public final MercadoLibreApi withHost(String host) {
        this.host = host;
        return this;
    }

    public final int getPort() {
        return this.port;
    }

    public final MercadoLibreApi withPort(int port) {
        this.port = port;
        return this;
    }

    @Override
    public final String getToken() {
        return this.token;
    }

    public final MercadoLibreApi withToken(String token) {
        this.token = token;
        return this;
    }

    public final MercadoLibreApi withSiteId(String siteId) {
        this.siteId = siteId;
        return this;
    }

    @Override
    public Client getClient() {
        ClientConfig clientConfig = new ClientConfig();
        return ClientBuilder.newClient((Configuration)clientConfig);
    }

    public MercadoLibreApi create(IECommerceEntity entity) throws IOException {
        if (Optional.ofNullable(entity).isPresent() && entity.isValid()) {
            entity.create();
        }
        return this;
    }

    public MercadoLibreApi update(IECommerceEntity entity) throws IOException {
        if (Optional.ofNullable(entity).isPresent() && entity.isValid()) {
            entity.update();
            return this;
        }
        return this;
    }

    public MercadoLibreApi delete(IECommerceEntity entity) throws IOException {
        if (Optional.ofNullable(entity).isPresent() && entity.isValid() && this.exist(entity)) {
            entity.delete();
        }
        return this;
    }

    public boolean exist(IECommerceEntity entity) throws IOException {
        if (!Optional.ofNullable(entity).isPresent() || entity.isValid()) {
            // empty if block
        }
        return false;
    }

    public String testConnection() {
        this.requestNewToken();
        return "Ok";
    }

    public void setAppRegistrationId(int registrationId) {
        this.registrationId = registrationId;
        this.validate();
    }

    public int getAppRegistrationId() {
        return this.registrationId;
    }

    public int getApiId() {
        return this.getAppRegistrationId();
    }

    public IECommerceEntity getPersistenceWrapper(PO entity) {
        if (entity == null) {
            return null;
        }
        IECommerceImporter wrapper = null;
        if (entity.get_TableName().equals("W_Category")) {
            wrapper = Category.newInstance().withCategoy((MWCategory)entity);
        } else if (entity.get_TableName().equals("M_Product")) {
            wrapper = Product.newInstance().withProduct((MProduct)entity);
        } else if (entity.get_TableName().equals("AD_AttachmentReference")) {
            wrapper = ProductImage.newInstance().withAttachmentReference((MADAttachmentReference)entity);
        } else if (entity.get_TableName().equals("M_ProductPrice")) {
            MProductPrice productPrice = (MProductPrice)entity;
            wrapper = Product.newInstance().withProduct((MProduct)productPrice.getM_Product());
        } else if (entity.get_TableName().equals("W_CategoryAllocation")) {
            MWCategoryAllocation categoryAllocation = (MWCategoryAllocation)entity;
            MProduct product = (MProduct)categoryAllocation.getM_Product();
            wrapper = Product.newInstance().withProduct(product);
        }
        if (wrapper != null) {
            wrapper.withApi(this);
        }
        return wrapper;
    }

    @Override
    public String getSite() {
        return this.siteId;
    }

    @Override
    public void requestNewToken() {
        MADAppRegistration registration = new MADAppRegistration(Env.getCtx(), this.getAppRegistrationId(), null);
        String refreshToken = registration.getParameterValue("refresh_token");
        String clientId = registration.getParameterValue("client_id");
        String clientSecret = registration.getParameterValue("client_secret");
        if (Util.isEmpty((String)refreshToken)) {
            this.requestFirstToken(registration);
            registration = new MADAppRegistration(Env.getCtx(), this.getAppRegistrationId(), null);
            refreshToken = registration.getParameterValue("refresh_token");
        }
        if (Util.isEmpty((String)clientId)) {
            throw new AdempiereException("Client ID Not Found");
        }
        if (Util.isEmpty((String)clientSecret)) {
            throw new AdempiereException("Client Secret Not Found");
        }
        Invocation.Builder invocationBuilder = this.getTargetForRequestNewToken().request(new String[]{"application/json"}).header("Accept", (Object)"application/json").header("Content-Type", (Object)"application/x-www-form-urlencoded");
        MultivaluedHashMap formData = new MultivaluedHashMap();
        formData.add((Object)"grant_type", (Object)"refresh_token");
        formData.add((Object)"client_id", (Object)clientId);
        formData.add((Object)"client_secret", (Object)clientSecret);
        formData.add((Object)"refresh_token", (Object)refreshToken);
        Response response = invocationBuilder.post(Entity.form((MultivaluedMap)formData));
        String output = (String)response.readEntity(String.class);
        if (output != null) {
            JSONObject result = new JSONObject(output);
            this.withToken(result.getString("access_token"));
            int userId = result.getInt("user_id");
            String scope = result.getString("scope");
            String newRefreshToken = result.getString("refresh_token");
            new Query(Env.getCtx(), "AD_AppRegistration_Para", "AD_AppRegistration_ID = ?", null).setParameters(new Object[]{this.getAppRegistrationId()}).list().forEach(registrationParameter -> {
                if (registrationParameter.getParameterName().equals("token")) {
                    registrationParameter.setParameterValue(this.getToken());
                } else if (registrationParameter.getParameterName().equals("user_id")) {
                    registrationParameter.setParameterValue(String.valueOf(userId));
                } else if (registrationParameter.getParameterName().equals("scope")) {
                    registrationParameter.setParameterValue(scope);
                } else if (registrationParameter.getParameterName().equals("refresh_token")) {
                    registrationParameter.setParameterValue(newRefreshToken);
                }
                registrationParameter.saveEx();
            });
        }
    }

    private void requestFirstToken(MADAppRegistration registration) {
        String clientId = registration.getParameterValue("client_id");
        String clientSecret = registration.getParameterValue("client_secret");
        String redirectURL = registration.getParameterValue("redirect_uri");
        String code = registration.getParameterValue("code");
        if (Util.isEmpty((String)redirectURL)) {
            throw new AdempiereException("No Redirect URL");
        }
        if (Util.isEmpty((String)clientId)) {
            throw new AdempiereException("Client ID Not Found");
        }
        if (Util.isEmpty((String)clientSecret)) {
            throw new AdempiereException("Client Secret Not Found");
        }
        if (Util.isEmpty((String)code)) {
            throw new AdempiereException("Code Not Found");
        }
        Invocation.Builder invocationBuilder = this.getTargetForRequestNewToken().request(new String[]{"application/json"}).header("Accept", (Object)"application/json").header("Content-Type", (Object)"application/x-www-form-urlencoded");
        MultivaluedHashMap formData = new MultivaluedHashMap();
        formData.add((Object)"grant_type", (Object)"authorization_code");
        formData.add((Object)"client_id", (Object)clientId);
        formData.add((Object)"client_secret", (Object)clientSecret);
        formData.add((Object)"redirect_uri", (Object)redirectURL);
        formData.add((Object)"code", (Object)code);
        Response response = invocationBuilder.post(Entity.form((MultivaluedMap)formData));
        String output = (String)response.readEntity(String.class);
        if (output != null) {
            JSONObject result = new JSONObject(output);
            this.withToken(result.getString("access_token"));
            int userId = result.getInt("user_id");
            String scope = result.getString("scope");
            String newRefreshToken = result.getString("refresh_token");
            new Query(Env.getCtx(), "AD_AppRegistration_Para", "AD_AppRegistration_ID = ?", null).setParameters(new Object[]{this.getAppRegistrationId()}).list().forEach(registrationParameter -> {
                if (registrationParameter.getParameterName().equals("token")) {
                    registrationParameter.setParameterValue(this.getToken());
                } else if (registrationParameter.getParameterName().equals("user_id")) {
                    registrationParameter.setParameterValue(String.valueOf(userId));
                } else if (registrationParameter.getParameterName().equals("scope")) {
                    registrationParameter.setParameterValue(scope);
                } else if (registrationParameter.getParameterName().equals("refresh_token")) {
                    registrationParameter.setParameterValue(newRefreshToken);
                }
                registrationParameter.saveEx();
            });
        }
    }

    private WebTarget getTargetForRequestNewToken() {
        AtomicReference target = new AtomicReference();
        Optional.ofNullable(this.getClient()).ifPresent(client -> target.set(client.target(this.getHost()).path("oauth").path("token")));
        return (WebTarget)target.get();
    }

    public IECommerceImporter getImporter(String tableName) {
        IECommerceImporter importer = null;
        if (tableName == null) {
            return importer;
        }
        if (tableName.equals("W_Category")) {
            importer = Category.newInstance();
        } else if (tableName.equals("M_Product")) {
            importer = Product.newInstance();
        } else if (tableName.equals("AD_AttachmentReference")) {
            importer = ProductImage.newInstance();
        }
        return importer;
    }
}

