/*
 * Decompiled with CFR 0.152.
 */
package org.spin.store.mlv.support;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.Query;
import org.compiere.util.CLogger;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;
import org.compiere.util.Trx;
import org.compiere.util.Util;
import org.json.JSONArray;
import org.json.JSONObject;
import org.spin.model.MWCategory;
import org.spin.queue.store.event.ECommerceEvent;
import org.spin.queue.store.event.ECommerceEventListener;
import org.spin.queue.store.support.IECommerce;
import org.spin.queue.store.support.IECommerceEntity;
import org.spin.queue.store.util.FindCondition;
import org.spin.queue.store.util.FindCriteria;
import org.spin.queue.store.util.IECommerceImporter;
import org.spin.store.ml.util.IMercadoLibre;
import org.spin.store.ml.util.IMercadoLibreCategory;
import org.spin.store.ml.util.IMercadoLibreService;

public class Category
implements IECommerceEntity,
IMercadoLibreCategory,
IMercadoLibreService,
IECommerceImporter {
    Map<String, Object> map = new HashMap<String, Object>();
    private MWCategory category;
    private int webStoreId;
    private static CLogger logger = CLogger.getCLogger(Category.class);
    private IMercadoLibre api;
    private ECommerceEventListener listener;

    public static Category newInstance() {
        return new Category();
    }

    public Category withCategoy(MWCategory category) {
        this.category = category;
        return this;
    }

    private Category() {
    }

    public boolean isValid() {
        return this.category != null;
    }

    public IECommerceEntity withWebStoreId(int webStoreId) {
        this.webStoreId = webStoreId;
        return this;
    }

    public String getIdentifier() {
        return this.getId();
    }

    public Object getValue(String key) {
        return this.map.get(key);
    }

    public void setValue(String key, Object value) {
        this.map.put(key, value);
    }

    public Map<String, Object> getAllValues() {
        return this.map;
    }

    public IECommerceEntity withApi(IECommerce api) {
        if (api != null && IMercadoLibre.class.isAssignableFrom(api.getClass())) {
            this.api = (IMercadoLibre)api;
        }
        return this;
    }

    public IECommerceEntity create() {
        return this;
    }

    public IECommerceEntity update() {
        return this;
    }

    public IECommerceEntity delete() {
        return this;
    }

    public IECommerceEntity find(FindCriteria criteria) {
        try {
            Optional<FindCondition> maybeCondition;
            String id = this.getId();
            if (Util.isEmpty((String)id) && criteria != null && (maybeCondition = criteria.getConditions().stream().filter(condition -> condition.getKey().equals("id")).findFirst()).isPresent() && maybeCondition.get().getOperator() == FindCondition.OPERATORS.EQUAL) {
                id = String.valueOf(maybeCondition.get().getValue());
            }
            if (Util.isEmpty((String)id)) {
                throw new AdempiereException("Criteria is missing");
            }
            Invocation.Builder invocationBuilder = this.getTargetForGet(id).request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + this.api.getToken()));
            Response response = invocationBuilder.get();
            if (response.getStatus() == 200) {
                String output = (String)response.readEntity(String.class);
                Optional.ofNullable(output).ifPresent(value -> {
                    JSONObject result = new JSONObject(value);
                    this.fill(result);
                    if (this.listener != null) {
                        this.listener.onReceived(new ECommerceEvent((IECommerceEntity)this));
                    }
                });
            } else if (response.getStatus() == 401) {
                this.api.requestNewToken();
                logger.severe("Failed : HTTP error code : " + response.getStatus());
            } else {
                logger.severe("Failed : HTTP error code : " + response.getStatus());
            }
        }
        catch (Exception e) {
            logger.severe(e.getLocalizedMessage());
        }
        return null;
    }

    @Override
    public WebTarget getTargetForCreate() {
        throw new AdempiereException("Could not create for this entity");
    }

    @Override
    public WebTarget getTargetForGet(String id) {
        AtomicReference target = new AtomicReference();
        Optional.ofNullable(this.api.getClient()).ifPresent(client -> target.set(client.target(this.api.getHost()).path("categories").path(id)));
        return (WebTarget)target.get();
    }

    @Override
    public WebTarget getTargetForGet() {
        AtomicReference target = new AtomicReference();
        Optional.ofNullable(this.api.getClient()).ifPresent(client -> target.set(client.target(this.api.getHost()).path("sites").path(this.api.getSite()).path("categories")));
        return (WebTarget)target.get();
    }

    @Override
    public String getId() {
        return (String)this.getValue("id");
    }

    @Override
    public String getName() {
        return (String)this.getValue("name");
    }

    @Override
    public String getPermalink() {
        return (String)this.getValue("permalink");
    }

    @Override
    public int getTotalItemsInThisCategory() {
        return (Integer)this.getValue("total_items_in_this_category");
    }

    public String toString() {
        return "Category [map=" + this.map + ", category=" + this.category + ", webStoreId=" + this.webStoreId + ", api=" + this.api + "]";
    }

    @Override
    public List<IMercadoLibreCategory> getChildren() {
        return (List)this.getValue("children_categories");
    }

    private Category fill(JSONObject result) {
        JSONArray children;
        this.setValue("id", result.get("id"));
        this.setValue("name", result.get("name"));
        if (!result.isNull("permalink")) {
            this.setValue("permalink", result.get("permalink"));
        }
        if (!result.isNull("total_items_in_this_category")) {
            this.setValue("total_items_in_this_category", result.get("total_items_in_this_category"));
        }
        if (!result.isNull("children_categories") && !(children = result.getJSONArray("children_categories")).isEmpty()) {
            ArrayList<Category> categories = new ArrayList<Category>();
            for (int index = 0; index < children.length(); ++index) {
                categories.add(Category.newInstance().fill(children.getJSONObject(index)));
            }
            this.setValue("children_categories", categories);
        }
        return this;
    }

    private Category save(int parentId, Properties context, String transactionName) {
        if (Util.isEmpty((String)this.getId())) {
            return this;
        }
        MWCategory categoryToImport = (MWCategory)new Query(context, "W_Category", "ECA37_MercadoLibreCode = ?", transactionName).setParameters(new Object[]{this.getId()}).setClient_ID().first();
        if (categoryToImport == null) {
            categoryToImport = new MWCategory(context, 0, transactionName);
            categoryToImport.setAD_Org_ID(0);
            categoryToImport.setValue(this.getId());
            categoryToImport.setName(this.getName());
            categoryToImport.setDescription(this.getPermalink());
            categoryToImport.setIsDefault(false);
            categoryToImport.set_ValueOfColumn("ECA37_MercadoLibreCode", (Object)this.getId());
            categoryToImport.setIsWebStoreFeatured(parentId <= 0);
            if (parentId > 0) {
                categoryToImport.setW_Category_Parent_ID(parentId);
            }
            categoryToImport.saveEx();
            int categoryId = categoryToImport.getW_Category_ID();
            Optional.ofNullable(this.getChildren()).ifPresent(children -> children.forEach(child -> {
                try {
                    ((IECommerceEntity)child).withApi((IECommerce)this.api);
                    this.getCategoryFromId(child.getId()).save(categoryId, context, transactionName);
                }
                catch (Exception e) {
                    logger.severe(e.getLocalizedMessage());
                }
            }));
        }
        return this;
    }

    private Category getCategoryFromId(String id) {
        Category categoryWrapper = Category.newInstance();
        Invocation.Builder invocationBuilder = this.getTargetForGet(id).request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + this.api.getToken()));
        Response response = invocationBuilder.get();
        if (response.getStatus() == 200) {
            String output = (String)response.readEntity(String.class);
            Optional.ofNullable(output).ifPresent(value -> {
                JSONObject result = new JSONObject(value);
                categoryWrapper.fill(result);
            });
        } else if (response.getStatus() == 401) {
            this.api.requestNewToken();
            logger.severe("Failed : HTTP error code : " + response.getStatus());
        } else {
            logger.severe("Failed : HTTP error code : " + response.getStatus());
        }
        categoryWrapper.withApi(this.api);
        return categoryWrapper;
    }

    public IECommerceEntity withListener(ECommerceEventListener listener) {
        this.listener = listener;
        return this;
    }

    public String importBatch(Properties context, String transactionName) {
        long startTime = System.currentTimeMillis();
        AtomicInteger errors = new AtomicInteger();
        AtomicInteger readed = new AtomicInteger();
        try {
            Invocation.Builder invocationBuilder = this.getTargetForGet().request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + this.api.getToken()));
            Response response = invocationBuilder.get();
            if (response.getStatus() == 200) {
                Optional.ofNullable((String)response.readEntity(String.class)).ifPresent(value -> {
                    JSONArray array = new JSONArray(value);
                    Optional.ofNullable(array).ifPresent(items -> Trx.run(internalTransactionName -> {
                        for (int index = 0; index < items.length(); ++index) {
                            try {
                                this.getCategoryFromId(items.getJSONObject(index).getString("id")).save(0, context, internalTransactionName);
                                readed.addAndGet(1);
                                continue;
                            }
                            catch (Exception e) {
                                errors.addAndGet(1);
                                logger.severe(e.getLocalizedMessage());
                            }
                        }
                    }));
                });
            } else if (response.getStatus() == 401) {
                this.api.requestNewToken();
                logger.severe("Failed : HTTP error code : " + response.getStatus());
            } else {
                errors.addAndGet(1);
                logger.severe("Failed : HTTP error code : " + response.getStatus());
            }
        }
        catch (Exception e) {
            errors.addAndGet(1);
            logger.severe(e.getLocalizedMessage());
        }
        long endTime = System.currentTimeMillis();
        SimpleDateFormat format = DisplayType.getDateFormat((int)16);
        String message = Msg.parseTranslation((Properties)Env.getCtx(), (String)("@W_Categoty_ID@: @Records@: " + readed.get() + " @Errors@: " + errors.get() + " @StartTime@: " + format.format(new Timestamp(startTime)) + " @EndTime@: " + format.format(new Timestamp(startTime)) + " @Duration@" + TimeUtil.formatElapsed((long)(startTime - endTime))));
        return message;
    }

    @Override
    public WebTarget getTargetForUpdate(String id) {
        return null;
    }
}

