/*
 * Decompiled with CFR 0.152.
 */
package org.spin.store.mlv.setup;

import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.Query;
import org.spin.model.MADAppRegistration;
import org.spin.model.MADAppSupport;
import org.spin.store.mlv.support.MercadoLibreApi;
import org.spin.util.ISetupDefinition;

public class MercadoLibre
implements ISetupDefinition {
    private static final String APPLICATION_TYPE = "CSP";
    private static final String DESCRIPTION = "(*Created from Setup Automatically*)";
    private static final String UUID = "(*AutomaticSetup*)";
    private static final String NAME = "Mercado Libre Venezuela Default API";

    public String doIt(Properties context, String transactionName) {
        this.createRegistration(context, transactionName);
        return "@AD_SetupDefinition_ID@ @Ok@";
    }

    private void createRegistration(Properties context, String transactionName) {
        MADAppRegistration registration = (MADAppRegistration)new Query(context, "AD_AppRegistration", "EXISTS(SELECT 1 FROM AD_AppSupport s WHERE s.AD_AppSupport_ID = AD_AppRegistration.AD_AppSupport_ID AND s.ApplicationType = ?AND s.IsActive = 'Y'AND s.Classname = ?)", transactionName).setParameters(new Object[]{APPLICATION_TYPE, MercadoLibreApi.class.getName()}).setClient_ID().first();
        if (registration != null && registration.getAD_AppRegistration_ID() > 0) {
            return;
        }
        MADAppSupport applicationSupport = (MADAppSupport)new Query(context, "AD_AppSupport", "Classname = ? AND ApplicationType = ?", transactionName).setParameters(new Object[]{MercadoLibreApi.class.getName(), APPLICATION_TYPE}).first();
        if (applicationSupport == null) {
            throw new AdempiereException("@AD_AppSupport_ID@ @NotFound@");
        }
        registration = new MADAppRegistration(context, 0, transactionName);
        registration.setApplicationType(applicationSupport.getApplicationType());
        registration.setAD_AppSupport_ID(applicationSupport.getAD_AppSupport_ID());
        registration.setAD_Org_ID(0);
        registration.setValue("MLV-Default-API");
        registration.setName(NAME);
        registration.setDescription(DESCRIPTION);
        registration.setVersionNo("1.0");
        registration.setHost("https://api.mercadolibre.com");
        registration.setPort(80);
        registration.setTimeout(0);
        registration.saveEx();
        registration.setUUID(UUID);
        registration.setIsDirectLoad(true);
        registration.saveEx();
    }
}

