/*
 * Decompiled with CFR 0.152.
 */
package org.spin.store.mlv.model.validator;

import java.util.Properties;
import org.compiere.model.MClient;
import org.compiere.model.MDocType;
import org.compiere.model.MOrder;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;

public class Validator
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(Validator.class);
    private int clientId = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.clientId = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addDocValidate("C_Order", (ModelValidator)this);
        engine.addModelChange("C_OrderLine", (ModelValidator)this);
    }

    public int getAD_Client_ID() {
        return this.clientId;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public String modelChange(PO entity, int type) throws Exception {
        if (type != 1 && type != 2 || !entity.get_TableName().equals("C_OrderLine") || entity.is_new() || entity.is_ValueChanged("M_Product_ID")) {
            // empty if block
        }
        return null;
    }

    public String docValidate(PO entity, int timing) {
        if (timing == 7 && entity.get_TableName().equals("C_Order")) {
            MOrder order = (MOrder)entity;
            MDocType documentType = MDocType.get((Properties)entity.getCtx(), (int)order.getC_DocTypeTarget_ID());
            if (!order.isSOTrx() || order.isReturnOrder() || documentType.get_ValueAsBoolean("ColumAddedToCore")) {
                // empty if block
            }
        }
        return null;
    }
}

