/*
 * Decompiled with CFR 0.152.
 */
package org.spin.tools.kafka.util;

import java.time.Duration;
import java.util.Arrays;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.spin.tools.kafka.util.MapDeserializer;

public class KafkaTest {
    public static void main(String[] args) throws InterruptedException {
        while (true) {
            String host = "limon.hopto.me";
            String database = "tienda_100001";
            int port = 9092;
            int intents = 4;
            if (intents == 0) {
                intents = 100;
            }
            String completeUrl = host + ":" + port;
            Properties config = new Properties();
            config.put("client.id", "erp2");
            config.put("group.id", "foo01");
            config.put("bootstrap.servers", completeUrl);
            config.put("key.deserializer", "org.apache.kafka.common.serialization.StringDeserializer");
            config.put("value.deserializer", MapDeserializer.class.getName());
            KafkaConsumer consumer = new KafkaConsumer(config);
            consumer.subscribe(Arrays.asList(database));
            AtomicInteger iterate = new AtomicInteger(0);
            AtomicInteger errors = new AtomicInteger();
            while (iterate.incrementAndGet() < intents) {
                System.out.println("Intent: " + iterate.get());
                ConsumerRecords records = consumer.poll(Duration.ofSeconds(10L));
                records.forEach(record -> {
                    try {
                        System.out.println(record.value());
                    }
                    catch (Exception e) {
                        errors.addAndGet(1);
                    }
                });
                consumer.commitSync();
            }
            consumer.unsubscribe();
            consumer.close(Duration.ofSeconds(1L));
            System.out.println("Waiting......");
            Thread.sleep(10000L);
        }
    }
}

