/*
 * Decompiled with CFR 0.152.
 */
package org.spin.tools.kafka.util;

import java.net.InetAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.common.errors.TopicExistsException;
import org.spin.tools.kafka.util.MapSerializer;

public class KafkaLoader {
    private static KafkaLoader instance;
    private Map<String, KafkaProducer> producers = new HashMap<String, KafkaProducer>();

    public static KafkaLoader getInstance() {
        if (instance == null) {
            instance = new KafkaLoader();
        }
        return instance;
    }

    private void createTopic(String topic, Properties cloud) {
        block14: {
            NewTopic newTopic = new NewTopic(topic, Optional.empty(), Optional.empty());
            try (AdminClient adminClient = AdminClient.create((Properties)cloud);){
                adminClient.createTopics(Collections.singletonList(newTopic)).all().get();
            }
            catch (InterruptedException | ExecutionException e) {
                if (e.getCause() instanceof TopicExistsException) break block14;
                throw new RuntimeException(e);
            }
        }
    }

    public KafkaProducer getProducer(String url, String topic) throws Exception {
        String key = url + "|" + topic;
        KafkaProducer producer = this.producers.get(key);
        if (producer == null) {
            Properties config = new Properties();
            config.put("client.id", InetAddress.getLocalHost().getHostName());
            config.put("bootstrap.servers", url);
            config.put("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
            config.put("value.serializer", MapSerializer.class.getName());
            config.put("acks", "all");
            this.createTopic(topic, config);
            producer = new KafkaProducer(config);
            this.producers.put(key, producer);
        }
        return producer;
    }
}

