/*
 * Decompiled with CFR 0.152.
 */
package org.spin.cash.util;

import java.math.BigDecimal;
import java.util.Optional;
import org.compiere.util.Env;

public class PaymentSummaryWrapper {
    private int currencyId;
    private int conversionTypeId;
    private BigDecimal amount;

    public static PaymentSummaryWrapper newInstance() {
        return new PaymentSummaryWrapper();
    }

    public final BigDecimal getAmount() {
        return this.amount;
    }

    public final PaymentSummaryWrapper addAmount(BigDecimal amount) {
        this.amount = Optional.ofNullable(this.amount).orElse(Env.ZERO).add(Optional.ofNullable(amount).orElse(Env.ZERO));
        return this;
    }

    public final int getConversionTypeId() {
        return this.conversionTypeId;
    }

    public final PaymentSummaryWrapper withConversionTypeId(int conversionTypeId) {
        this.conversionTypeId = conversionTypeId;
        return this;
    }

    public final int getCurrencyId() {
        return this.currencyId;
    }

    public final PaymentSummaryWrapper withCurrencyId(int currencyId) {
        this.currencyId = currencyId;
        return this;
    }

    public String toString() {
        return "PaymentSummaryWrapper [currencyId=" + this.currencyId + ", conversionTypeId=" + this.conversionTypeId + ", amount=" + this.amount + "]";
    }
}

