/*
 * Decompiled with CFR 0.152.
 */
package org.spin.cash.util;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MBank;
import org.compiere.model.MBankAccount;
import org.compiere.model.MBankStatement;
import org.compiere.model.MBankStatementLine;
import org.compiere.model.MOrder;
import org.compiere.model.MPOS;
import org.compiere.model.MPayment;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfo;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;
import org.compiere.util.Util;
import org.eevolution.process.BankTransfer;
import org.eevolution.service.dsl.ProcessBuilder;
import org.spin.cash.model.MCBankAccountWithdrawal;
import org.spin.cash.util.PaymentSummaryWrapper;
import org.spin.cash.util.PaymentWrapper;

public class CashManagementUtil {
    public static final String COLUMNNAME_WithdrawalDocumentType_ID = "WithdrawalDocumentType_ID";
    public static final String COLUMNNAME_DepositBankAccount_ID = "DepositBankAccount_ID";
    public static final String COLUMNNAME_DepositCharge_ID = "DepositCharge_ID";
    public static final String COLUMNNAME_DepositDocumentType_ID = "DepositDocumentType_ID";
    public static final String COLUMNNAME_DepositTenderType = "DepositTenderType";
    public static final String COLUMNNAME_IsAutoReconciled = "IsAutoReconciled";
    public static final String COLUMNNAME_IsAutoDepositAfterClose = "IsAutoDepositAfterClose";
    public static final String COLUMNNAME_IsSplitDeposits = "IsSplitDeposits";
    public static final String COLUMNNAME_IsValidateCashOpening = "IsValidateCashOpening";
    public static final String MESSAGE_CashOpeningValidationError = "CashOpeningValidationError";

    public static void createWithdrawalFromBankStatement(MBankStatement bankStatement) {
        MBankAccount cashAccount = MBankAccount.get((Properties)bankStatement.getCtx(), (int)bankStatement.getC_BankAccount_ID());
        MBank cashJournal = MBank.get((Properties)bankStatement.getCtx(), (int)cashAccount.getC_Bank_ID());
        if (!cashAccount.get_ValueAsBoolean(COLUMNNAME_IsAutoDepositAfterClose)) {
            return;
        }
        if (Optional.ofNullable(cashJournal.getBankType()).orElse("B").equals("C")) {
            HashMap paymentsByMatchedCombination = new HashMap();
            CashManagementUtil.getColletsToDeposit(bankStatement).forEach(paymentWrapper -> {
                AtomicInteger matchedCombinationId = new AtomicInteger(0);
                Optional.ofNullable(MCBankAccountWithdrawal.findMatchFromPayment(bankStatement.getCtx(), paymentWrapper, bankStatement.get_TrxName())).ifPresent(matchedCombination -> matchedCombinationId.set(matchedCombination.getC_BankAccountWithdrawal_ID()));
                ArrayList<PaymentWrapper> payments = (ArrayList<PaymentWrapper>)paymentsByMatchedCombination.get(matchedCombinationId.get());
                if (payments == null) {
                    payments = new ArrayList<PaymentWrapper>();
                }
                payments.add((PaymentWrapper)paymentWrapper);
                paymentsByMatchedCombination.put(matchedCombinationId.get(), payments);
            });
            if (paymentsByMatchedCombination.size() > 0) {
                paymentsByMatchedCombination.keySet().forEach(combinationId -> {
                    AtomicInteger depositBankAccountId = new AtomicInteger(cashAccount.get_ValueAsInt(COLUMNNAME_DepositBankAccount_ID));
                    AtomicBoolean reconcilePayments = new AtomicBoolean(true);
                    AtomicBoolean splitDeposits = new AtomicBoolean(false);
                    AtomicReference<String> defaultTenderType = new AtomicReference<String>(cashAccount.get_ValueAsString(COLUMNNAME_DepositTenderType));
                    if (combinationId > 0) {
                        MCBankAccountWithdrawal withdrawalConfiguration = new MCBankAccountWithdrawal(bankStatement.getCtx(), (int)combinationId, bankStatement.get_TrxName());
                        if (withdrawalConfiguration.getDepositBankAccount_ID() > 0) {
                            depositBankAccountId.set(withdrawalConfiguration.getDepositBankAccount_ID());
                        }
                        reconcilePayments.set(withdrawalConfiguration.isAutoReconciled());
                        splitDeposits.set(withdrawalConfiguration.isSplitDeposits());
                        if (!Util.isEmpty((String)withdrawalConfiguration.getTenderType())) {
                            defaultTenderType.set(withdrawalConfiguration.getTenderType());
                        }
                    }
                    if (splitDeposits.get()) {
                        ((List)paymentsByMatchedCombination.get(combinationId)).forEach(paymentWrapper -> CashManagementUtil.createWithdrawal(cashAccount, bankStatement, depositBankAccountId.get(), paymentWrapper.getCurrencyId(), paymentWrapper.getConversionTypeId(), paymentWrapper.getAmount(), reconcilePayments.get(), paymentWrapper.getDocumentNo(), paymentWrapper.getTenderType(), paymentWrapper.getBusinessPartnerId()));
                    } else {
                        HashMap paymentToWithdrawal = new HashMap();
                        ((List)paymentsByMatchedCombination.get(combinationId)).forEach(paymentWrapper -> {
                            PaymentSummaryWrapper summary = (PaymentSummaryWrapper)paymentToWithdrawal.get(paymentWrapper.getCurrencyId() + "|" + paymentWrapper.getConversionTypeId());
                            if (summary == null) {
                                summary = PaymentSummaryWrapper.newInstance().withCurrencyId(paymentWrapper.getCurrencyId()).withConversionTypeId(paymentWrapper.getConversionTypeId());
                            }
                            summary.addAmount(paymentWrapper.getAmount());
                            paymentToWithdrawal.put(paymentWrapper.getCurrencyId() + "|" + paymentWrapper.getConversionTypeId(), summary);
                        });
                        if (paymentToWithdrawal.size() > 0) {
                            paymentToWithdrawal.values().forEach(summaryWrapper -> CashManagementUtil.createWithdrawal(cashAccount, bankStatement, depositBankAccountId.get(), summaryWrapper.getCurrencyId(), summaryWrapper.getConversionTypeId(), summaryWrapper.getAmount(), reconcilePayments.get(), bankStatement.getDocumentNo(), (String)defaultTenderType.get(), cashAccount.getC_BPartner_ID()));
                        }
                    }
                });
            }
            CashManagementUtil.calculateBankStatementBalance(bankStatement);
        }
    }

    private static void createWithdrawal(MBankAccount cashAccount, MBankStatement bankStatement, int depositBankAccountId, int currencyId, int conversionTypeId, BigDecimal amount, boolean isReconciled, String documentNo, String tenderType, int businessPartnerId) {
        ProcessInfo result = ProcessBuilder.create((Properties)bankStatement.getCtx()).process(Integer.valueOf(BankTransfer.getProcessId())).withoutTransactionClose().withParameter(COLUMNNAME_WithdrawalDocumentType_ID, (Object)cashAccount.get_ValueAsInt(COLUMNNAME_WithdrawalDocumentType_ID)).withParameter(COLUMNNAME_DepositDocumentType_ID, (Object)cashAccount.get_ValueAsInt(COLUMNNAME_DepositDocumentType_ID)).withParameter("StatementDate", (Object)bankStatement.getStatementDate()).withParameter("DateAcct", (Object)bankStatement.getStatementDate()).withParameter("C_BPartner_ID", (Object)businessPartnerId).withParameter("C_Charge_ID", (Object)cashAccount.get_ValueAsInt(COLUMNNAME_DepositCharge_ID)).withParameter("From_C_BankAccount_ID", (Object)bankStatement.getC_BankAccount_ID()).withParameter("C_BankAccountTo_ID", (Object)depositBankAccountId).withParameter("TenderType", (Object)tenderType).withParameter("DocumentNo", (Object)documentNo).withParameter("C_Currency_ID", (Object)currencyId).withParameter("C_ConversionType_ID", (Object)conversionTypeId).withParameter("Amount", (Object)amount).withParameter(COLUMNNAME_IsAutoReconciled, (Object)isReconciled).withParameter("Description", (Object)bankStatement.getDescription()).execute(bankStatement.get_TrxName());
        if (result.isError()) {
            throw new AdempiereException(result.getSummary());
        }
    }

    private static void calculateBankStatementBalance(MBankStatement bankStatement) {
        List<MBankStatementLine> lines = Arrays.asList(bankStatement.getLines(true));
        AtomicReference<BigDecimal> total = new AtomicReference<BigDecimal>(Env.ZERO);
        AtomicReference<Timestamp> minimumDate = new AtomicReference<Timestamp>(bankStatement.getStatementDate());
        AtomicReference<Timestamp> maximumDate = new AtomicReference<Timestamp>(bankStatement.getStatementDate());
        lines.forEach(statementLine -> {
            total.updateAndGet(totalAmount -> totalAmount.add(statementLine.getStmtAmt()));
            if (statementLine.getDateAcct().before((Timestamp)minimumDate.get())) {
                minimumDate.set(statementLine.getDateAcct());
            }
            if (statementLine.getDateAcct().after((Timestamp)maximumDate.get())) {
                maximumDate.set(statementLine.getDateAcct());
            }
        });
        bankStatement.setStatementDifference(total.get());
        bankStatement.setEndingBalance(bankStatement.getBeginningBalance().add(total.get()));
        bankStatement.saveEx();
    }

    public static void validateCashOpeningForPayment(MPayment payment) {
        int paymentId;
        if (payment.getC_POS_ID() <= 0) {
            return;
        }
        MBankAccount cashAccount = MBankAccount.get((Properties)payment.getCtx(), (int)payment.getC_BankAccount_ID());
        if (cashAccount.get_ValueAsBoolean(COLUMNNAME_IsValidateCashOpening) && (paymentId = new Query(payment.getCtx(), "C_Payment", "DocStatus IN('CO', 'CL') AND IsReceipt = 'Y' AND C_Charge_ID IS NOT NULL AND DateTrx = ? AND EXISTS(SELECT 1 FROM C_BankStatementLine bsl WHERE bsl.C_Payment_ID = C_Payment.C_Payment_ID AND bsl.Processed = 'N')", payment.get_TrxName()).setParameters(new Object[]{TimeUtil.getDay((long)System.currentTimeMillis())}).firstId()) <= 0) {
            throw new AdempiereException(Msg.parseTranslation((Properties)payment.getCtx(), (String)"@CashOpeningValidationError@"));
        }
    }

    public static void validateCashOpeningForOrder(MOrder order) {
        int paymentId;
        if (order.getC_POS_ID() <= 0) {
            return;
        }
        MPOS pointOfSales = MPOS.get((Properties)order.getCtx(), (int)order.getC_POS_ID());
        MBankAccount cashAccount = MBankAccount.get((Properties)order.getCtx(), (int)pointOfSales.getC_BankAccount_ID());
        if (cashAccount.get_ValueAsBoolean(COLUMNNAME_IsValidateCashOpening) && (paymentId = new Query(order.getCtx(), "C_Payment", "DocStatus IN('CO', 'CL') AND IsReceipt = 'Y' AND C_Charge_ID IS NOT NULL AND C_POS_ID = ? AND DateTrx = ? AND EXISTS(SELECT 1 FROM C_BankStatementLine bsl WHERE bsl.C_Payment_ID = C_Payment.C_Payment_ID AND bsl.Processed = 'N')", order.get_TrxName()).setParameters(new Object[]{order.getC_POS_ID(), TimeUtil.getDay((long)System.currentTimeMillis())}).firstId()) <= 0) {
            throw new AdempiereException(Msg.parseTranslation((Properties)order.getCtx(), (String)"@CashOpeningValidationError@"));
        }
    }

    private static List<PaymentWrapper> getColletsToDeposit(MBankStatement bankStatement) {
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<PaymentWrapper> wrapperList = new ArrayList<PaymentWrapper>();
        try {
            String sql = "SELECT p.C_Payment_ID, p.DocumentNo, p.C_DocType_ID, p.C_BPartner_ID, p.C_Bank_ID, p.C_BankAccount_ID, p.TenderType, p.C_Currency_ID, p.C_ConversionType_ID, (p.PayAmt * CASE WHEN p.IsReceipt = 'Y' THEN 1 ELSE -1 END) AS PaymentAmount FROM C_Payment p WHERE p.DocStatus IN('CO', 'CL') AND EXISTS(SELECT 1 FROM C_BankStatementLine bsl WHERE bsl.C_Payment_ID = p.C_Payment_ID AND bsl.C_BankStatement_ID = ?)";
            pstmt = DB.prepareStatement((String)sql, (String)bankStatement.get_TrxName());
            pstmt.setInt(1, bankStatement.getC_BankStatement_ID());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                wrapperList.add(PaymentWrapper.newInstance().withPaymentId(rs.getInt("C_Payment_ID")).withDocumentNo(rs.getString("DocumentNo")).withDocumentTypeId(rs.getInt("C_DocType_ID")).withBusinessPartnerId(rs.getInt("C_BPartner_ID")).withBankId(rs.getInt("C_Bank_ID")).withBankAccountId(rs.getInt("C_BankAccount_ID")).withTenderType(rs.getString("TenderType")).withCurrencyId(rs.getInt("C_Currency_ID")).withConversionTypeId(rs.getInt("C_ConversionType_ID")).withAmount(rs.getBigDecimal("PaymentAmount")));
            }
        }
        catch (Exception e) {
            try {
                throw new AdempiereException((Throwable)e);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                throw throwable;
            }
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        return wrapperList;
    }
}

