/*
 * Decompiled with CFR 0.152.
 */
package org.spin.cash.setup;

import java.util.Properties;
import org.compiere.model.MBPartner;
import org.compiere.model.MBank;
import org.compiere.model.MBankAccount;
import org.compiere.model.MCharge;
import org.compiere.model.MCurrency;
import org.compiere.model.Query;
import org.compiere.model.X_AD_ModelValidator;
import org.compiere.util.Env;
import org.spin.cash.model.MCBankAccountWithdrawal;
import org.spin.cash.model.validator.CashManagement;
import org.spin.util.ISetupDefinition;

public class Test
implements ISetupDefinition {
    private static final String SETUP_DESCRIPTION = "(*Created from Setup Automatically*)";
    private static final String SETUP_UUID = "(*AutomaticSetup*)";

    public String doIt(Properties context, String transactionName) {
        MBank cash;
        String name = "Main Bank";
        String routingNo = "010203";
        MBank bank = (MBank)new Query(context, "C_Bank", "Name = ? AND RoutingNo = ?", transactionName).setParameters(new Object[]{name, routingNo}).setClient_ID().first();
        int accountId = 0;
        if (bank == null || bank.getC_Bank_ID() <= 0) {
            bank = new MBank(Env.getCtx(), 0, transactionName);
            bank.setName(name);
            bank.setRoutingNo(routingNo);
            bank.setBankType("B");
            bank.setDescription(SETUP_DESCRIPTION);
            bank.setUUID(SETUP_UUID);
            bank.setIsDirectLoad(true);
            bank.saveEx();
            MBankAccount account = new MBankAccount(context, 0, transactionName);
            account.setC_Bank_ID(bank.getC_Bank_ID());
            account.setAccountNo("Main Account");
            account.setC_Currency_ID(MCurrency.get((Properties)Env.getCtx(), (String)"USD").getC_Currency_ID());
            account.setBankAccountType("C");
            account.setDescription(SETUP_DESCRIPTION);
            account.setUUID(SETUP_UUID);
            account.setIsDirectLoad(true);
            account.saveEx();
            accountId = account.getC_BankAccount_ID();
        }
        if ((cash = (MBank)new Query(context, "C_Bank", "Name = ? AND RoutingNo = ?", transactionName).setParameters(new Object[]{name = "Main Cash", routingNo = "None"}).setClient_ID().first()) == null || cash.getC_Bank_ID() <= 0) {
            cash = new MBank(Env.getCtx(), 0, transactionName);
            cash.setName(name);
            cash.setRoutingNo(routingNo);
            cash.setBankType("C");
            cash.setDescription(SETUP_DESCRIPTION);
            cash.setUUID(SETUP_UUID);
            cash.setIsDirectLoad(true);
            cash.saveEx();
            MCharge charge = new MCharge(Env.getCtx(), 0, transactionName);
            charge.setName("Bank transfer (Test)");
            charge.setDescription(SETUP_DESCRIPTION);
            charge.setUUID(SETUP_UUID);
            charge.setIsDirectLoad(true);
            charge.saveEx();
            MBPartner businessPartner = new MBPartner(Env.getCtx(), 0, transactionName);
            businessPartner.setValue("TestBP");
            businessPartner.setName("Test Business Partner");
            businessPartner.setDescription(SETUP_DESCRIPTION);
            businessPartner.setC_BP_Group_ID(new Query(Env.getCtx(), "C_BP_Group", null, transactionName).setClient_ID().firstId());
            businessPartner.setSOCreditStatus("O");
            businessPartner.setIsCustomer(true);
            businessPartner.setIsVendor(true);
            businessPartner.setUUID(SETUP_UUID);
            businessPartner.setIsDirectLoad(true);
            businessPartner.saveEx();
            MBankAccount cashAccount = new MBankAccount(context, 0, transactionName);
            cashAccount.setC_Bank_ID(cash.getC_Bank_ID());
            cashAccount.setAccountNo("Main Account");
            cashAccount.setC_Currency_ID(MCurrency.get((Properties)Env.getCtx(), (String)"USD").getC_Currency_ID());
            cashAccount.setBankAccountType("C");
            cashAccount.setDescription(SETUP_DESCRIPTION);
            cashAccount.setUUID(SETUP_UUID);
            cashAccount.set_ValueOfColumn("DepositBankAccount_ID", (Object)accountId);
            cashAccount.set_ValueOfColumn("DepositCharge_ID", (Object)charge.getC_Charge_ID());
            cashAccount.setC_BPartner_ID(businessPartner.getC_BPartner_ID());
            cashAccount.setIsDirectLoad(true);
            cashAccount.saveEx();
            MCBankAccountWithdrawal withdrawal = new MCBankAccountWithdrawal(context, 0, transactionName);
            withdrawal.setC_BankAccount_ID(cashAccount.getC_BankAccount_ID());
            withdrawal.setName("Test for Direct Debit");
            withdrawal.setTenderType("D");
            withdrawal.setDepositBankAccount_ID(accountId);
            withdrawal.setUUID(SETUP_UUID);
            withdrawal.setIsDirectLoad(true);
            withdrawal.saveEx();
        }
        this.createModelValidator(context, transactionName);
        return "@AD_SetupDefinition_ID@ @Ok@";
    }

    private X_AD_ModelValidator createModelValidator(Properties context, String transactionName) {
        X_AD_ModelValidator modelValidator = (X_AD_ModelValidator)new Query(context, "AD_ModelValidator", "ModelValidationClass = ?", transactionName).setParameters(new Object[]{CashManagement.class.getName()}).setClient_ID().first();
        if (modelValidator != null && modelValidator.getAD_ModelValidator_ID() > 0) {
            return modelValidator;
        }
        modelValidator = new X_AD_ModelValidator(context, 0, transactionName);
        modelValidator.setName("Cash Management");
        modelValidator.setEntityType("ECA16");
        modelValidator.setDescription(SETUP_DESCRIPTION);
        modelValidator.setSeqNo(200);
        modelValidator.setModelValidationClass(CashManagement.class.getName());
        modelValidator.setUUID(SETUP_UUID);
        modelValidator.setIsDirectLoad(true);
        modelValidator.saveEx();
        return modelValidator;
    }
}

