/*
 * Decompiled with CFR 0.152.
 */
package org.spin.cash.model.validator;

import org.compiere.model.MBankStatement;
import org.compiere.model.MClient;
import org.compiere.model.MOrder;
import org.compiere.model.MPayment;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.spin.cash.util.CashManagementUtil;

public class CashManagement
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(CashManagement.class);
    private int clientId = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.clientId = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addDocValidate("C_BankStatement", (ModelValidator)this);
        engine.addDocValidate("C_Payment", (ModelValidator)this);
        engine.addDocValidate("C_Order", (ModelValidator)this);
    }

    public int getAD_Client_ID() {
        return this.clientId;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public String modelChange(PO entity, int type) throws Exception {
        return null;
    }

    public String docValidate(PO entity, int timing) {
        if (timing == 7) {
            MPayment payment;
            if (entity.get_TableName().equals("C_BankStatement")) {
                MBankStatement bankStatement = (MBankStatement)entity;
                CashManagementUtil.createWithdrawalFromBankStatement(bankStatement);
            } else if (entity.get_TableName().equals("C_Order")) {
                MOrder order = (MOrder)entity;
                CashManagementUtil.validateCashOpeningForOrder(order);
            } else if (entity.get_TableName().equals("C_Payment") && (payment = (MPayment)entity).getC_Charge_ID() <= 0) {
                CashManagementUtil.validateCashOpeningForPayment(payment);
            }
        }
        return null;
    }
}

