/*
 * Decompiled with CFR 0.152.
 */
package org.spin.cash.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MBankAccount;
import org.compiere.model.Query;
import org.spin.cash.model.X_C_BankAccountWithdrawal;
import org.spin.cash.util.PaymentWrapper;

public class MCBankAccountWithdrawal
extends X_C_BankAccountWithdrawal {
    private static final long serialVersionUID = 3542373877117442475L;

    public MCBankAccountWithdrawal(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MCBankAccountWithdrawal(Properties ctx, int C_BankAccountWithdrawal_ID, String trxName) {
        super(ctx, C_BankAccountWithdrawal_ID, trxName);
    }

    protected boolean beforeSave(boolean newRecord) {
        MBankAccount bankAccount = (MBankAccount)this.getC_BankAccount();
        if (bankAccount.getC_BPartner_ID() <= 0) {
            throw new AdempiereException("@C_BankAccount_ID@ @C_BPartner_ID@ @IsMandatory@");
        }
        if (bankAccount.get_ValueAsInt("DepositCharge_ID") <= 0) {
            throw new AdempiereException("@C_BankAccount_ID@ @DepositCharge_ID@ @IsMandatory@");
        }
        if (bankAccount.get_ValueAsInt("DepositBankAccount_ID") <= 0 && this.getDepositBankAccount_ID() <= 0) {
            throw new AdempiereException("@C_BankAccount_ID@ @DepositBankAccount_ID@ @IsMandatory@");
        }
        return super.beforeSave(newRecord);
    }

    public static MCBankAccountWithdrawal findMatchFromPayment(Properties context, PaymentWrapper payment, String transactionName) {
        if (payment == null) {
            return null;
        }
        StringBuffer whereClause = new StringBuffer();
        ArrayList<Object> parameters = new ArrayList<Object>();
        whereClause.append("C_BankAccount_ID = ?");
        parameters.add(payment.getBankAccountId());
        whereClause.append(" AND (TenderType = ? OR TenderType IS NULL)");
        parameters.add(payment.getTenderType());
        whereClause.append(" AND (C_Currency_ID = ? OR C_Currency_ID IS NULL)");
        parameters.add(payment.getCurrencyId());
        whereClause.append(" AND (C_DocType_ID = ? OR C_DocType_ID IS NULL)");
        parameters.add(payment.getDocumentTypeId());
        if (payment.getBankId() > 0) {
            whereClause.append(" AND (C_Bank_ID = ? OR C_Bank_ID IS NULL)");
            parameters.add(payment.getBankId());
        }
        if (payment.getBusinessPartnerId() > 0) {
            whereClause.append(" AND (C_BPartner_ID = ? OR C_BPartner_ID IS NULL)");
            parameters.add(payment.getBusinessPartnerId());
        }
        return (MCBankAccountWithdrawal)new Query(context, "C_BankAccountWithdrawal", whereClause.toString(), transactionName).setParameters(parameters).setOnlyActiveRecords(true).setClient_ID().setOrderBy("C_Currency_ID DESC NULLS LAST, TenderType DESC NULLS LAST, C_DocType_ID DESC NULLS LAST, C_Bank_ID DESC NULLS LAST, C_BPartner_ID DESC NULLS LAST").first();
    }

    @Override
    public String toString() {
        return "MCBankAccountWithdrawal [getC_BankAccountWithdrawal_ID()=" + this.getC_BankAccountWithdrawal_ID() + ", getName()=" + this.getName() + "]";
    }
}

