/*
 * Decompiled with CFR 0.152.
 */
package org.spin.conversion.model.validator;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import org.adempiere.model.ImportValidator;
import org.adempiere.process.ImportProcess;
import org.compiere.FA.process.ImportFixedAsset;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MClient;
import org.compiere.model.MColumn;
import org.compiere.model.MConversionRate;
import org.compiere.model.MConversionType;
import org.compiere.model.MDocType;
import org.compiere.model.MInvoice;
import org.compiere.model.MOrder;
import org.compiere.model.MPaySelectionLine;
import org.compiere.model.MPayment;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_A_Asset_Addition;
import org.compiere.model.X_I_FixedAsset;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.compiere.util.Trx;
import org.spin.conversion.model.MConversion_Document;

public class CurrencyConvertDocuments
implements ModelValidator,
ImportValidator {
    private static CLogger log = CLogger.getCLogger(CurrencyConvertDocuments.class);
    private int clientId = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.clientId = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addDocValidate("C_Order", (ModelValidator)this);
        engine.addDocValidate("C_Invoice", (ModelValidator)this);
        engine.addDocValidate("C_Payment", (ModelValidator)this);
        engine.addDocValidate("A_Asset_Addition", (ModelValidator)this);
        engine.addDocValidate("ECA28_Expedient", (ModelValidator)this);
        engine.addModelChange("C_Order", (ModelValidator)this);
        engine.addModelChange("C_Invoice", (ModelValidator)this);
        engine.addModelChange("C_Payment", (ModelValidator)this);
        engine.addModelChange("A_Asset_Addition", (ModelValidator)this);
        engine.addModelChange("ECA28_Expedient", (ModelValidator)this);
        engine.addModelChange("C_PaySelectionLine", (ModelValidator)this);
        engine.addImportValidate("I_FixedAsset", (ImportValidator)this);
    }

    public int getAD_Client_ID() {
        return this.clientId;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public String docValidate(PO po1, int timing) {
        AtomicReference<Object> result = new AtomicReference<Object>(null);
        Optional<PO> maybeDocument = Optional.ofNullable(po1);
        maybeDocument.ifPresent(document -> {
            if (timing == 7 && (document.get_TableName().equals("C_Order") || document.get_TableName().equals("C_Invoice") || document.get_TableName().equals("C_Payment") || document.get_TableName().equals("A_Asset_Addition") || document.get_TableName().equals("ECA28_Expedient")) && this.isGeneratedCurrencyType((PO)document)) {
                MConversion_Document conversionDocument = MConversion_Document.get(document);
                Arrays.asList(MAcctSchema.getClientAcctSchema((Properties)document.getCtx(), (int)document.getAD_Client_ID())).stream().filter(schema -> schema.getC_Currency_ID() != conversionDocument.getC_Currency_ID()).forEach(schema -> {
                    MConversionType conversionType = Optional.ofNullable((MConversionType)new Query(document.getCtx(), "C_ConversionType", "C_ConversionType_ID = ? ", document.get_TrxName()).setParameters(new Object[]{conversionDocument.getC_ConversionType_ID()}).first()).orElse(new MConversionType(document.getCtx(), MConversionType.getDefault((int)document.getAD_Client_ID()), document.get_TrxName()));
                    if (conversionType.get_ValueAsInt("ParentConversionType_ID") == 0) {
                        result.set(this.createConversionType(conversionType, conversionDocument, schema.getC_Currency_ID()));
                    }
                });
            }
        });
        return result.get();
    }

    public String modelChange(PO po, int type) throws Exception {
        AtomicReference<Object> result = new AtomicReference<Object>(null);
        Optional<PO> maybeDocument = Optional.ofNullable(po);
        maybeDocument.ifPresent(document -> {
            MPayment payment;
            if (document.get_TableName().equals("C_Order") || document.get_TableName().equals("C_Invoice") || document.get_TableName().equals("C_Payment") || document.get_TableName().equals("A_Asset_Addition") || document.get_TableName().equals("ECA28_Expedient")) {
                if (type == 2 || type == 4) {
                    if (this.isGeneratedCurrencyType((PO)document)) {
                        MConversion_Document conversionDocument = MConversion_Document.get(document);
                        if (document.is_ValueChanged("DateAcct") || document.is_ValueChanged("DateDoc")) {
                            Timestamp newDate = Optional.ofNullable((Timestamp)document.get_Value("DateAcct")).orElse((Timestamp)document.get_Value("DateDoc"));
                            if (conversionDocument.getDateDoc().equals(conversionDocument.getNegotiatedConversionDate())) {
                                conversionDocument.setNegotiatedConversionDate(newDate);
                            }
                            conversionDocument.setDateDoc(newDate);
                        }
                        if (document.is_ValueChanged("C_ConversionType_ID")) {
                            conversionDocument.setC_ConversionType_ID(document.get_ValueAsInt("C_ConversionType_ID"));
                        }
                        if (document.is_ValueChanged("C_Currency_ID")) {
                            conversionDocument.setC_Currency_ID(document.get_ValueAsInt("C_Currency_ID"));
                        }
                        if (document.is_ValueChanged("AD_Org_ID")) {
                            conversionDocument.setAD_Org_ID(document.getAD_Org_ID());
                        }
                        if (document.is_ValueChanged("Processed")) {
                            conversionDocument.setProcessed(document.get_ValueAsBoolean("Processed"));
                        }
                        if (conversionDocument.is_Changed()) {
                            conversionDocument.save();
                        }
                    }
                } else if (type == 3) {
                    MConversion_Document.delete(document);
                }
            }
            if (document.get_TableName().equals("C_Payment") && (type == 2 || type == 1) && (payment = (MPayment)document).getC_ConversionType_ID() == 0) {
                if (payment.getC_Order_ID() > 0) {
                    payment.setC_ConversionType_ID(payment.getC_Order().getC_ConversionType_ID());
                }
                if (payment.getC_Invoice_ID() > 0) {
                    payment.setC_ConversionType_ID(payment.getC_Invoice().getC_ConversionType_ID());
                }
            }
            if (document.get_TableName().equals("C_PaySelectionLine") && (type == 2 || type == 1)) {
                MPaySelectionLine paySelectLine = (MPaySelectionLine)document;
                if (type == 2 && paySelectLine.is_ValueChanged("C_ConversionType_ID") || type == 1) {
                    if (paySelectLine.getC_Invoice_ID() > 0) {
                        paySelectLine.setC_ConversionType_ID(paySelectLine.getInvoice().getC_ConversionType_ID());
                    }
                    if (paySelectLine.getC_Order_ID() > 0) {
                        paySelectLine.setC_ConversionType_ID(paySelectLine.getOrder().getC_ConversionType_ID());
                    }
                }
                if (type == 2 && paySelectLine.is_ValueChanged("DifferenceAmt") && (paySelectLine.getC_Invoice_ID() != 0 || paySelectLine.getC_Order_ID() != 0 || paySelectLine.getHR_Movement_ID() != 0)) {
                    BigDecimal difference = paySelectLine.getOpenAmt().subtract(paySelectLine.getPayAmt()).subtract(paySelectLine.getDiscountAmt());
                    paySelectLine.setDifferenceAmt(difference);
                }
            }
        });
        return result.get();
    }

    private String createConversionType(MConversionType p_ConversionTypeBase, MConversion_Document conversionDocument, int p_SchemaCurrency_ID) {
        AtomicReference<Object> result = new AtomicReference<Object>(null);
        Optional.ofNullable(p_ConversionTypeBase).ifPresent(conversionTypeBase -> Optional.ofNullable(conversionDocument).ifPresent(document -> {
            Trx conversionTypeTrx = null;
            try {
                BigDecimal negotiatedRate;
                conversionTypeTrx = Trx.get((String)("#" + conversionDocument.get_ID()), (boolean)true);
                String trxName = conversionTypeTrx.getTrxName();
                MConversionType conversionType = new MConversionType(document.getCtx(), 0, trxName);
                PO.copyValues((PO)conversionTypeBase, (PO)conversionType);
                conversionType.setAD_Org_ID(0);
                this.setDocumentToConversionType(conversionType, (MConversionType)conversionTypeBase, (MConversion_Document)document);
                conversionType.setIsDefault(false);
                if (!conversionType.save()) {
                    result.set(("@SaveError@ @C_ConversionType_ID@ " + conversionType.getName()));
                }
                if ((negotiatedRate = Optional.ofNullable(conversionDocument.getNegotiatedRate()).orElse(Env.ZERO)).compareTo(Env.ZERO) == 0) {
                    new Query(document.getCtx(), "C_Conversion_Rate", " (? BETWEEN ValidFrom AND ValidTo) AND C_ConversionType_ID = ? ", document.get_TrxName()).setParameters(new Object[]{conversionDocument.getNegotiatedConversionDate(), conversionTypeBase.getC_ConversionType_ID()}).list().forEach(conversionRateBase -> {
                        MConversionRate conversionRate = new MConversionRate(document.getCtx(), 0, trxName);
                        PO.copyValues((PO)conversionRateBase, (PO)conversionRate);
                        conversionRate.setC_ConversionType_ID(conversionType.get_ID());
                        conversionRate.setAD_Org_ID(0);
                        conversionRate.setValidFrom(conversionDocument.getDateDoc());
                        conversionRate.setValidTo(TimeUtil.addYears((Timestamp)conversionDocument.getDateDoc(), (int)100));
                        if (!conversionRate.save()) {
                            result.set("@SaveError@ @C_ConversionRate_ID@ ");
                        }
                    });
                } else {
                    MConversionRate conversionRateFrom = new MConversionRate((PO)conversionType, conversionType.get_ID(), conversionDocument.getC_Currency_ID(), p_SchemaCurrency_ID, negotiatedRate, conversionDocument.getDateDoc());
                    conversionRateFrom.setValidTo(TimeUtil.addYears((Timestamp)conversionDocument.getDateDoc(), (int)100));
                    conversionRateFrom.setAD_Org_ID(0);
                    if (!conversionRateFrom.save()) {
                        result.set("@SaveError@ @C_ConversionRate_ID@ ");
                    }
                    MConversionRate conversionRateTo = new MConversionRate(conversionDocument.getCtx(), 0, trxName);
                    MConversionRate.copyValues((PO)conversionRateFrom, (PO)conversionRateTo);
                    conversionRateTo.setAD_Org_ID(0);
                    conversionRateTo.setC_ConversionType_ID(conversionType.get_ID());
                    conversionRateTo.setC_Currency_ID(p_SchemaCurrency_ID);
                    conversionRateTo.setC_Currency_ID_To(conversionDocument.getC_Currency_ID());
                    conversionRateTo.setDivideRate(negotiatedRate);
                    if (!conversionRateTo.save()) {
                        result.set("@SaveError@ @C_ConversionRate_ID@ ");
                    }
                }
                document.setC_ConversionType_ID(conversionType.get_ID());
                document.save();
                conversionTypeTrx.commit(true);
                result.set(document.setC_ConversionTypeDocument());
            }
            catch (SQLException e) {
                result.set(e.getMessage());
            }
            finally {
                Optional.ofNullable(conversionTypeTrx).ifPresent(connection -> {
                    connection.close();
                    connection = null;
                });
            }
        }));
        return result.get();
    }

    private void setDocumentToConversionType(MConversionType conversionType, MConversionType parentConversionType, MConversion_Document document) {
        if (document.getC_Order_ID() > 0) {
            conversionType.set_ValueOfColumn("C_Order_ID", (Object)document.getC_Order_ID());
        }
        if (document.getC_Invoice_ID() > 0) {
            conversionType.set_ValueOfColumn("C_Invoice_ID", (Object)document.getC_Invoice_ID());
        }
        if (document.getC_Payment_ID() > 0) {
            conversionType.set_ValueOfColumn("C_Payment_ID", (Object)document.getC_Payment_ID());
        }
        if (document.getA_Asset_Addition_ID() > 0) {
            conversionType.set_ValueOfColumn("A_Asset_Addition_ID", (Object)document.getA_Asset_Addition_ID());
        }
        if (document.get_ValueAsInt("ECA28_Expedient_ID") > 0) {
            conversionType.set_ValueOfColumn("ECA28_Expedient_ID", (Object)document.get_ValueAsInt("ECA28_Expedient_ID"));
        }
        MColumn columnValue = MColumn.get((Properties)document.getCtx(), (int)MColumn.getColumn_ID((String)"C_ConversionType", (String)"Value"));
        MColumn columnName = MColumn.get((Properties)document.getCtx(), (int)MColumn.getColumn_ID((String)"C_ConversionType", (String)"Name"));
        if (document.getValueOfDocumentAsInt("C_BPartner_ID") > 0) {
            conversionType.set_ValueOfColumn("C_BPartner_ID", (Object)document.getValueOfDocumentAsInt("C_BPartner_ID"));
        }
        conversionType.setValue(conversionType.getValue().concat(" - ").concat(document.getValueOfDocumentAsString("DocumentNo")));
        Integer fieldLength = columnValue.getFieldLength();
        conversionType.setValue(String.format("%-".concat(fieldLength.toString()).concat(".").concat(fieldLength.toString()).concat("s"), conversionType.getValue()).trim());
        conversionType.setName(conversionType.getName().concat(" - ").concat(document.getValueOfDocumentAsString("DocumentNo")));
        fieldLength = columnName.getFieldLength();
        conversionType.setName(String.format("%-".concat(fieldLength.toString()).concat(".").concat(fieldLength.toString()).concat("s"), conversionType.getName()).trim());
        conversionType.set_ValueOfColumn("ParentConversionType_ID", (Object)parentConversionType.get_ID());
    }

    private boolean isGeneratedCurrencyType(PO document) {
        int C_DocType_ID = 0;
        C_DocType_ID = document instanceof MOrder || document instanceof MInvoice ? document.get_ValueAsInt("C_DocTypeTarget_ID") : document.get_ValueAsInt("C_DocType_ID");
        return Optional.ofNullable(MDocType.get((Properties)document.getCtx(), (int)C_DocType_ID).get_ValueAsBoolean("IsGeneratedCurrencyType")).orElse(false);
    }

    public void validate(ImportProcess process, Object importModel, Object targetModel, int timing) {
        Optional<ImportProcess> maybeImportProcess = Optional.ofNullable(process);
        maybeImportProcess.ifPresent(importProcess -> {
            if (importProcess instanceof ImportFixedAsset) {
                Optional<X_I_FixedAsset> maybeImportFixesAsset = Optional.ofNullable((X_I_FixedAsset)importModel);
                maybeImportFixesAsset.ifPresent(importFixesAsset -> {
                    Optional<X_A_Asset_Addition> maybeAssetAddition = Optional.ofNullable((X_A_Asset_Addition)targetModel);
                    maybeAssetAddition.ifPresent(assetAddition -> {
                        if (timing == 30) {
                            String whereClause = "A_Asset_Addition_ID".concat("=?");
                            Optional<MConversion_Document> maybeConversionDocument = Optional.ofNullable((MConversion_Document)new Query(importFixesAsset.getCtx(), "C_Conversion_Document", whereClause, importFixesAsset.get_TrxName()).setParameters(new Object[]{assetAddition.get_ID()}).first());
                            maybeConversionDocument.ifPresent(conversionDocument -> {
                                Optional<BigDecimal> maybeNegotiateRate = Optional.ofNullable((BigDecimal)importFixesAsset.get_Value("NegotiatedRate"));
                                maybeNegotiateRate.ifPresent(negotiatedRate -> {
                                    conversionDocument.setNegotiatedRate((BigDecimal)negotiatedRate);
                                    conversionDocument.saveEx();
                                });
                            });
                        }
                    });
                });
            }
        });
    }
}

