/*
 * Decompiled with CFR 0.152.
 */
package org.spin.conversion.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.Env;
import org.spin.conversion.model.X_C_Conversion_Document;

public class MConversion_Document
extends X_C_Conversion_Document {
    private static final long serialVersionUID = 1L;
    private static CCache<String, MConversion_Document> doc_cache = new CCache("C_Conversion_Document", 20, 2);
    private PO currentDocument = null;

    public MConversion_Document(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MConversion_Document(Properties ctx, int C_Conversion_Document_ID, String trxName) {
        super(ctx, C_Conversion_Document_ID, trxName);
    }

    public MConversion_Document(PO document) {
        super(document.getCtx(), 0, document.get_TrxName());
        this.set_ValueOfColumn(document.get_TableName().concat("_ID"), document.get_ID());
        this.setC_Currency_ID(document.get_ValueAsInt("C_Currency_ID"));
        this.setC_ConversionType_ID(document.get_ValueAsInt("C_ConversionType_ID"));
        this.setIsGeneratedCurrencyType(true);
        this.setNegotiatedRate(Env.ZERO);
        this.setDateDoc(Optional.ofNullable((Timestamp)document.get_Value("DateAcct")).orElse((Timestamp)document.get_Value("DateDoc")));
        this.setNegotiatedConversionDate(this.getDateDoc());
        this.currentDocument = document;
        this.save();
    }

    public void setDocument(PO document) {
        this.currentDocument = document;
    }

    private PO getDocument() {
        if (this.currentDocument == null) {
            if (this.getC_Payment_ID() > 0) {
                this.currentDocument = (PO)this.getC_Payment();
            }
            if (this.getC_Invoice_ID() > 0) {
                this.currentDocument = (PO)this.getC_Invoice();
            }
            if (this.getC_Order_ID() > 0) {
                this.currentDocument = (PO)this.getC_Order();
            }
        }
        return this.currentDocument;
    }

    public static MConversion_Document get(PO document) {
        AtomicReference result = new AtomicReference();
        Optional<PO> maybeDocument = Optional.ofNullable(document);
        maybeDocument.ifPresent(doc -> {
            String key = MConversion_Document.getKey(doc);
            result.set((MConversion_Document)doc_cache.get((Object)key));
            if (result.get() == null) {
                String whereClause = doc.get_TableName() + "_ID = ?";
                Optional<MConversion_Document> maybeConversion = Optional.ofNullable((MConversion_Document)new Query(doc.getCtx(), "C_Conversion_Document", whereClause, doc.get_TrxName()).setParameters(new Object[]{doc.get_ID()}).first());
                maybeConversion.ifPresent(conversion -> conversion.setDocument(document));
                result.set(maybeConversion.orElseGet(() -> new MConversion_Document((PO)doc)));
            }
        });
        return (MConversion_Document)result.get();
    }

    public static void delete(PO document) {
        Optional<PO> maybeDocument = Optional.ofNullable(document);
        maybeDocument.ifPresent(doc -> {
            String key = MConversion_Document.getKey(doc);
            MConversion_Document conversionDocument = MConversion_Document.get(document);
            conversionDocument.delete(true);
            doc_cache.remove((Object)key);
        });
    }

    public static String getKey(PO document) {
        return document.get_TableName().concat("_").concat(String.valueOf(document.get_ID()));
    }

    public String getValueOfDocumentAsString(String columnName) {
        Optional<Object> maybeValue = Optional.ofNullable(this.getValueOfDocument(columnName));
        if (maybeValue.isPresent()) {
            return maybeValue.get().toString();
        }
        return "";
    }

    public Integer getValueOfDocumentAsInt(String columnName) {
        Optional<Object> maybeValue = Optional.ofNullable(this.getValueOfDocument(columnName));
        if (maybeValue.isPresent()) {
            return (Integer)maybeValue.get();
        }
        return 0;
    }

    public Object getValueOfDocument(String columnName) {
        Optional<PO> maybePO = Optional.ofNullable(this.getDocument());
        AtomicReference<Object> result = new AtomicReference<Object>(null);
        maybePO.ifPresent(po -> result.set(po.get_Value(columnName)));
        return result.get();
    }

    public String setC_ConversionTypeDocument() {
        Optional<PO> maybePO = Optional.ofNullable(this.getDocument());
        AtomicReference<Object> result = new AtomicReference<Object>(null);
        maybePO.ifPresent(po -> {
            po.set_ValueOfColumn("C_ConversionType_ID", (Object)this.getC_ConversionType_ID());
            if (!po.save()) {
                result.set(("@SaveError@ @DocumentNo@ " + po.get_ValueAsString("DocumentNo")));
            }
        });
        return result.get();
    }
}

