/*
 * Decompiled with CFR 0.152.
 */
package org.spin.eos.util.support.currency;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.Response;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MConversionType;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.json.JSONArray;
import org.json.JSONObject;
import org.spin.eos.support.ConversionRate;
import org.spin.eos.support.IConversionRate;
import org.spin.eos.support.IConversionRateInfo;
import org.spin.eos.util.support.currency.RequestUtil;
import org.spin.model.MADAppRegistration;
import org.spin.util.support.IAppSupport;

public class ERPCustomApi_v2
implements IAppSupport,
IConversionRateInfo {
    private int registrationId = 0;
    private List<IConversionRate> conversionRates;
    private List<String> currencies;
    private final String CONVERTIBLE_CURRENCIES_KEY = "convertible_currencies_key";
    private final String TOKEN = "token";
    private String token = null;
    private String currenciesParameter = null;
    private RequestUtil api;
    private MConversionType conversionType;
    private Timestamp conversionDateFrom;
    private Timestamp conversionDateTo;
    protected transient CLogger log = CLogger.getCLogger(this.getClass());

    private MADAppRegistration getRegistrationInstance() {
        if (this.getAppRegistrationId() <= 0) {
            throw new AdempiereException("@AD_AppRegistration_ID@ @NotFound@");
        }
        MADAppRegistration registration = MADAppRegistration.getById((Properties)Env.getCtx(), (int)this.getAppRegistrationId(), null);
        this.currenciesParameter = registration.getParameterValue("convertible_currencies_key");
        this.token = registration.getParameterValue("token");
        this.processCurrenciesFromParameter();
        this.conversionRates = new ArrayList<IConversionRate>();
        this.api = new RequestUtil(this.token, "erp_utils", "erp_utils", "currency_rate");
        return registration;
    }

    private void processCurrenciesFromParameter() {
        if (!Util.isEmpty((String)this.currenciesParameter)) {
            this.currencies = Arrays.asList(this.currenciesParameter.split(",")).stream().map(currency -> currency.trim()).collect(Collectors.toList());
        } else {
            this.currenciesParameter = null;
        }
    }

    public void setAppRegistrationId(int registrationId) {
        this.registrationId = registrationId;
    }

    public int getAppRegistrationId() {
        return this.registrationId;
    }

    public String testConnection() {
        try {
            this.getRegistrationInstance();
            this.api.call();
            Response response = this.api.getWebResponse();
            AtomicReference resultValue = new AtomicReference();
            if (response.getStatus() == 200) {
                String output = (String)response.readEntity(String.class);
                Optional.ofNullable(output).ifPresent(value -> resultValue.set(value.toString()));
            }
            return (String)resultValue.get();
        }
        catch (Exception e) {
            throw new AdempiereException(e.getLocalizedMessage());
        }
    }

    @Override
    public List<IConversionRate> getConversionRates() {
        this.getRegistrationInstance();
        try {
            this.getRegistrationInstance();
            int totalPage = 1;
            int records = 25;
            for (int currentPage = 0; currentPage <= totalPage; ++currentPage) {
                if (this.conversionType != null) {
                    this.api.withParameter("queries[]", "equal(exchange_type, " + this.conversionType.getValue() + ")");
                }
                if (this.conversionDateFrom != null) {
                    this.api.withParameter("queries[]", "greaterThanEqual(date, " + new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS+00:00").format(this.conversionDateFrom) + ")");
                }
                if (this.conversionDateTo != null) {
                    this.api.withParameter("queries[]", "lessThanEqual(date, " + new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS+00:00").format(this.conversionDateTo) + ")");
                }
                this.api.withParameter("queries[]", "limit(" + records + ")");
                this.api.withParameter("queries[]", "offset(" + records * currentPage + ")");
                AtomicReference resultValue = new AtomicReference();
                JSONObject output = this.api.getOutputData();
                Optional.ofNullable(output).ifPresent(value -> {
                    try {
                        if (value.toMap().get("error") == null) {
                            JSONArray currencies = value.getJSONArray("documents");
                            currencies.forEach(currencyValue -> {
                                try {
                                    JSONObject currency = (JSONObject)currencyValue;
                                    String currencyFromIsoCode = currency.getString("currency_from");
                                    String currencyToIsoCode = currency.getString("currency_to");
                                    String conversionType = currency.getString("exchange_type");
                                    BigDecimal rate = BigDecimal.valueOf(currency.getDouble("rate"));
                                    Date validFrom = new SimpleDateFormat("yyyy-MM-dd").parse(currency.getString("date"));
                                    this.processCurrency(currencyFromIsoCode, currencyToIsoCode, rate, new Timestamp(validFrom.getTime()), conversionType);
                                }
                                catch (Exception e) {
                                    throw new AdempiereException((Throwable)e);
                                }
                            });
                        }
                    }
                    catch (Exception e) {
                        throw new AdempiereException((Throwable)e);
                    }
                    resultValue.set(value.toString());
                });
                totalPage = output.getInt("total") / records;
                this.api.setOutputData(null);
                this.api.setParameters(new MultivaluedHashMap());
            }
        }
        catch (Exception e) {
            throw new AdempiereException((Throwable)e);
        }
        return this.conversionRates;
    }

    @Override
    public void setCurrencies(List<String> currenciesISOCodeList) {
        if (this.currencies == null || this.currencies.size() <= 0) {
            this.currencies = currenciesISOCodeList;
        }
    }

    private void processCurrency(String currencyFromIsoCode, String currencyToIsoCode, BigDecimal rate, Timestamp validFrom, String conversionType) {
        ConversionRate conversionRate = new ConversionRate(currencyFromIsoCode).withCurrencyToISOCode(currencyToIsoCode).withValidFrom(validFrom).withMultiplyRate(rate);
        this.conversionRates.add(conversionRate);
    }

    @Override
    public void setSearchParameters(Timestamp conversionDateFrom, Timestamp conversionDateTo, MConversionType conversionType) {
        this.conversionDateFrom = conversionDateFrom;
        this.conversionDateTo = conversionDateTo;
        this.conversionType = conversionType;
    }
}

