/*
 * Decompiled with CFR 0.152.
 */
package org.spin.eos.util.support.currency;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MConversionType;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.compiere.util.Util;
import org.json.JSONArray;
import org.json.JSONObject;
import org.spin.eos.support.ConversionRate;
import org.spin.eos.support.IConversionRate;
import org.spin.eos.support.IConversionRateInfo;
import org.spin.eos.util.support.currency.RequestUtil;
import org.spin.model.MADAppRegistration;
import org.spin.util.support.IAppSupport;

public class ERPCustomApi_v1
implements IAppSupport,
IConversionRateInfo {
    private int registrationId = 0;
    private List<IConversionRate> conversionRates;
    private List<String> currencies;
    private final String CONVERTIBLE_CURRENCIES_KEY = "convertible_currencies_key";
    private final String TOKEN = "token";
    private String token = null;
    private String currenciesParameter = null;
    private RequestUtil requester;
    private MConversionType conversionType;
    protected transient CLogger log = CLogger.getCLogger(this.getClass());

    private MADAppRegistration getRegistrationInstance() {
        if (this.getAppRegistrationId() <= 0) {
            throw new AdempiereException("@AD_AppRegistration_ID@ @NotFound@");
        }
        MADAppRegistration registration = MADAppRegistration.getById((Properties)Env.getCtx(), (int)this.getAppRegistrationId(), null);
        this.currenciesParameter = registration.getParameterValue("convertible_currencies_key");
        this.token = registration.getParameterValue("token");
        this.processCurrenciesFromParameter();
        this.conversionRates = new ArrayList<IConversionRate>();
        this.requester = new RequestUtil(this.token, "ERP-Utils", "Utils", "CurrencyRate");
        return registration;
    }

    private void processCurrenciesFromParameter() {
        if (!Util.isEmpty((String)this.currenciesParameter)) {
            this.currencies = Arrays.asList(this.currenciesParameter.split(",")).stream().map(currency -> currency.trim()).collect(Collectors.toList());
        } else {
            this.currenciesParameter = null;
        }
    }

    public void setAppRegistrationId(int registrationId) {
        this.registrationId = registrationId;
    }

    public int getAppRegistrationId() {
        return this.registrationId;
    }

    public String testConnection() {
        try {
            this.getRegistrationInstance();
            this.requester.call();
            Response response = this.requester.getWebResponse();
            AtomicReference resultValue = new AtomicReference();
            if (response.getStatus() == 200) {
                String output = (String)response.readEntity(String.class);
                Optional.ofNullable(output).ifPresent(value -> resultValue.set(value.toString()));
            }
            return (String)resultValue.get();
        }
        catch (Exception e) {
            throw new AdempiereException(e.getLocalizedMessage());
        }
    }

    @Override
    public List<IConversionRate> getConversionRates() {
        this.getRegistrationInstance();
        try {
            this.getRegistrationInstance();
            this.requester.call();
            Response response = this.requester.getWebResponse();
            AtomicReference resultValue = new AtomicReference();
            if (response.getStatus() == 200) {
                JSONObject output = this.requester.getOutputData();
                Optional.ofNullable(output).ifPresent(value -> {
                    try {
                        JSONArray currencies = value.getJSONArray("documents");
                        currencies.forEach(currencyValue -> {
                            try {
                                JSONObject currency = (JSONObject)currencyValue;
                                String currencyFromIsoCode = currency.getString("CurrencyFrom");
                                String currencyToIsoCode = currency.getString("CurrencyTo");
                                String conversionType = currency.getString("ExchangeType");
                                BigDecimal rate = BigDecimal.valueOf(currency.getDouble("Rate"));
                                Date validFrom = new SimpleDateFormat("yyyy-MM-dd").parse(currency.getString("Date"));
                                this.processCurrency(currencyFromIsoCode, currencyToIsoCode, rate, new Timestamp(validFrom.getTime()), conversionType);
                            }
                            catch (Exception e) {
                                throw new AdempiereException((Throwable)e);
                            }
                        });
                    }
                    catch (Exception e) {
                        throw new AdempiereException((Throwable)e);
                    }
                    resultValue.set(value.toString());
                });
            }
        }
        catch (Exception e) {
            throw new AdempiereException((Throwable)e);
        }
        return this.conversionRates;
    }

    @Override
    public void setCurrencies(List<String> currenciesISOCodeList) {
        if (this.currencies == null || this.currencies.size() <= 0) {
            this.currencies = currenciesISOCodeList;
        }
    }

    private void processCurrency(String currencyFromIsoCode, String currencyToIsoCode, BigDecimal rate, Timestamp validFrom, String conversionType) {
        if (this.isValidConversionType(conversionType) && this.isValidCurrency(currencyFromIsoCode) && this.isValidCurrency(currencyToIsoCode)) {
            ConversionRate conversionRate = new ConversionRate(currencyFromIsoCode).withCurrencyToISOCode(currencyToIsoCode).withValidFrom(TimeUtil.getDay((long)System.currentTimeMillis()));
            if (rate.compareTo(Env.ZERO) > 0) {
                conversionRate.withDivideRate(rate);
            } else {
                conversionRate.withMultiplyRate(rate);
            }
            this.conversionRates.add(conversionRate);
            ConversionRate reciprocalRate = new ConversionRate(currencyToIsoCode).withCurrencyToISOCode(currencyFromIsoCode).withValidFrom(TimeUtil.getDay((long)System.currentTimeMillis()));
            if (rate.compareTo(Env.ZERO) > 0) {
                reciprocalRate.withMultiplyRate(rate);
            } else {
                reciprocalRate.withDivideRate(rate);
            }
            this.conversionRates.add(reciprocalRate);
        }
    }

    private boolean isValidCurrency(String currencyIsoCode) {
        if (this.currencies == null || this.currencies.size() <= 0 || currencyIsoCode == null || currencyIsoCode.length() <= 0) {
            return true;
        }
        return this.currencies.contains(currencyIsoCode);
    }

    private boolean isValidConversionType(String conversionTypeValue) {
        if (this.conversionType == null) {
            return true;
        }
        return Optional.ofNullable(conversionTypeValue).orElse("").equals(Optional.ofNullable(this.conversionType.getValue()).orElse(""));
    }

    @Override
    public void setSearchParameters(Timestamp conversionDateFrom, Timestamp conversionDateTo, MConversionType conversionType) {
        this.conversionType = conversionType;
    }
}

