/*
 * Decompiled with CFR 0.152.
 */
package org.spin.eos.support;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MConversionRate;
import org.compiere.model.MCurrency;
import org.compiere.model.Query;
import org.compiere.util.Util;
import org.spin.eos.support.IConversionRate;

public class ConversionRate
implements IConversionRate {
    private String currencyISOCode;
    private String currencyToISOCode;
    private BigDecimal multiplyRate;
    private BigDecimal divideRate;
    private Timestamp validFrom;
    private Timestamp validTo;

    public ConversionRate(String currencyISOCode) {
        this.currencyISOCode = currencyISOCode;
    }

    @Override
    public String getCurrencyIsoCode() {
        return this.currencyISOCode;
    }

    @Override
    public String getCurrencyToIsoCode() {
        return this.currencyToISOCode;
    }

    @Override
    public BigDecimal getMultiplyRate() {
        return this.multiplyRate;
    }

    @Override
    public BigDecimal getDivideRate() {
        return this.divideRate;
    }

    @Override
    public Timestamp getValidFrom() {
        return this.validFrom;
    }

    @Override
    public Timestamp getValidTo() {
        return this.validTo;
    }

    public final ConversionRate withCurrencyToISOCode(String currencyToISOCode) {
        this.currencyToISOCode = currencyToISOCode;
        return this;
    }

    public final ConversionRate withMultiplyRate(BigDecimal multiplyRate) {
        this.multiplyRate = multiplyRate;
        return this;
    }

    public final ConversionRate withDivideRate(BigDecimal divideRate) {
        this.divideRate = divideRate;
        return this;
    }

    public final ConversionRate withValidFrom(Timestamp validFrom) {
        this.validFrom = validFrom;
        return this;
    }

    public final ConversionRate withValidTo(Timestamp validTo) {
        this.validTo = validTo;
        return this;
    }

    @Override
    public MConversionRate getConversionRate(Properties context, int convertionTypeId, String trxName) {
        return (MConversionRate)new Query(context, "C_Conversion_Rate", "C_ConversionType_ID = ? AND ValidFrom = ? AND ValidTo = ? AND EXISTS(SELECT 1 FROM C_Currency c WHERE UPPER(c.ISO_Code) = UPPER(?) AND c.C_Currency_ID = C_Conversion_Rate.C_Currency_ID) AND EXISTS(SELECT 1 FROM C_Currency c WHERE UPPER(c.ISO_Code) = UPPER(?) AND c.C_Currency_ID = C_Conversion_Rate.C_Currency_ID_To) ", trxName).setParameters(new Object[]{convertionTypeId, this.getValidFrom(), this.getValidTo() != null ? this.getValidTo() : this.getValidFrom(), this.getCurrencyIsoCode(), this.getCurrencyToIsoCode()}).setClient_ID().first();
    }

    @Override
    public MConversionRate fillConversionRate(Properties context, int convertionTypeId, String trxName) {
        if (convertionTypeId <= 0) {
            return null;
        }
        MConversionRate conversionRate = this.getConversionRate(context, convertionTypeId, trxName);
        if (conversionRate == null || conversionRate.getC_Conversion_Rate_ID() == 0) {
            conversionRate = new MConversionRate(context, 0, trxName);
            conversionRate.setC_ConversionType_ID(convertionTypeId);
        }
        if (Util.isEmpty((String)this.getCurrencyIsoCode())) {
            throw new AdempiereException("@C_Currency_ID@ @ISO_Code@ @NotFound@");
        }
        if (Util.isEmpty((String)this.getCurrencyToIsoCode())) {
            throw new AdempiereException("@C_Currency_ID_To@ @ISO_Code@ @NotFound@");
        }
        if (this.getValidFrom() == null) {
            throw new AdempiereException("@ValidFrom@ @NotFound@");
        }
        if (!(this.getMultiplyRate() != null && this.getMultiplyRate().signum() != 0 || this.getDivideRate() != null && this.getDivideRate().signum() != 0)) {
            throw new AdempiereException("@MultiplyRate@ / @DivideRate@ @NotFound@");
        }
        MCurrency currency = MCurrency.get((Properties)context, (String)this.getCurrencyIsoCode());
        MCurrency currencyTo = MCurrency.get((Properties)context, (String)this.getCurrencyToIsoCode());
        if (currency == null) {
            return null;
        }
        if (currencyTo == null) {
            return null;
        }
        conversionRate.setC_Currency_ID(currency.getC_Currency_ID());
        conversionRate.setC_Currency_ID_To(currencyTo.getC_Currency_ID());
        if (this.getMultiplyRate() != null && this.getMultiplyRate().signum() != 0) {
            conversionRate.setMultiplyRate(this.getMultiplyRate());
        } else {
            conversionRate.setDivideRate(this.getDivideRate());
        }
        conversionRate.setValidFrom(this.getValidFrom());
        if (this.getValidTo() != null) {
            conversionRate.setValidTo(this.getValidTo());
        } else {
            conversionRate.setValidTo(this.getValidFrom());
        }
        conversionRate.set_ValueOfColumn("IsRateGenerated", (Object)true);
        return conversionRate;
    }

    public String toString() {
        return "ConversionRate [currencyISOCode=" + this.currencyISOCode + ", currencyToISOCode=" + this.currencyToISOCode + ", multiplyRate=" + this.multiplyRate + ", divideRate=" + this.divideRate + ", validFrom=" + this.validFrom + ", validTo=" + this.validTo + "]";
    }
}

