/*
 * Decompiled with CFR 0.152.
 */
package org.spin.eos.process;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.I_C_ConversionType;
import org.compiere.model.I_C_Currency;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MConversionRate;
import org.compiere.model.MConversionType;
import org.compiere.model.MCurrency;
import org.compiere.model.Query;
import org.compiere.util.Trx;
import org.compiere.util.TrxRunnable;
import org.spin.eos.process.GetCurrencyRatesFromProviderAbstract;
import org.spin.eos.support.IConversionRate;
import org.spin.eos.support.IConversionRateInfo;
import org.spin.eos.util.exchange.Exchange;
import org.spin.model.MADAppRegistration;
import org.spin.util.support.AppSupportHandler;
import org.spin.util.support.IAppSupport;

public class GetCurrencyRatesFromProvider
extends GetCurrencyRatesFromProviderAbstract {
    private AtomicInteger created = new AtomicInteger();
    private AtomicInteger updated = new AtomicInteger();
    private AtomicInteger errors = new AtomicInteger();

    protected String doIt() throws Exception {
        ArrayList<MCurrency> currencyList = new ArrayList<MCurrency>();
        if (this.isOnlyGetFromAcctSchema()) {
            Arrays.asList(MAcctSchema.getClientAcctSchema((Properties)this.getCtx(), (int)this.getAD_Client_ID())).forEach(accSchema -> currencyList.add(MCurrency.get((Properties)this.getCtx(), (int)accSchema.getC_Currency_ID())));
        } else if (this.getRecord_ID() != 0 && this.getTable_ID() == I_C_Currency.Table_ID) {
            currencyList.add(MCurrency.get((Properties)this.getCtx(), (int)this.getRecord_ID()));
        } else {
            new Query(this.getCtx(), "C_Currency", null, this.get_TrxName()).setOnlyActiveRecords(true).list().forEach(currency -> currencyList.add((MCurrency)currency));
        }
        if (this.getRecord_ID() != 0 && this.getTable_ID() == I_C_ConversionType.Table_ID) {
            MConversionType conversionType2 = new MConversionType(this.getCtx(), this.getRecord_ID(), this.get_TrxName());
            if (conversionType2.get_ValueAsInt("CurrencyRateProvider_ID") <= 0) {
                throw new AdempiereException("@CurrencyRateProvider_ID@ @NotFound@");
            }
            this.pullRates(conversionType2, currencyList);
        } else {
            new Query(this.getCtx(), "C_ConversionType", "CurrencyRateProvider_ID IS NOT NULL", this.get_TrxName()).setClient_ID().list().forEach(conversionType -> this.pullRates((MConversionType)conversionType, (List<MCurrency>)currencyList));
        }
        return "@Created@: " + this.created.get() + " - @Updated@: " + this.updated.get() + " - @Errors@: " + this.errors.get();
    }

    private void pullRates(MConversionType conversionType, List<MCurrency> currencyList) {
        try {
            IAppSupport supportedApi = AppSupportHandler.getInstance().getAppSupport(MADAppRegistration.getById((Properties)this.getCtx(), (int)conversionType.get_ValueAsInt("CurrencyRateProvider_ID"), (String)this.get_TrxName()));
            if (supportedApi == null) {
                throw new AdempiereException("@CurrencyRateProvider_ID@ @NotFound@");
            }
            if (!IConversionRateInfo.class.isAssignableFrom(supportedApi.getClass())) {
                throw new AdempiereException("@CurrencyRateProvider_ID@ @Invalid@");
            }
            IConversionRateInfo currencyRateInfo = (IConversionRateInfo)supportedApi;
            if (currencyList != null && currencyList.size() > 0) {
                ArrayList<String> currencies = new ArrayList<String>();
                currencyList.forEach(currency -> currencies.add(currency.getISO_Code()));
                currencyRateInfo.setCurrencies(currencies);
            }
            currencyRateInfo.setSearchParameters(this.getDateTrx(), this.getDateTrxTo(), conversionType);
            currencyRateInfo.getConversionRates().forEach(conversionRateLoaded -> Trx.run((TrxRunnable)new TrxRunnable((IConversionRate)conversionRateLoaded, conversionType){
                final /* synthetic */ IConversionRate val$conversionRateLoaded;
                final /* synthetic */ MConversionType val$conversionType;
                {
                    this.val$conversionRateLoaded = iConversionRate;
                    this.val$conversionType = mConversionType;
                }

                public void run(String trxName) {
                    try {
                        boolean isNew;
                        MConversionRate conversionRate = this.val$conversionRateLoaded.fillConversionRate(GetCurrencyRatesFromProvider.this.getCtx(), this.val$conversionType.getC_ConversionType_ID(), trxName);
                        if (conversionRate != null && ((isNew = conversionRate.is_new()) || GetCurrencyRatesFromProvider.this.isUpdateCurrentRates())) {
                            conversionRate.saveEx();
                            if (isNew) {
                                GetCurrencyRatesFromProvider.this.created.addAndGet(1);
                            } else {
                                GetCurrencyRatesFromProvider.this.updated.addAndGet(1);
                            }
                            MCurrency currency = MCurrency.get((Properties)GetCurrencyRatesFromProvider.this.getCtx(), (int)conversionRate.getC_Currency_ID());
                            MCurrency currencyTo = MCurrency.get((Properties)GetCurrencyRatesFromProvider.this.getCtx(), (int)conversionRate.getC_Currency_ID_To());
                            GetCurrencyRatesFromProvider.this.addLog(Exchange.getMessageWithParameters(GetCurrencyRatesFromProvider.this.getCtx(), "ExchangeOperationSystemRate", currency.getISO_Code(), currencyTo.getISO_Code(), conversionRate.getValidFrom(), conversionRate.getValidTo(), conversionRate.getMultiplyRate(), conversionRate.getDivideRate()));
                        }
                    }
                    catch (Exception e) {
                        GetCurrencyRatesFromProvider.this.errors.addAndGet(1);
                        GetCurrencyRatesFromProvider.this.log.severe(e.getMessage());
                    }
                }
            }));
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
        }
    }
}

