/*
 * Decompiled with CFR 0.152.
 */
package org.spin.eos.model.validator;

import org.compiere.model.I_C_Payment;
import org.compiere.model.MClient;
import org.compiere.model.MPayment;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.Util;
import org.spin.eos.model.MEOSExchange;
import org.spin.eos.model.MEOSExchangeType;

public class ExchangeOperations
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ExchangeOperations.class);
    private int clientId = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.clientId = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addModelChange("C_Payment", (ModelValidator)this);
        engine.addDocValidate("C_Payment", (ModelValidator)this);
    }

    public int getAD_Client_ID() {
        return this.clientId;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public String modelChange(PO po, int type) throws Exception {
        MPayment payment;
        int exchangeId;
        if ((type == 1 || type == 2) && po.get_Table_ID() == I_C_Payment.Table_ID && (po.is_ValueChanged("IsReceipt") || po.is_ValueChanged("EOS_Exchange_ID")) && (exchangeId = (payment = (MPayment)po).get_ValueAsInt("EOS_Exchange_ID")) != 0) {
            MEOSExchangeType exchangeType;
            MEOSExchange exchange = new MEOSExchange(payment.getCtx(), exchangeId, payment.get_TrxName());
            if (payment.isReceipt()) {
                payment.setC_Currency_ID(exchange.getCollectCurrency_ID());
            } else {
                payment.setC_Currency_ID(exchange.getPaymentCurrency_ID());
            }
            payment.setC_ConversionType_ID(exchange.getC_ConversionType_ID());
            if (Util.isEmpty((String)payment.getDescription()) && !Util.isEmpty((String)exchange.getDescription())) {
                payment.setDescription(exchange.getDescription());
            }
            if (payment.getC_BPartner_ID() == 0) {
                payment.setC_BPartner_ID(exchange.getC_BPartner_ID());
            }
            if (payment.getC_Charge_ID() == 0 && (exchangeType = MEOSExchangeType.getById(payment.getCtx(), exchange.getEOS_ExchangeType_ID(), payment.get_TrxName())).getC_Charge_ID() != 0) {
                payment.setC_Charge_ID(exchangeType.getC_Charge_ID());
            }
        }
        return null;
    }

    public String docValidate(PO po, int timing) {
        MPayment payment;
        int exchangeId;
        if (timing == 7 && po.get_Table_ID() == I_C_Payment.Table_ID && (exchangeId = (payment = (MPayment)po).get_ValueAsInt("EOS_Exchange_ID")) != 0) {
            MEOSExchange exchange = new MEOSExchange(payment.getCtx(), exchangeId, payment.get_TrxName());
            exchange.addExchangeAmount(payment.getPayAmt(), payment.isReceipt());
        }
        return null;
    }
}

