/*
 * Decompiled with CFR 0.152.
 */
package org.spin.eos.model.validator;

import java.sql.Timestamp;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.I_C_Conversion_Rate;
import org.compiere.model.MClient;
import org.compiere.model.MConversionRate;
import org.compiere.model.MConversionType;
import org.compiere.model.MOrgInfo;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.spin.eos.util.exchange.ExchangeOperationSystemUtil;

public class ConversionRate
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ConversionRate.class);
    private int clientId = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.clientId = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addModelChange("C_Conversion_Rate", (ModelValidator)this);
        this.addDocumentEngine(engine);
    }

    private void addDocumentEngine(ModelValidationEngine engine) {
        new Query(Env.getCtx(), "AD_Table", "IsDocument = 'Y' AND TableName NOT IN(?, ?, ?, ?, ?) AND EXISTS(SELECT 1 FROM AD_Column c \t\t\tWHERE c.AD_Table_ID = AD_Table.AD_Table_ID AND c.ColumnName IN(?, ?))", null).setParameters(new Object[]{"C_AllocationHdr", "C_PaySelection", "M_MatchInv", "GL_Journal", "GL_JournalBatch", "C_ConversionType_ID", "C_Currency_ID"}).setOnlyActiveRecords(true).list().forEach(table -> engine.addDocValidate(table.getTableName(), (ModelValidator)this));
    }

    public int getAD_Client_ID() {
        return this.clientId;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public String modelChange(PO po, int type) throws Exception {
        MConversionRate reciprocalRate;
        MConversionRate conversionRate;
        MOrgInfo organizationInfo;
        if (po.get_Table_ID() == I_C_Conversion_Rate.Table_ID && this.isNegotiatedConversionRate((MConversionRate)po)) {
            return null;
        }
        if (type == 4) {
            MConversionRate conversionRate2;
            MOrgInfo organizationInfo2;
            if (po.get_Table_ID() == I_C_Conversion_Rate.Table_ID && (organizationInfo2 = MOrgInfo.get((Properties)(conversionRate2 = (MConversionRate)po).getCtx(), (int)conversionRate2.getAD_Org_ID(), (String)conversionRate2.get_TrxName())).get_ValueAsBoolean("CreateReciprocalRate") && po.isActive() && !conversionRate2.get_ValueAsBoolean("IsRateGenerated")) {
                MConversionRate reciprocalRate2 = new MConversionRate(po, conversionRate2.getC_ConversionType_ID(), conversionRate2.getC_Currency_ID_To(), conversionRate2.getC_Currency_ID(), conversionRate2.getDivideRate(), conversionRate2.getValidFrom());
                if (conversionRate2.getMultiplyRate().compareTo(Env.ONE) > 0) {
                    reciprocalRate2.setDivideRate(conversionRate2.getMultiplyRate());
                }
                reciprocalRate2.setIsActive(false);
                reciprocalRate2.setValidTo(conversionRate2.getValidTo());
                reciprocalRate2.saveEx();
                reciprocalRate2.setIsActive(true);
                reciprocalRate2.set_ValueOfColumn("SourceConversionRate_ID", (Object)conversionRate2.getC_Conversion_Rate_ID());
                reciprocalRate2.saveEx();
            }
        } else if (type == 1 || type == 2) {
            MConversionRate conversionRate3;
            MOrgInfo organizationInfo3;
            if (po.get_Table_ID() == I_C_Conversion_Rate.Table_ID && (po.is_new() || po.is_ValueChanged("ValidFrom") || po.is_ValueChanged("ValidTo") || po.is_ValueChanged("AD_Org_ID") || po.is_ValueChanged("C_ConversionType_ID") || po.is_ValueChanged("C_Currency_ID") || po.is_ValueChanged("C_Currency_ID_To")) && (organizationInfo3 = MOrgInfo.get((Properties)(conversionRate3 = (MConversionRate)po).getCtx(), (int)conversionRate3.getAD_Org_ID(), (String)conversionRate3.get_TrxName())).get_ValueAsBoolean("IsDailyConversionRate")) {
                if (ExchangeOperationSystemUtil.existsConversionRate(conversionRate3)) {
                    throw new AdempiereException("@AlreadyExistsConversionRate@");
                }
                conversionRate3.setValidTo(conversionRate3.getValidFrom());
            }
        } else if (type == 6 && po.get_Table_ID() == I_C_Conversion_Rate.Table_ID && (organizationInfo = MOrgInfo.get((Properties)(conversionRate = (MConversionRate)po).getCtx(), (int)conversionRate.getAD_Org_ID(), (String)conversionRate.get_TrxName())).get_ValueAsBoolean("CreateReciprocalRate") && po.isActive() && !conversionRate.get_ValueAsBoolean("IsRateGenerated") && conversionRate.get_ValueAsInt("SourceConversionRate_ID") == 0 && Optional.ofNullable(reciprocalRate = ExchangeOperationSystemUtil.getReciprocalRate(conversionRate.getCtx(), conversionRate.getC_Conversion_Rate_ID(), conversionRate.get_TrxName())).isPresent() && reciprocalRate.getC_Conversion_Rate_ID() > 0) {
            reciprocalRate.deleteEx(true);
        }
        return null;
    }

    public String docValidate(PO po, int timing) {
        int currencyId;
        MOrgInfo organizationInfo = MOrgInfo.get((Properties)po.getCtx(), (int)po.getAD_Org_ID(), null);
        if (organizationInfo.get_ValueAsBoolean("IsValidateConversionRate") && timing == 7 && (currencyId = po.get_ValueAsInt("C_Currency_ID")) != 0) {
            int conversionTypeId = po.get_ValueAsInt("C_ConversionType_ID");
            Timestamp conversionDate = (Timestamp)po.get_Value("DateAcct");
            if (conversionDate == null) {
                conversionDate = (Timestamp)po.get_Value("DateDoc");
            }
            Optional.ofNullable(conversionDate).ifPresent(conversionDateToRun -> {
                String error;
                int currencyToId = MClient.get((Properties)po.getCtx()).getC_Currency_ID();
                int convertionRateId = MConversionRate.getConversionRateId((int)currencyId, (int)currencyToId, (Timestamp)conversionDateToRun, (int)conversionTypeId, (int)po.getAD_Client_ID(), (int)po.getAD_Org_ID());
                StringBuffer completeError = new StringBuffer();
                if (convertionRateId == -1) {
                    error = MConversionRate.getErrorMessage((Properties)po.getCtx(), (String)"ErrorConvertingDocumentCurrencyToBaseCurrency", (int)currencyId, (int)currencyToId, (int)conversionTypeId, (Timestamp)conversionDateToRun, (String)po.get_TrxName());
                    completeError.append(error);
                }
                if ((convertionRateId = MConversionRate.getConversionRateId((int)currencyToId, (int)currencyId, (Timestamp)conversionDateToRun, (int)conversionTypeId, (int)po.getAD_Client_ID(), (int)po.getAD_Org_ID())) == -1) {
                    error = MConversionRate.getErrorMessage((Properties)po.getCtx(), (String)"ErrorConvertingBaseCurrencyToDocumentCurrency", (int)currencyToId, (int)currencyId, (int)conversionTypeId, (Timestamp)conversionDateToRun, (String)po.get_TrxName());
                    if (completeError.length() > 0) {
                        completeError.append(Env.NL);
                    }
                    completeError.append(error);
                }
                if (completeError.length() > 0) {
                    throw new AdempiereException(completeError.toString());
                }
            });
        }
        return null;
    }

    private boolean isNegotiatedConversionRate(MConversionRate conversionRate) {
        AtomicReference<Boolean> result = new AtomicReference<Boolean>(false);
        Optional<MConversionType> maybeConversionType = Optional.ofNullable((MConversionType)conversionRate.getC_ConversionType());
        maybeConversionType.ifPresent(conversionType -> result.set(conversionType.get_ValueAsInt("ParentConversionType_ID") > 0));
        return result.get();
    }
}

