/*
 * Decompiled with CFR 0.152.
 */
package org.spin.eos.model;

import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.Env;
import org.spin.eos.model.X_EOS_ExchangeType;

public class MEOSExchangeType
extends X_EOS_ExchangeType {
    private static final long serialVersionUID = 5448641333159848635L;
    private static CCache<Integer, MEOSExchangeType> exchangeTypeCacheIds = new CCache("EOS_ExchangeType", 30);
    private static CCache<String, MEOSExchangeType> exchangeTypeCodes = new CCache("EOS_ExchangeType", 30);

    public MEOSExchangeType(Properties ctx, int exchangeTypeId, String trxName) {
        super(ctx, exchangeTypeId, trxName);
    }

    public MEOSExchangeType(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public static MEOSExchangeType getById(Properties ctx, int taxId, String trxName) {
        if (taxId <= 0) {
            return null;
        }
        MEOSExchangeType exchangeType = (MEOSExchangeType)exchangeTypeCacheIds.get((Object)taxId);
        if (exchangeType != null && exchangeType.get_ID() > 0) {
            return exchangeType;
        }
        exchangeType = (MEOSExchangeType)new Query(ctx, "EOS_ExchangeType", "EOS_ExchangeType_ID=?", trxName).setParameters(new Object[]{taxId}).first();
        if (exchangeType != null && exchangeType.get_ID() > 0) {
            int clientId = Env.getAD_Client_ID((Properties)ctx);
            String key = clientId + "#" + exchangeType.getValue();
            exchangeTypeCodes.put((Object)key, (Object)exchangeType);
            exchangeTypeCacheIds.put((Object)exchangeType.get_ID(), (Object)exchangeType);
        }
        return exchangeType;
    }

    public static MEOSExchangeType getByValue(Properties ctx, String value, String trxName) {
        String key;
        MEOSExchangeType exchangeType;
        if (value == null) {
            return null;
        }
        if (exchangeTypeCodes.size() == 0) {
            MEOSExchangeType.getAll(ctx, true, trxName);
        }
        if ((exchangeType = (MEOSExchangeType)exchangeTypeCodes.get((Object)(key = value))) != null && exchangeType.get_ID() > 0) {
            return exchangeType;
        }
        exchangeType = (MEOSExchangeType)new Query(ctx, "EOS_ExchangeType", "Value=?", trxName).setParameters(new Object[]{value}).first();
        if (exchangeType != null && exchangeType.get_ID() > 0) {
            exchangeTypeCodes.put((Object)key, (Object)exchangeType);
            exchangeTypeCacheIds.put((Object)exchangeType.get_ID(), (Object)exchangeType);
        }
        return exchangeType;
    }

    public static List<MEOSExchangeType> getAll(Properties ctx, boolean resetCache, String trxName) {
        if (resetCache || exchangeTypeCacheIds.size() > 0) {
            List exchangeTypeList = new Query(Env.getCtx(), "EOS_ExchangeType", null, trxName).setClient_ID().setOrderBy("Name").list();
            exchangeTypeList.stream().forEach(airport -> {
                String key = airport.getValue();
                exchangeTypeCacheIds.put((Object)airport.getEOS_ExchangeType_ID(), airport);
                exchangeTypeCodes.put((Object)key, airport);
            });
            return exchangeTypeList;
        }
        List<MEOSExchangeType> exchangeTypeList = exchangeTypeCacheIds.entrySet().stream().map(applicationType -> (MEOSExchangeType)applicationType.getValue()).collect(Collectors.toList());
        return exchangeTypeList;
    }

    @Override
    public String toString() {
        return "MEOSExchangeType [getEOS_ExchangeType_ID()=" + this.getEOS_ExchangeType_ID() + ", getName()=" + this.getName() + ", getValue()=" + this.getValue() + "]";
    }
}

