/*
 * Decompiled with CFR 0.152.
 */
package org.spin.eos.model;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Properties;
import org.compiere.model.CalloutEngine;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.MConversionRate;
import org.compiere.model.MCurrency;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.spin.eos.model.MEOSExchange;
import org.spin.eos.model.MEOSExchangeType;

public class ExchangeOperation
extends CalloutEngine {
    public String exchangeOnPayment(Properties ctx, int windowNo, GridTab tab, GridField field, Object value) {
        MEOSExchangeType exchangeType;
        Integer exchangeId = (Integer)value;
        if (exchangeId == null || exchangeId <= 0) {
            return "";
        }
        MEOSExchange exchange = new MEOSExchange(ctx, exchangeId, null);
        tab.setValue("C_ConversionType_ID", (Object)exchange.getC_ConversionType_ID());
        Object businessPartnerId = tab.getValue("C_BPartner_ID");
        if (businessPartnerId == null || (Integer)businessPartnerId == 0) {
            tab.setValue("C_BPartner_ID", (Object)exchange.getC_BPartner_ID());
        }
        if (!Util.isEmpty((String)exchange.getDescription())) {
            tab.setValue("Description", (Object)exchange.getDescription());
        }
        if ((exchangeType = MEOSExchangeType.getById(ctx, exchange.getEOS_ExchangeType_ID(), null)).getC_Charge_ID() != 0) {
            tab.setValue("C_Charge_ID", (Object)exchangeType.getC_Charge_ID());
        }
        return "";
    }

    public String exchangeTypeOnExchange(Properties ctx, int windowNo, GridTab tab, GridField field, Object value) {
        Integer exchangeTypeId = (Integer)value;
        if (exchangeTypeId == null || exchangeTypeId <= 0 || !field.getColumnName().equals("EOS_ExchangeType_ID")) {
            return "";
        }
        MEOSExchangeType exchangeType = MEOSExchangeType.getById(ctx, exchangeTypeId, null);
        tab.setValue("C_ConversionType_ID", (Object)exchangeType.getC_ConversionType_ID());
        if (!Util.isEmpty((String)exchangeType.getComments())) {
            tab.setValue("Description", (Object)exchangeType.getComments());
        }
        if (exchangeType.getCollectCurrency_ID() != 0) {
            tab.setValue("CollectCurrency_ID", (Object)exchangeType.getCollectCurrency_ID());
        }
        if (exchangeType.getPaymentCurrency_ID() != 0) {
            tab.setValue("PaymentCurrency_ID", (Object)exchangeType.getPaymentCurrency_ID());
        }
        BigDecimal collectAmount = (BigDecimal)tab.getValue("CollectAmount");
        BigDecimal paymentAmount = (BigDecimal)tab.getValue("PaymentAmount");
        if (collectAmount == null || collectAmount.equals(Env.ZERO) || paymentAmount == null || paymentAmount.equals(Env.ZERO)) {
            collectAmount = Env.ONE;
            paymentAmount = Env.ONE;
        }
        tab.setValue("CollectAmount", (Object)collectAmount);
        return "";
    }

    public String exchangeAmounOnExchange(Properties ctx, int windowNo, GridTab tab, GridField field, Object value) {
        if (!((field.getColumnName().equals("DateDoc") || field.getColumnName().equals("EOS_ExchangeType_ID") || field.getColumnName().equals("C_ConversionType_ID") || field.getColumnName().equals("CollectCurrency_ID") || field.getColumnName().equals("PaymentCurrency_ID") || field.getColumnName().equals("CollectAmount") || field.getColumnName().equals("PaymentAmount")) && value != null)) {
            return "";
        }
        return this.calulateConversionRate(ctx, tab, field.getColumnName(), value);
    }

    private String calulateConversionRate(Properties ctx, GridTab tab, String columnName, Object value) {
        int clientId = Env.getAD_Client_ID((Properties)ctx);
        Integer organizationId = (Integer)tab.getValue("AD_Org_ID");
        Integer exchangeTypeId = (Integer)tab.getValue("EOS_ExchangeType_ID");
        Integer conversionTypeId = (Integer)tab.getValue("C_ConversionType_ID");
        Integer collectCurrencyId = (Integer)tab.getValue("CollectCurrency_ID");
        Integer paymentCurrencyId = (Integer)tab.getValue("PaymentCurrency_ID");
        Timestamp documentDate = (Timestamp)tab.getValue("DateDoc");
        BigDecimal collectAmount = (BigDecimal)tab.getValue("CollectAmount");
        BigDecimal paymentAmount = (BigDecimal)tab.getValue("PaymentAmount");
        if (collectAmount == null) {
            collectAmount = Env.ONE;
        }
        if (paymentAmount == null) {
            paymentAmount = Env.ONE;
        }
        if (exchangeTypeId == null || exchangeTypeId == 0) {
            return "";
        }
        if (conversionTypeId == null || conversionTypeId == 0) {
            return "";
        }
        if (collectCurrencyId == null || collectCurrencyId == 0) {
            return "";
        }
        if (paymentCurrencyId == null || paymentCurrencyId == 0) {
            return "";
        }
        int conversionRateId = 0;
        if (collectCurrencyId.intValue() != paymentCurrencyId.intValue() && (conversionRateId = MConversionRate.getConversionRateId((int)collectCurrencyId, (int)paymentCurrencyId, (Timestamp)documentDate, (int)conversionTypeId, (int)clientId, (int)organizationId)) <= 0) {
            return Msg.parseTranslation((Properties)ctx, (String)"@C_Conversion_Rate_ID@ @NotFound@");
        }
        if (columnName.equals("PaymentAmount")) {
            MConversionRate conversionRate = MConversionRate.get((Properties)ctx, (int)conversionRateId);
            collectAmount = conversionRate.getDivideRate().multiply(paymentAmount);
            int stdPrecision = MCurrency.getStdPrecision((Properties)ctx, (int)collectCurrencyId);
            if (collectAmount.scale() > stdPrecision) {
                collectAmount = collectAmount.setScale(stdPrecision, 4);
            }
        } else {
            paymentAmount = MConversionRate.convert((Properties)ctx, (BigDecimal)collectAmount, (int)collectCurrencyId, (int)paymentCurrencyId, (Timestamp)documentDate, (int)conversionTypeId, (int)clientId, (int)organizationId);
        }
        tab.setValue("C_Conversion_Rate_ID", (Object)conversionRateId);
        tab.setValue("CollectAmount", (Object)collectAmount);
        tab.setValue("PaymentAmount", (Object)paymentAmount);
        return "";
    }

    public String revertCurrenciesOnExchange(Properties ctx, int windowNo, GridTab tab, GridField field, Object value) {
        if (value == null) {
            return "";
        }
        Integer collectCurrencyId = (Integer)tab.getValue("CollectCurrency_ID");
        Integer paymentCurrencyId = (Integer)tab.getValue("PaymentCurrency_ID");
        if (collectCurrencyId == null || collectCurrencyId == 0) {
            return "";
        }
        if (paymentCurrencyId == null || paymentCurrencyId == 0) {
            return "";
        }
        tab.setValue("PaymentCurrency_ID", (Object)collectCurrencyId);
        tab.setValue("CollectCurrency_ID", (Object)paymentCurrencyId);
        return "";
    }
}

