/*
 * Decompiled with CFR 0.152.
 */
package org.spin.consignment.util;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.compiere.model.MConversionRate;
import org.compiere.model.MCurrency;
import org.compiere.model.MInventoryLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProductPO;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.Env;

public class ConsignedMaterialUtil {
    public static final String COLUMNNAME_PriceLastLanded = "PriceLastLanded";

    public static final List<MOrderLine> getLinkedSalesOrderLinesFromInvoice(Properties context, int invoiceId, String transactionName) {
        return new Query(context, "C_OrderLine", "EXISTS(SELECT 1 FROM C_InvoiceLine il WHERE il.C_Invoice_ID = ? AND il.C_OrderLine_ID = C_OrderLine.Link_OrderLine_ID)", transactionName).setParameters(new Object[]{invoiceId}).list();
    }

    public static final List<MInventoryLine> getLinkedInventoryLineFromInvoice(Properties context, int invoiceId, String transactionName) {
        return new Query(context, "M_InventoryLine", "EXISTS(SELECT 1 FROM C_InvoiceLine il WHERE il.C_Invoice_ID = ? AND il.C_OrderLine_ID = M_InventoryLine.Link_OrderLine_ID)", transactionName).setParameters(new Object[]{invoiceId}).list();
    }

    public static final List<MOrderLine> getLinkedSalesOrderLinesFromPurchaseOrder(Properties context, int purchaseOrderId, String transactionName) {
        return new Query(context, "C_OrderLine", "EXISTS(SELECT 1 FROM C_Order lo INNER JOIN C_OrderLine lol ON(lol.C_Order_ID = lo.C_Order_ID) WHERE lo.C_Order_ID = ? AND lol.C_OrderLine_ID = C_OrderLine.Link_OrderLine_ID)", transactionName).setParameters(new Object[]{purchaseOrderId}).list();
    }

    public static final List<MInventoryLine> getLinkedInventoryLinesFromPurchaseOrder(Properties context, int purchaseOrderId, String transactionName) {
        return new Query(context, "M_InventoryLine", "EXISTS(SELECT 1 FROM C_Order lo INNER JOIN C_OrderLine lol ON(lol.C_Order_ID = lo.C_Order_ID) WHERE lo.C_Order_ID = ? AND lol.C_OrderLine_ID = M_InventoryLine.Link_OrderLine_ID)", transactionName).setParameters(new Object[]{purchaseOrderId}).list();
    }

    public static final List<MOrderLine> getLinkedSalesOrderLinesFromInvoiceLine(Properties context, int invoiceLineId, String transactionName) {
        return new Query(context, "C_OrderLine", "EXISTS(SELECT 1 FROM C_InvoiceLine il WHERE il.C_InvoiceLine_ID = ? AND il.C_OrderLine_ID = C_OrderLine.Link_OrderLine_ID)", transactionName).setParameters(new Object[]{invoiceLineId}).list();
    }

    public static final List<MInventoryLine> getLinkedInventoryLinesFromInvoiceLine(Properties context, int invoiceLineId, String transactionName) {
        return new Query(context, "M_InventoryLine", "EXISTS(SELECT 1 FROM C_InvoiceLine il WHERE il.C_InvoiceLine_ID = ? AND il.C_OrderLine_ID = M_InventoryLine.Link_OrderLine_ID)", transactionName).setParameters(new Object[]{invoiceLineId}).list();
    }

    public static final void recalculateInvoiceLineRate(MInvoiceLine invoiceLine) {
        if (invoiceLine.getC_OrderLine_ID() > 0 && !invoiceLine.isProcessed()) {
            MOrderLine orderLine = (MOrderLine)invoiceLine.getC_OrderLine();
            MOrder order = orderLine.getParent();
            MInvoice invoice = invoiceLine.getParent();
            if (invoice.getC_Currency_ID() != order.getC_Currency_ID() && !invoice.isReversal()) {
                int conversionTypeId = invoice.getC_ConversionType_ID();
                if (conversionTypeId <= 0) {
                    conversionTypeId = order.getC_ConversionType_ID();
                }
                BigDecimal orderPriceList = Optional.ofNullable(orderLine.getPriceList()).orElse(Env.ZERO);
                BigDecimal orderPriceActual = Optional.ofNullable(orderLine.getPriceActual()).orElse(Env.ZERO);
                BigDecimal orderPriceEntered = Optional.ofNullable(orderLine.getPriceEntered()).orElse(Env.ZERO);
                BigDecimal conversionRate = Optional.ofNullable(MConversionRate.getRate((int)order.getC_Currency_ID(), (int)invoice.getC_Currency_ID(), (Timestamp)invoice.getDateAcct(), (int)conversionTypeId, (int)invoice.getAD_Client_ID(), (int)invoice.getAD_Org_ID())).orElse(Env.ZERO);
                MCurrency currencyTo = MCurrency.get((Properties)invoice.getCtx(), (int)invoice.getC_Currency_ID());
                BigDecimal invoicePriceList = orderPriceList.multiply(conversionRate).setScale(currencyTo.getStdPrecision(), 4);
                BigDecimal invoicePriceActual = orderPriceActual.multiply(conversionRate).setScale(currencyTo.getStdPrecision(), 4);
                BigDecimal invoicePriceEntered = orderPriceEntered.multiply(conversionRate).setScale(currencyTo.getStdPrecision(), 4);
                invoiceLine.setPriceList(invoicePriceList);
                invoiceLine.setPriceActual(invoicePriceActual);
                invoiceLine.setPriceEntered(invoicePriceEntered);
                invoiceLine.setLineNetAmt();
                invoiceLine.setTaxAmt();
            }
        }
    }

    public static final void setPriceLimitFromLastPurchase(MInvoiceLine invoiceLine) {
        if (!invoiceLine.isProcessed() && invoiceLine.getM_Product_ID() > 0) {
            MInvoice invoice = invoiceLine.getParent();
            Optional<MProductPO> purchasedProduct = Arrays.asList(MProductPO.getOfProduct((Properties)invoiceLine.getCtx(), (int)invoiceLine.getM_Product_ID(), (String)invoiceLine.get_TrxName())).stream().filter(purchase -> !purchase.isDiscontinued()).sorted(Comparator.comparing(PO::getUpdated).reversed()).findFirst();
            purchasedProduct.ifPresent(purchase -> {
                BigDecimal convertedPrice = MConversionRate.convert((Properties)invoice.getCtx(), (BigDecimal)purchase.getPricePO(), (int)purchase.getC_Currency_ID(), (int)invoice.getC_Currency_ID(), (Timestamp)invoice.getDateInvoiced(), (int)invoice.getC_ConversionType_ID(), (int)invoice.getAD_Client_ID(), (int)invoice.getAD_Org_ID());
                Optional.ofNullable(convertedPrice).ifPresent(convertedPriceToSet -> invoiceLine.setPriceLimit(convertedPriceToSet));
            });
        }
    }
}

