/*
 * Decompiled with CFR 0.152.
 */
package org.spin.consignment.process;

import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.I_C_Invoice;
import org.compiere.model.MInvoice;
import org.spin.consignment.process.RecalculateRateForInvoiceLinesAbstract;
import org.spin.consignment.util.ConsignedMaterialUtil;

public class RecalculateRateForInvoiceLines
extends RecalculateRateForInvoiceLinesAbstract {
    @Override
    protected void prepare() {
        super.prepare();
        if (this.getRecord_ID() <= 0) {
            throw new AdempiereException("@C_Invoice_ID@ @NotFound@");
        }
        if (this.getTable_ID() != I_C_Invoice.Table_ID) {
            throw new AdempiereException("@C_Invoice_ID@ @IsMandatory@");
        }
    }

    protected String doIt() throws Exception {
        MInvoice invoice = new MInvoice(this.getCtx(), this.getRecord_ID(), this.get_TrxName());
        AtomicInteger counter = new AtomicInteger();
        Arrays.asList(invoice.getLines(true)).forEach(invoiceLine -> {
            ConsignedMaterialUtil.recalculateInvoiceLineRate(invoiceLine);
            invoiceLine.saveEx();
            counter.incrementAndGet();
        });
        return "@Processed@: " + counter;
    }
}

