/*
 * Decompiled with CFR 0.152.
 */
package org.spin.consignment.process;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MDocType;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInventoryLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.MUOM;
import org.compiere.model.MUOMConversion;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.spin.consignment.process.CreateAPInvoiceFromInventoryDropShipmentAbstract;

public class CreateAPInvoiceFromInventoryDropShipment
extends CreateAPInvoiceFromInventoryDropShipmentAbstract {
    private AtomicInteger created = new AtomicInteger();
    private Map<Integer, MInvoiceLine> invoiceLines = new HashMap<Integer, MInvoiceLine>();
    private MInvoice invoice;
    private BigDecimal documentMultiplier = Env.ONE;

    @Override
    protected void prepare() {
        super.prepare();
        if (this.getRecord_ID() == 0) {
            throw new AdempiereException("@C_Invoice_ID@ @NotFound@");
        }
        this.invoice = new MInvoice(this.getCtx(), this.getRecord_ID(), this.get_TrxName());
        if (this.invoice.isProcessed()) {
            throw new AdempiereException("@C_Invoice_ID@ @Processed@");
        }
        MDocType invoiceDocumentType = MDocType.get((Properties)this.getCtx(), (int)this.invoice.getC_DocTypeTarget_ID());
        if (invoiceDocumentType.getDocBaseType().equals("APC")) {
            this.documentMultiplier = this.documentMultiplier.negate();
        }
    }

    protected String doIt() throws Exception {
        this.getSelectionKeys().forEach(inventoryLineId -> {
            int purchaseOrderLineId = this.getSelectionAsInt((int)inventoryLineId, "CD_C_OrderLine_ID");
            MInventoryLine inventoryLine = new MInventoryLine(this.getCtx(), inventoryLineId.intValue(), this.get_TrxName());
            MOrderLine purchaseOrderLine = new MOrderLine(this.getCtx(), purchaseOrderLineId, this.get_TrxName());
            String whereClause = "EXISTS (SELECT 1 FROM M_InOut io WHERE io.M_InOut_ID = M_InOutLine.M_InOut_ID AND io.DocStatus IN ('CO','CL'))";
            MInOutLine[] inOutLines = MInOutLine.getOfOrderLine((Properties)Env.getCtx(), (int)purchaseOrderLineId, (String)whereClause, (String)this.get_TrxName());
            this.log.fine("Receipt Lines with OrderLine = #" + inOutLines.length);
            MInOutLine inOutLine = Arrays.stream(inOutLines).filter(ioLine -> ioLine != null && ioLine.getMovementQty().compareTo(inventoryLine.getQtyInternalUse()) == 0).findFirst().orElseGet(() -> inOutLines.length > 0 ? inOutLines[0] : null);
            MInvoiceLine invoiceLine = this.invoiceLines.get(purchaseOrderLineId);
            BigDecimal qtyEntered = Env.ZERO;
            BigDecimal qtyInvoiced = Env.ZERO;
            int uOMId = purchaseOrderLine.getC_UOM_ID();
            if (invoiceLine == null) {
                invoiceLine = new MInvoiceLine(this.invoice);
                if (inOutLine != null) {
                    invoiceLine.setShipLine(inOutLine);
                } else {
                    invoiceLine.setOrderLine(purchaseOrderLine);
                }
                qtyInvoiced = inventoryLine.getQtyInternalUse().multiply(this.documentMultiplier);
                invoiceLine.addDescription(Msg.parseTranslation((Properties)this.getCtx(), (String)"@Created@ @from@ @C_Invoice_ID@ ") + inventoryLine.getParent().getDocumentNo() + " (" + DisplayType.getNumberFormat((int)12).format(qtyInvoiced) + ")");
                this.invoiceLines.put(purchaseOrderLineId, invoiceLine);
            } else {
                qtyInvoiced = invoiceLine.getQtyInvoiced().add(inventoryLine.getQtyInternalUse().multiply(this.documentMultiplier));
                invoiceLine.addDescription(inventoryLine.getParent().getDocumentNo() + " (" + DisplayType.getNumberFormat((int)12).format(qtyInvoiced) + ")");
            }
            MProduct product = MProduct.get((Properties)Env.getCtx(), (int)invoiceLine.getM_Product_ID());
            if (uOMId != product.getC_UOM_ID()) {
                MUOM orderUom = MUOM.get((Properties)this.getCtx(), (int)uOMId);
                qtyEntered = MUOMConversion.convertProductFrom((Properties)this.getCtx(), (int)product.getM_Product_ID(), (int)uOMId, (BigDecimal)qtyInvoiced);
                if (qtyEntered == null) {
                    qtyEntered = qtyInvoiced;
                }
                qtyEntered = qtyEntered.setScale(orderUom.getStdPrecision(), 5);
            } else {
                qtyEntered = qtyInvoiced;
            }
            invoiceLine.setQtyEntered(qtyEntered);
            invoiceLine.setQtyInvoiced(qtyInvoiced);
            invoiceLine.setC_UOM_ID(uOMId);
            invoiceLine.saveEx();
            inventoryLine.set_ValueOfColumn("Link_OrderLine_ID", (Object)purchaseOrderLineId);
            inventoryLine.addDescription(Msg.parseTranslation((Properties)this.getCtx(), (String)"@POReference@ ") + purchaseOrderLine.getParent().getDocumentNo());
            inventoryLine.saveEx();
            this.created.getAndIncrement();
        });
        return "@Created@ " + this.created;
    }
}

