/*
 * Decompiled with CFR 0.152.
 */
package org.spin.consignment.process;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.compiere.model.MCurrency;
import org.compiere.model.MProductPO;
import org.compiere.util.Env;
import org.spin.consignment.process.ApplyLandedCostToProductPOAbstract;

public class ApplyLandedCostToProductPO
extends ApplyLandedCostToProductPOAbstract {
    private AtomicInteger updated = new AtomicInteger();

    protected String doIt() throws Exception {
        if (Optional.ofNullable(this.getPercentage()).orElse(Env.ZERO).compareTo(Env.ZERO) > 0) {
            this.getSelectionKeys().forEach(productId -> {
                Arrays.asList(MProductPO.getOfProduct((Properties)this.getCtx(), (int)productId, (String)this.get_TrxName())).forEach(purchaseProduct -> {
                    BigDecimal landedCostPrice = Optional.ofNullable(purchaseProduct.getPricePO()).orElse(Env.ZERO);
                    landedCostPrice = landedCostPrice.multiply(this.getPercentage()).divide(Env.ONEHUNDRED, MathContext.DECIMAL128).setScale(MCurrency.getStdPrecision((Properties)this.getCtx(), (int)purchaseProduct.getC_Currency_ID()), RoundingMode.HALF_UP);
                    purchaseProduct.set_ValueOfColumn("PriceLastLanded", (Object)landedCostPrice);
                    purchaseProduct.saveEx();
                });
                this.updated.getAndIncrement();
            });
        }
        return "@Updated@ " + this.updated;
    }
}

