/*
 * Decompiled with CFR 0.152.
 */
package org.spin.consignment.model.validator;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.compiere.acct.Fact;
import org.compiere.model.FactsValidator;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MClient;
import org.compiere.model.MDocType;
import org.compiere.model.MInventory;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MOrder;
import org.compiere.model.MProduct;
import org.compiere.model.MProductPO;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.spin.consignment.util.ConsignedMaterialUtil;

public class ConsignedMaterial
implements ModelValidator,
FactsValidator {
    private static CLogger log = CLogger.getCLogger(ConsignedMaterial.class);
    private int clientId = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.clientId = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addDocValidate("C_Order", (ModelValidator)this);
        engine.addDocValidate("C_Invoice", (ModelValidator)this);
        engine.addModelChange("C_Invoice", (ModelValidator)this);
        engine.addModelChange("C_InvoiceLine", (ModelValidator)this);
        engine.addModelChange("C_Order", (ModelValidator)this);
        engine.addModelChange("M_Inventory", (ModelValidator)this);
        engine.addModelChange("M_Product_PO", (ModelValidator)this);
        engine.addFactsValidate("M_InOut", (FactsValidator)this);
        engine.addFactsValidate("M_MatchInv", (FactsValidator)this);
    }

    public int getAD_Client_ID() {
        return this.clientId;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public String modelChange(PO entity, int type) throws Exception {
        if (type == 3) {
            MInvoiceLine invoiceLine;
            MInvoice invoice;
            if (entity.get_TableName().equals("C_InvoiceLine") && !(invoice = (invoiceLine = (MInvoiceLine)entity).getParent()).isSOTrx()) {
                ConsignedMaterialUtil.getLinkedSalesOrderLinesFromInvoiceLine(invoiceLine.getCtx(), invoiceLine.getC_InvoiceLine_ID(), invoiceLine.get_TrxName()).forEach(orderLine -> {
                    orderLine.setLink_OrderLine_ID(-1);
                    orderLine.saveEx(invoiceLine.get_TrxName());
                });
                ConsignedMaterialUtil.getLinkedInventoryLinesFromInvoiceLine(invoiceLine.getCtx(), invoiceLine.getC_InvoiceLine_ID(), invoiceLine.get_TrxName()).forEach(inventoryLine -> {
                    inventoryLine.set_ValueOfColumn("Link_OrderLine_ID", null);
                    inventoryLine.saveEx(invoiceLine.get_TrxName());
                });
            }
        } else if (type == 1 || type == 2) {
            if (entity.get_TableName().equals("C_InvoiceLine")) {
                MInvoiceLine invoiceLine;
                if ((entity.is_new() || entity.is_ValueChanged("C_OrderLine_ID")) && !(invoiceLine = (MInvoiceLine)entity).getParent().isSOTrx()) {
                    ConsignedMaterialUtil.recalculateInvoiceLineRate(invoiceLine);
                }
            } else if (entity.get_TableName().equals("C_Order")) {
                MOrder purchaseOrder = (MOrder)entity;
                if (!purchaseOrder.isSOTrx() && purchaseOrder.getC_DocTypeTarget_ID() > 0 && (purchaseOrder.is_new() || purchaseOrder.is_ValueChanged("C_DocTypeTarget_ID"))) {
                    MDocType documentType = MDocType.get((Properties)purchaseOrder.getCtx(), (int)purchaseOrder.getC_DocTypeTarget_ID());
                    purchaseOrder.setIsDropShip(documentType.get_ValueAsBoolean("IsDropShip"));
                }
            } else if (entity.get_TableName().equals("M_Inventory")) {
                MInventory inventory = (MInventory)entity;
                if (inventory.getC_DocType_ID() > 0 && (inventory.is_new() || inventory.is_ValueChanged("C_DocType_ID"))) {
                    MDocType documentType = MDocType.get((Properties)inventory.getCtx(), (int)inventory.getC_DocType_ID());
                    inventory.set_ValueOfColumn("IsDropShip", (Object)documentType.get_ValueAsBoolean("IsDropShip"));
                }
            } else if (entity.get_TableName().equals("M_Product_PO") && (entity.is_new() || entity.is_ValueChanged("PriceLastLanded"))) {
                MProductPO purchaseProduct = (MProductPO)entity;
                BigDecimal purchasePrice = Optional.ofNullable(purchaseProduct.getPricePO()).orElse(Env.ZERO);
                BigDecimal landedCostPrice = Optional.ofNullable((BigDecimal)purchaseProduct.get_Value("PriceLastLanded")).orElse(Env.ZERO);
                purchaseProduct.setPricePO(purchasePrice.add(landedCostPrice));
            }
        }
        return null;
    }

    public String docValidate(PO entity, int timing) {
        if (timing == 7) {
            MInvoice invoice;
            if (entity.get_TableName().equals("C_Order")) {
                MOrder order = (MOrder)entity;
                if (!order.isSOTrx()) {
                    Arrays.asList(order.getLines()).stream().filter(orderLine -> orderLine.getM_Product_ID() > 0).forEach(orderLine -> {
                        List purchaseProductList = MProductPO.getByPartner((Properties)orderLine.getCtx(), (Integer)order.getC_BPartner_ID(), (Integer)orderLine.getM_Product_ID(), (String)order.get_TrxName());
                        Optional<MProductPO> maybePurchaseProduct = purchaseProductList.stream().filter(puchaseProduct -> puchaseProduct.getC_Currency_ID() == order.getC_Currency_ID()).findFirst();
                        if (maybePurchaseProduct.isPresent()) {
                            MProductPO purchaseProductToUpdate = maybePurchaseProduct.get();
                            purchaseProductToUpdate.setPriceList(orderLine.getPriceActual());
                            purchaseProductToUpdate.setPricePO(orderLine.getPriceActual());
                            purchaseProductToUpdate.setPriceLastPO(orderLine.getPriceActual());
                            purchaseProductToUpdate.setIsActive(true);
                            purchaseProductToUpdate.setIsCurrentVendor(true);
                            purchaseProductToUpdate.saveEx();
                        } else {
                            MProduct product = MProduct.get((Properties)order.getCtx(), (int)orderLine.getM_Product_ID());
                            MProductPO purchaseProductToCreate = new MProductPO(order.getCtx(), orderLine.getM_Product_ID(), order.getC_BPartner_ID(), order.getC_Currency_ID(), order.get_TrxName());
                            purchaseProductToCreate.setVendorProductNo(product.getValue());
                            purchaseProductToCreate.setC_UOM_ID(product.getC_UOM_ID());
                            purchaseProductToCreate.setUPC(product.getUPC());
                            purchaseProductToCreate.setPriceList(orderLine.getPriceList());
                            purchaseProductToCreate.setPricePO(orderLine.getPriceActual());
                            purchaseProductToCreate.setPriceLastPO(orderLine.getPriceActual());
                            purchaseProductToCreate.setIsCurrentVendor(true);
                            purchaseProductToCreate.saveEx();
                        }
                    });
                }
            } else if (entity.get_TableName().equals("C_Invoice") && (invoice = (MInvoice)entity).isSOTrx()) {
                Arrays.asList(invoice.getLines(true)).stream().filter(invoiceLine -> invoiceLine.getM_Product_ID() > 0 && Optional.ofNullable(invoiceLine.getPriceLimit()).orElse(Env.ZERO).compareTo(Env.ZERO) == 0).forEach(invoiceLine -> {
                    ConsignedMaterialUtil.setPriceLimitFromLastPurchase(invoiceLine);
                    invoiceLine.saveEx();
                });
            }
        } else if (timing == 13 || timing == 14 || timing == 10) {
            MOrder purchaseOrder;
            if (entity.get_TableName().equals("C_Invoice")) {
                MInvoice invoice = (MInvoice)entity;
                if (!invoice.isSOTrx()) {
                    ConsignedMaterialUtil.getLinkedSalesOrderLinesFromInvoice(invoice.getCtx(), invoice.getC_Invoice_ID(), invoice.get_TrxName()).forEach(orderLine -> {
                        orderLine.setLink_OrderLine_ID(-1);
                        orderLine.saveEx(invoice.get_TrxName());
                    });
                    ConsignedMaterialUtil.getLinkedInventoryLinesFromInvoiceLine(invoice.getCtx(), invoice.getC_Invoice_ID(), invoice.get_TrxName()).forEach(inventoryLine -> {
                        inventoryLine.set_ValueOfColumn("Link_OrderLine_ID", null);
                        inventoryLine.saveEx(invoice.get_TrxName());
                    });
                }
            } else if (entity.get_TableName().equals("C_Order") && !(purchaseOrder = (MOrder)entity).isSOTrx()) {
                ConsignedMaterialUtil.getLinkedSalesOrderLinesFromPurchaseOrder(purchaseOrder.getCtx(), purchaseOrder.getC_Order_ID(), purchaseOrder.get_TrxName()).forEach(orderLine -> {
                    orderLine.setLink_OrderLine_ID(-1);
                    orderLine.saveEx(purchaseOrder.get_TrxName());
                });
                ConsignedMaterialUtil.getLinkedInventoryLinesFromPurchaseOrder(purchaseOrder.getCtx(), purchaseOrder.getC_Order_ID(), purchaseOrder.get_TrxName()).forEach(inventoryLine -> {
                    inventoryLine.set_ValueOfColumn("Link_OrderLine_ID", null);
                    inventoryLine.saveEx(purchaseOrder.get_TrxName());
                });
            }
        }
        return null;
    }

    public String factsValidate(MAcctSchema schema, List<Fact> facts, PO po) {
        Optional.ofNullable(po).ifPresent(entity -> {
            if (entity.get_TableName().equals("M_InOut") || entity.get_TableName().equals("M_MatchInv")) {
                facts.forEach(fact -> Arrays.asList(fact.getLines()).stream().forEach(fLine -> {
                    if (fLine.getM_Product_ID() != 0) {
                        Optional.ofNullable(MProduct.get((Properties)entity.getCtx(), (int)fLine.getM_Product_ID())).ifPresent(product -> {
                            if (product.isDropShip()) {
                                fLine.setAmtSourceCr(Env.ZERO);
                                fLine.setAmtSourceDr(Env.ZERO);
                                fLine.setAmtAcctCr(Env.ZERO);
                                fLine.setAmtAcctDr(Env.ZERO);
                            }
                        });
                    }
                }));
            }
        });
        return null;
    }
}

