/*
 * Decompiled with CFR 0.152.
 */
package org.spin.mm.util.counting;

import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.compiere.model.MInventory;
import org.compiere.model.MStorage;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.spin.mm.util.CountInfo;
import org.spin.mm.util.ICustomCount;

public class SalesBasedCounting
implements ICustomCount {
    @Override
    public List<CountInfo> getCountList(Properties context, int warehouseId, int productId, int productCategoryId, int productGroupId, int productClassId, int productClassificationId, int inventoryId, Timestamp transactionDate, String transactionName, Map<String, Object> parameters) {
        MInventory lastInventory = (MInventory)new Query(context, "M_Inventory", "DocStatus IN('CO', 'CL') AND M_Warehouse_ID = ? AND MovementDate < ?", transactionName).setParameters(new Object[]{warehouseId, transactionDate}).setClient_ID().setOrderBy("MovementDate").first();
        Timestamp lastInventoryDate = TimeUtil.getDay((long)System.currentTimeMillis());
        if (lastInventory != null && lastInventory.getM_Inventory_ID() > 0) {
            lastInventoryDate = lastInventory.getMovementDate();
        }
        return new Query(context, "M_Storage", "EXISTS(SELECT 1 FROM C_InvoiceLine il INNER JOIN C_OrderLine ol ON(ol.C_OrderLine_ID = il.C_OrderLine_ID) WHERE il.M_Product_ID = M_Storage.M_Product_ID AND il.Processed = 'Y' AND ol.M_Warehouse_ID = ? AND ol.DateOrdered >= ? AND ol.DateOrdered <= ?)", transactionName).setParameters(new Object[]{warehouseId, lastInventoryDate, transactionDate}).getIDsAsList().stream().map(storageId -> {
            MStorage storage = new MStorage(context, storageId.intValue(), transactionName);
            return new CountInfo().withProductId(storage.getM_Product_ID()).withLocatorId(storage.getM_Locator_ID()).withAttributeSetInstanceId(storage.getM_AttributeSetInstance_ID()).withQuantityCount(Env.ZERO);
        }).collect(Collectors.toList());
    }
}

