/*
 * Decompiled with CFR 0.152.
 */
package org.spin.mm.util;

import java.math.BigDecimal;
import java.util.Optional;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MProduct;
import org.compiere.model.MStorage;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class MaterialManagementImprovementsChanges {
    public static final String COLUMNNAME_IsValidateAvailability = "IsValidateAvailability";
    public static final String TABLENAME_M_CustomCountDefinition = "M_CustomCountDefinition";
    public static final String COLUMNNAME_CustomCountClass = "CustomCountClass";
    public static final String COLUMNNAME_Ref_WarehouseSource_ID = "Ref_WarehouseSource_ID";
    public static final String COLUMNNAME_Ref_ReplenishDOrderLine_ID = "Ref_ReplenishDOrderLine_ID";
    public static final String COLUMNNAME_Ref_ReplenishMovementLine_ID = "Ref_ReplenishMovementLine_ID";
    public static final String COLUMNNAME_Ref_ReplenishOrderLine_ID = "Ref_ReplenishOrderLine_ID";
    public static final String COLUMNNAME_IsDefinedAsClient = "IsDefinedAsClient";

    public static boolean validateStock(Properties context, int warehouseId, int locatorId, int productId, int attributeSetInstanceId, BigDecimal requestedQuantity, String transactionName) {
        BigDecimal quantityAvailable = Optional.ofNullable(MStorage.getQtyAvailable((int)warehouseId, (int)locatorId, (int)productId, (int)attributeSetInstanceId, (String)transactionName)).orElse(Env.ZERO);
        if (quantityAvailable.compareTo(requestedQuantity) < 0) {
            BigDecimal missingQuantity = requestedQuantity.subtract(quantityAvailable);
            throw new AdempiereException(Msg.getMsg((Properties)context, (String)"InsufficientStockAvailable", (Object[])new Object[]{requestedQuantity, quantityAvailable, missingQuantity}));
        }
        return true;
    }

    public static String validateStock(Properties context, int line, int warehouseId, int locatorId, int productId, int attributeSetInstanceId, BigDecimal requestedQuantity, String transactionName) {
        BigDecimal quantityAvailable = Optional.ofNullable(MStorage.getQtyAvailable((int)warehouseId, (int)locatorId, (int)productId, (int)attributeSetInstanceId, (String)transactionName)).orElse(Env.ZERO);
        if (quantityAvailable.compareTo(requestedQuantity) < 0) {
            BigDecimal missingQuantity = requestedQuantity.subtract(quantityAvailable);
            MProduct product = MProduct.get((Properties)context, (int)productId);
            return Msg.getMsg((Properties)context, (String)"InsufficientStockAvailableByLine", (Object[])new Object[]{line, product.getValue() + "-" + product.getName(), requestedQuantity, quantityAvailable, missingQuantity});
        }
        return null;
    }
}

