/*
 * Decompiled with CFR 0.152.
 */
package org.spin.mm.util;

import java.util.List;
import org.compiere.model.MProduct;
import org.compiere.model.MReplenish;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.Env;

public class DefaultReplenishmentUtil {
    public static final String TABLENAME_M_ReplenishCategory = "M_ReplenishCategory";

    public static void setReplenishmentFromCategory(MProduct product) {
        if (product == null) {
            return;
        }
        DefaultReplenishmentUtil.getReplenishForProduct(product).forEach(replenish -> replenish.delete(true));
        DefaultReplenishmentUtil.getReplenishmentFromProductCategory(product).forEach(replenishFromCategory -> {
            MReplenish productReplenishment = new MReplenish(product.getCtx(), 0, product.get_TrxName());
            productReplenishment.setM_Product_ID(product.getM_Product_ID());
            productReplenishment.setM_Warehouse_ID(replenishFromCategory.get_ValueAsInt("M_Warehouse_ID"));
            productReplenishment.setReplenishType(replenishFromCategory.get_ValueAsString("ReplenishType"));
            if (replenishFromCategory.get_ValueAsInt("M_Locator_ID") > 0) {
                productReplenishment.setM_Locator_ID(replenishFromCategory.get_ValueAsInt("M_Locator_ID"));
            }
            if (replenishFromCategory.get_ValueAsInt("M_WarehouseSource_ID") > 0) {
                productReplenishment.setM_WarehouseSource_ID(replenishFromCategory.get_ValueAsInt("M_WarehouseSource_ID"));
            }
            productReplenishment.setLevel_Min(Env.ZERO);
            productReplenishment.setLevel_Max(Env.ZERO);
            productReplenishment.setQtyBatchSize(Env.ZERO);
            productReplenishment.saveEx();
        });
    }

    public static List<PO> getReplenishmentFromProductCategory(MProduct product) {
        return new Query(product.getCtx(), TABLENAME_M_ReplenishCategory, "M_Product_Category_ID = ?", product.get_TrxName()).setParameters(new Object[]{product.getM_Product_Category_ID()}).setOnlyActiveRecords(true).list();
    }

    private static List<MReplenish> getReplenishForProduct(MProduct product) {
        return new Query(product.getCtx(), "M_Replenish", "M_Product_ID = ?", product.get_TrxName()).setParameters(new Object[]{product.getM_Product_ID()}).setClient_ID().list();
    }
}

