/*
 * Decompiled with CFR 0.152.
 */
package org.spin.mm.util;

import java.lang.reflect.Constructor;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.model.GenericPO;
import org.compiere.util.Util;
import org.spin.mm.util.ICustomCount;
import org.spin.util.ISetupDefinition;

public class CustomCountFactory {
    public static ICustomCount getCustomCountDefinition(Properties context, int customCountDefinitionId, String transactionName) {
        if (customCountDefinitionId <= 0) {
            throw new AdempiereException("@M_CustomCountDefinition_ID@ @NotFound@");
        }
        GenericPO customCountdefinition = new GenericPO("M_CustomCountDefinition", context, customCountDefinitionId, transactionName);
        if (Util.isEmpty((String)customCountdefinition.get_ValueAsString("CustomCountClass"))) {
            throw new AdempiereException("@CustomCountClass@ @NotFound@");
        }
        return CustomCountFactory.getInstance(customCountdefinition.get_ValueAsString("CustomCountClass"));
    }

    private static ICustomCount getInstance(String className) {
        if (Util.isEmpty((String)className)) {
            return null;
        }
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className);
            if (!ISetupDefinition.class.isAssignableFrom(clazz)) {
                for (Class<?> superClazz = clazz.getSuperclass(); superClazz != null && superClazz != ICustomCount.class; superClazz = superClazz.getSuperclass()) {
                }
            }
            if (clazz != null) {
                Constructor<?> constructor = clazz.getDeclaredConstructor(new Class[0]);
                return (ICustomCount)constructor.newInstance(new Object[0]);
            }
        }
        catch (Exception e) {
            throw new AdempiereException((Throwable)e);
        }
        return null;
    }
}

